/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.cluster.ContiguousDocumentalStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusterIndexReader;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;
import java.util.Arrays;

public class DocumentalConcatenatedClusterDocumentIterator
extends AbstractDocumentIterator
implements DocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    protected final DocumentIterator[] documentIterator;
    protected final int n;
    protected final int[] documentIteratorIndex;
    protected final ContiguousDocumentalStrategy strategy;
    protected int currentIterator;
    protected int lastIterator = -1;
    private final DocumentalClusterIndexReader indexReader;
    private final ReferenceArraySet<Index> indices = new ReferenceArraySet();

    public DocumentalConcatenatedClusterDocumentIterator(DocumentalClusterIndexReader indexReader, DocumentIterator[] documentIterator, int[] usedIndex) {
        this.documentIterator = documentIterator;
        this.n = documentIterator.length;
        this.indexReader = indexReader;
        this.documentIteratorIndex = usedIndex;
        this.strategy = (ContiguousDocumentalStrategy)indexReader.index.strategy;
        int i = this.n;
        while (i-- != 0) {
            if (!documentIterator[i].hasNext()) {
                throw new IllegalArgumentException("All component document iterators must be nonempty");
            }
            this.indices.addAll(documentIterator[i].indices());
        }
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        this.ensureOnADocument();
        return this.documentIterator[this.lastIterator].intervalIterator();
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        this.ensureOnADocument();
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.FALSE;
        }
        return this.documentIterator[this.lastIterator].intervalIterator(index);
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        this.ensureOnADocument();
        return this.documentIterator[this.lastIterator].intervalIterators();
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.indices;
    }

    @Override
    public int skipTo(int p) throws IOException {
        this.ahead = false;
        if (this.curr >= p) {
            return this.curr;
        }
        if (this.currentIterator == this.n || p >= this.indexReader.index.numberOfDocuments) {
            this.curr = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        int k = this.strategy.localIndex(p);
        while (this.currentIterator < this.n && this.documentIteratorIndex[this.currentIterator] < k) {
            ++this.currentIterator;
        }
        int globalResult = Integer.MAX_VALUE;
        if (this.currentIterator < this.n && (globalResult = this.documentIterator[this.currentIterator].skipTo(this.strategy.localPointer(p))) == Integer.MAX_VALUE && ++this.currentIterator < this.n) {
            globalResult = this.documentIterator[this.currentIterator].nextDocument();
        }
        this.lastIterator = globalResult == Integer.MAX_VALUE ? -1 : this.currentIterator;
        this.curr = globalResult == Integer.MAX_VALUE ? Integer.MAX_VALUE : this.strategy.globalPointer(this.documentIteratorIndex[this.currentIterator], globalResult);
        return this.curr;
    }

    @Override
    protected int nextDocumentInternal() throws IOException {
        int n;
        int result = this.documentIterator[this.currentIterator].nextDocument();
        if (result != -1) {
            this.lastIterator = this.currentIterator;
            this.curr = this.strategy.globalPointer(this.documentIteratorIndex[this.lastIterator], result);
            return this.curr;
        }
        ++this.currentIterator;
        if (this.currentIterator < this.n) {
            this.lastIterator = this.currentIterator;
            n = this.strategy.globalPointer(this.documentIteratorIndex[this.currentIterator], this.documentIterator[this.lastIterator].nextDocument());
        } else {
            n = Integer.MAX_VALUE;
        }
        this.curr = n;
        return DocumentalConcatenatedClusterDocumentIterator.toNextDocument(this.curr);
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) throws IOException {
        return this.documentIterator[this.lastIterator].accept(visitor);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) throws IOException {
        return this.documentIterator[this.lastIterator].acceptOnTruePaths(visitor);
    }

    @Override
    public void dispose() throws IOException {
        this.indexReader.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.documentIterator);
    }
}

