/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusterIndexReader;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusteringStrategy;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;

public class DocumentalMergedClusterDocumentIterator
extends AbstractDocumentIterator
implements DocumentIterator {
    protected final DocumentIterator[] documentIterator;
    protected final int n;
    protected final int[] usedIndex;
    protected final DocumentalClusteringStrategy strategy;
    protected final IntHeapSemiIndirectPriorityQueue queue;
    protected final int[] globalDocumentPointer;
    protected final ReferenceSet<Index> indices = new ReferenceArraySet();
    private final DocumentalClusterIndexReader indexReader;
    protected int currentIterator = -1;

    public DocumentalMergedClusterDocumentIterator(DocumentalClusterIndexReader indexReader, DocumentIterator[] documentIterator, int[] usedIndex) throws IOException {
        this.documentIterator = documentIterator;
        this.n = documentIterator.length;
        this.indexReader = indexReader;
        this.usedIndex = usedIndex;
        this.strategy = indexReader.index.strategy;
        this.globalDocumentPointer = new int[this.n];
        this.queue = new IntHeapSemiIndirectPriorityQueue(this.globalDocumentPointer, this.n);
        int i = this.n;
        while (i-- != 0) {
            int result = documentIterator[i].nextDocument();
            if (result == -1) continue;
            this.indices.addAll(documentIterator[i].indices());
            this.globalDocumentPointer[i] = this.strategy.globalPointer(usedIndex[i], result);
            this.queue.enqueue(i);
        }
        this.ahead = true;
        if (this.queue.isEmpty()) {
            this.curr = Integer.MAX_VALUE;
        } else {
            this.currentIterator = this.queue.first();
            this.curr = this.globalDocumentPointer[this.currentIterator];
        }
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        this.ensureOnADocument();
        return this.documentIterator[this.currentIterator].intervalIterator();
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        this.ensureOnADocument();
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.FALSE;
        }
        return this.documentIterator[this.currentIterator].intervalIterator(index);
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        this.ensureOnADocument();
        return this.documentIterator[this.currentIterator].intervalIterators();
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.indices;
    }

    @Override
    public int skipTo(int p) throws IOException {
        int i;
        this.ahead = false;
        if (this.curr >= p) {
            return this.curr;
        }
        if (p >= this.indexReader.index.numberOfDocuments) {
            this.curr = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while (!this.queue.isEmpty() && this.globalDocumentPointer[i = this.queue.first()] < p) {
            int d = this.documentIterator[i].skipTo(this.strategy.localPointer(p));
            if (d == Integer.MAX_VALUE) {
                this.queue.dequeue();
                continue;
            }
            this.globalDocumentPointer[i] = this.strategy.globalPointer(this.usedIndex[i], d);
            if (this.globalDocumentPointer[i] < p) {
                this.queue.dequeue();
                continue;
            }
            this.queue.changed();
        }
        if (this.queue.isEmpty()) {
            this.curr = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.currentIterator = this.queue.first();
        this.curr = this.globalDocumentPointer[this.currentIterator];
        return this.curr;
    }

    @Override
    protected int nextDocumentInternal() throws IOException {
        int n;
        int result = this.documentIterator[this.currentIterator].nextDocument();
        if (result != -1) {
            this.globalDocumentPointer[this.currentIterator] = this.strategy.globalPointer(this.usedIndex[this.currentIterator], result);
            this.queue.changed();
        } else {
            this.queue.dequeue();
        }
        if (this.queue.isEmpty()) {
            n = Integer.MAX_VALUE;
        } else {
            this.currentIterator = this.queue.first();
            n = this.globalDocumentPointer[this.currentIterator];
        }
        this.curr = n;
        return DocumentalMergedClusterDocumentIterator.toNextDocument(this.curr);
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) throws IOException {
        return this.documentIterator[this.currentIterator].accept(visitor);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) throws IOException {
        return this.documentIterator[this.currentIterator].acceptOnTruePaths(visitor);
    }

    @Override
    public void dispose() throws IOException {
        this.indexReader.close();
    }
}

