/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.cluster;

import com.martiansoftware.jsap.ParseException;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.mg4j.index.DiskBasedIndex;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.cluster.ChainedLexicalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.ClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalClusteringStrategy;
import it.unimi.dsi.mg4j.index.cluster.DocumentalConcatenatedCluster;
import it.unimi.dsi.mg4j.index.cluster.DocumentalMergedCluster;
import it.unimi.dsi.mg4j.index.cluster.LexicalCluster;
import it.unimi.dsi.mg4j.index.cluster.LexicalClusteringStrategy;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import it.unimi.dsi.util.BloomFilter;
import it.unimi.dsi.util.Properties;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.EnumMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public abstract class IndexCluster
extends Index {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Util.getLogger(IndexCluster.class);
    public static final String STRATEGY_DEFAULT_EXTENSION = ".strategy";
    public static final String BLOOM_EXTENSION = ".bloom";
    protected final Index[] localIndex;
    protected final BloomFilter[] termFilter;

    protected IndexCluster(Index[] localIndex, BloomFilter[] termFilter, int numberOfDocuments, int numberOfTerms, long numberOfPostings, long numberOfOccurrences, int maxCount, Payload payload, boolean hasCounts, boolean hasPositions, TermProcessor termProcessor, String field, IntList sizes, Properties properties) {
        super(numberOfDocuments, numberOfTerms, numberOfPostings, numberOfOccurrences, maxCount, payload, hasCounts, hasPositions, termProcessor, field, sizes, properties);
        this.localIndex = localIndex;
        this.termFilter = termFilter;
        for (int i = 0; i < localIndex.length; ++i) {
            localIndex[i].keyIndex(this);
        }
    }

    public static Index getInstance(CharSequence basename, boolean randomAccess, boolean documentSizes, EnumMap<Index.UriKeys, String> queryProperties) throws ConfigurationException, IOException, ClassNotFoundException, SecurityException, URISyntaxException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        IntList sizes;
        Properties properties = new Properties(basename + ".properties");
        ClusteringStrategy strategy = null;
        Class strategyClass = null;
        if (properties.containsKey((Enum)PropertyKeys.STRATEGY)) {
            strategy = (ClusteringStrategy)BinIO.loadObject((CharSequence)properties.getString((Enum)PropertyKeys.STRATEGY));
        } else if (properties.containsKey((Enum)PropertyKeys.STRATEGYCLASS)) {
            try {
                strategyClass = (Class)MG4JClassParser.getParser().parse(properties.getString((Enum)PropertyKeys.STRATEGYCLASS));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Cluster properties must contain either a strategy or a strategy class property");
        }
        Class<?> indexClass = Class.forName(properties.getString((Enum)Index.PropertyKeys.INDEXCLASS, "(missing index class)"));
        String[] localBasename = properties.getStringArray((Enum)PropertyKeys.LOCALINDEX);
        Index[] localIndex = new Index[localBasename.length];
        for (int i = 0; i < localIndex.length; ++i) {
            localIndex[i] = Index.getInstance(localBasename[i], randomAccess, documentSizes);
        }
        int numberOfDocuments = properties.getInt((Enum)Index.PropertyKeys.DOCUMENTS);
        IntList intList = sizes = queryProperties != null && queryProperties.containsKey((Object)Index.UriKeys.SIZES) ? DiskBasedIndex.readSizes(queryProperties.get((Object)Index.UriKeys.SIZES), numberOfDocuments) : null;
        if (sizes != null && documentSizes) {
            LOGGER.warn((Object)"You are loading both local sizes and a global size file specified by the \"size\" properties, which is usually nonsensical");
        }
        boolean hasCounts = true;
        boolean hasPositions = true;
        Payload payload = null;
        for (int i = 0; i < localIndex.length; ++i) {
            hasCounts = hasCounts && localIndex[i].hasCounts;
            boolean bl = hasPositions = hasPositions && localIndex[i].hasPositions;
            if (i == 0) {
                payload = localIndex[i].payload;
            }
            if (payload == null == (localIndex[i].payload == null) && (payload == null || payload.compatibleWith(localIndex[i].payload))) continue;
            throw new IllegalStateException("The payload specification of index " + localIndex[0] + " is not compatible with that of index " + localIndex[i]);
        }
        BloomFilter[] termFilter = null;
        if (properties.getBoolean((Enum)PropertyKeys.BLOOM)) {
            LOGGER.debug((Object)"Loading Bloom filters...");
            termFilter = new BloomFilter[localIndex.length];
            for (int i = 0; i < localIndex.length; ++i) {
                termFilter[i] = (BloomFilter)BinIO.loadObject((CharSequence)(basename + "-" + i + BLOOM_EXTENSION));
            }
            LOGGER.debug((Object)"Completed.");
        }
        if (strategyClass != null) {
            strategy = (ClusteringStrategy)strategyClass.getConstructor(Index[].class, BloomFilter[].class).newInstance(localIndex, termFilter);
        } else if (strategy instanceof ChainedLexicalClusteringStrategy) {
            strategy = new ChainedLexicalClusteringStrategy(localIndex, termFilter);
        } else if (strategy.numberOfLocalIndices() != localBasename.length) {
            throw new IllegalArgumentException("The number of local indices of the strategy (" + localIndex.length + ") and the number of local indices specified by the property file (" + localBasename.length + ") differ");
        }
        if (LexicalCluster.class.isAssignableFrom(indexClass)) {
            return new LexicalCluster(localIndex, (LexicalClusteringStrategy)strategy, termFilter, numberOfDocuments, properties.getInt((Enum)Index.PropertyKeys.TERMS), properties.getLong((Enum)Index.PropertyKeys.POSTINGS), properties.getLong((Enum)Index.PropertyKeys.OCCURRENCES), properties.getInt((Enum)Index.PropertyKeys.MAXCOUNT), payload, hasCounts, hasPositions, Index.getTermProcessor(properties), properties.getString((Enum)Index.PropertyKeys.FIELD), sizes, properties);
        }
        if (DocumentalCluster.class.isAssignableFrom(indexClass)) {
            if (DocumentalConcatenatedCluster.class.isAssignableFrom(indexClass)) {
                return new DocumentalConcatenatedCluster(localIndex, (DocumentalClusteringStrategy)strategy, properties.getBoolean((Enum)PropertyKeys.FLAT), termFilter, numberOfDocuments, properties.getInt((Enum)Index.PropertyKeys.TERMS), properties.getLong((Enum)Index.PropertyKeys.POSTINGS), properties.getLong((Enum)Index.PropertyKeys.OCCURRENCES), properties.getInt((Enum)Index.PropertyKeys.MAXCOUNT), payload, hasCounts, hasPositions, Index.getTermProcessor(properties), properties.getString((Enum)Index.PropertyKeys.FIELD), sizes, properties);
            }
            return new DocumentalMergedCluster(localIndex, (DocumentalClusteringStrategy)strategy, properties.getBoolean((Enum)PropertyKeys.FLAT), termFilter, numberOfDocuments, properties.getInt((Enum)Index.PropertyKeys.TERMS), properties.getLong((Enum)Index.PropertyKeys.POSTINGS), properties.getLong((Enum)Index.PropertyKeys.OCCURRENCES), properties.getInt((Enum)Index.PropertyKeys.MAXCOUNT), payload, hasCounts, hasPositions, Index.getTermProcessor(properties), properties.getString((Enum)Index.PropertyKeys.FIELD), sizes, properties);
        }
        throw new IllegalArgumentException("Unknown IndexCluster implementation: " + indexClass.getName());
    }

    @Override
    public void keyIndex(Index newKeyIndex) {
        super.keyIndex(newKeyIndex);
        for (int i = 0; i < this.localIndex.length; ++i) {
            this.localIndex[i].keyIndex(this);
        }
    }

    public static enum PropertyKeys {
        LOCALINDEX,
        STRATEGY,
        STRATEGYCLASS,
        BLOOM,
        FLAT;

    }
}

