/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.payload;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.mg4j.index.payload.AbstractPayload;
import it.unimi.dsi.mg4j.index.payload.Payload;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class DatePayload
extends AbstractPayload {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    protected long secondsFromEpoch = Long.MAX_VALUE;

    @Override
    public Date get() {
        if (this.secondsFromEpoch == Long.MAX_VALUE) {
            throw new IllegalStateException();
        }
        return new Date(this.secondsFromEpoch * 1000L);
    }

    @Override
    public void set(Object date) {
        this.secondsFromEpoch = ((Date)date).getTime() / 1000L;
    }

    @Override
    public int read(InputBitStream ibs) throws IOException {
        long readBits = ibs.readBits();
        this.secondsFromEpoch = Fast.nat2int((long)ibs.readLongDelta());
        return (int)(ibs.readBits() - readBits);
    }

    @Override
    public int write(OutputBitStream obs) throws IOException {
        if (this.secondsFromEpoch == Long.MAX_VALUE) {
            throw new IllegalStateException();
        }
        return obs.writeLongDelta(Fast.int2nat((long)this.secondsFromEpoch));
    }

    @Override
    public DatePayload copy() {
        DatePayload copy = new DatePayload();
        copy.secondsFromEpoch = this.secondsFromEpoch;
        return copy;
    }

    public String toString() {
        if (this.secondsFromEpoch != Long.MAX_VALUE) {
            return this.get().toString();
        }
        return "undefined";
    }

    @Override
    public boolean compatibleWith(Payload payload) {
        return payload.getClass() == DatePayload.class;
    }

    @Override
    public int compareTo(Payload o) {
        long diff = this.secondsFromEpoch - ((DatePayload)o).secondsFromEpoch;
        return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
    }

    public boolean equals(Payload o) {
        return o instanceof DatePayload && ((DatePayload)o).secondsFromEpoch == this.secondsFromEpoch;
    }

    public int hashCode() {
        return (int)this.secondsFromEpoch;
    }

    public Date parse(String spec) throws ParseException {
        return DateFormat.getDateInstance(3, Locale.UK).parse(spec);
    }
}

