/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.payload;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.mg4j.index.payload.AbstractPayload;
import it.unimi.dsi.mg4j.index.payload.Payload;
import java.io.IOException;

public class IntegerPayload
extends AbstractPayload {
    private static final long serialVersionUID = 1L;
    protected boolean unset = true;
    protected long value;

    @Override
    public Long get() {
        if (this.unset) {
            throw new IllegalStateException();
        }
        return this.value;
    }

    public long getLong() {
        return this.value;
    }

    public void set(long value) {
        if (value < -4611686018427387904L || value >= 0x4000000000000000L) {
            throw new IllegalArgumentException(Long.toString(value));
        }
        this.unset = false;
        this.value = value;
    }

    @Override
    public void set(Object value) {
        this.set(((Number)value).longValue());
    }

    @Override
    public int read(InputBitStream ibs) throws IOException {
        long readBits = ibs.readBits();
        this.value = (int)Fast.nat2int((long)ibs.readLongDelta());
        this.unset = false;
        return (int)(ibs.readBits() - readBits);
    }

    @Override
    public int write(OutputBitStream obs) throws IOException {
        if (this.unset) {
            throw new IllegalStateException();
        }
        this.unset = false;
        return obs.writeLongDelta(Fast.int2nat((long)this.value));
    }

    @Override
    public IntegerPayload copy() {
        IntegerPayload copy = new IntegerPayload();
        copy.value = this.value;
        return copy;
    }

    public String toString() {
        if (!this.unset) {
            return this.get().toString();
        }
        return "undefined";
    }

    @Override
    public boolean compatibleWith(Payload payload) {
        return payload.getClass() == IntegerPayload.class;
    }

    @Override
    public int compareTo(Payload o) {
        long diff = this.value - ((IntegerPayload)o).value;
        return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
    }

    public boolean equals(Payload o) {
        return o instanceof IntegerPayload && ((IntegerPayload)o).value == this.value;
    }

    public int hashCode() {
        return HashCommon.long2int((long)this.value);
    }

    public Long parse(String spec) {
        return Long.valueOf(spec);
    }
}

