/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.io.RepositionableStream;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public class RemoteInputStream
extends InputStream
implements RepositionableStream {
    private static final Logger LOGGER = Util.getLogger(RemoteInputStream.class);
    private static final byte READ_ARRAY = 0;
    private static final byte READ_BYTE = 1;
    private static final byte SET_POSITION = 2;
    private static final byte READ_POSITION = 3;
    private static final byte AVAILABLE = 4;
    private static final byte SKIP = 5;
    private static final byte CLOSE = 6;
    private final RemoteIndexServerConnection connection;

    public RemoteInputStream(SocketAddress address, byte serverCommand) throws IOException {
        this.connection = new RemoteIndexServerConnection(address, serverCommand);
    }

    public RemoteInputStream(SocketAddress address) throws IOException {
        this(address, 6);
    }

    @Override
    public int available() throws IOException {
        this.connection.outputStream.writeByte(4);
        this.connection.outputStream.flush();
        return this.connection.inputStream.readInt();
    }

    @Override
    public void close() throws IOException {
        this.connection.outputStream.writeByte(6);
        this.connection.outputStream.flush();
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int read(byte[] array, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        ByteArrays.ensureOffsetLength((byte[])array, (int)offset, (int)length);
        this.connection.outputStream.writeByte(0);
        this.connection.outputStream.writeInt(length);
        this.connection.outputStream.flush();
        int result = this.connection.inputStream.readInt();
        if (result <= 0) {
            return result;
        }
        this.connection.inputStream.read(array, offset, result);
        return result;
    }

    @Override
    public long skip(long toSkip) throws IOException {
        if (toSkip < 0L) {
            throw new IOException("Negative skip: " + toSkip);
        }
        this.connection.outputStream.writeByte(5);
        this.connection.outputStream.writeLong(toSkip);
        this.connection.outputStream.flush();
        return this.connection.inputStream.readLong();
    }

    @Override
    public int read() throws IOException {
        this.connection.outputStream.writeByte(1);
        this.connection.outputStream.flush();
        return this.connection.inputStream.readInt();
    }

    public void position(long newPosition) throws IOException {
        this.connection.outputStream.writeByte(2);
        this.connection.outputStream.writeLong(newPosition);
        this.connection.outputStream.flush();
    }

    public long position() throws IOException {
        this.connection.outputStream.writeByte(2);
        this.connection.outputStream.flush();
        return this.connection.inputStream.readLong();
    }

    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final boolean DEBUG = false;
        private final FastBufferedInputStream remotedInputStream;

        public ServerThread(Socket socket, InputStream stream) throws IOException {
            super(socket);
            this.remotedInputStream = new FastBufferedInputStream(stream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                byte[] readBuf = ByteArrays.EMPTY_ARRAY;
                block25: while (true) {
                    byte command = this.inputStream.readByte();
                    switch (command) {
                        case 0: {
                            int len = this.inputStream.readInt();
                            if (readBuf.length < len) {
                                readBuf = new byte[len];
                            }
                            int result = this.remotedInputStream.read(readBuf, 0, len);
                            this.outputStream.writeInt(result);
                            if (result > 0) {
                                this.outputStream.write(readBuf, 0, result);
                            }
                            this.outputStream.flush();
                            continue block25;
                        }
                        case 1: {
                            this.outputStream.writeInt(this.remotedInputStream.read());
                            this.outputStream.flush();
                            continue block25;
                        }
                        case 2: {
                            this.remotedInputStream.position(this.inputStream.readLong());
                            continue block25;
                        }
                        case 3: {
                            this.outputStream.writeLong(this.remotedInputStream.position());
                            this.outputStream.flush();
                            continue block25;
                        }
                        case 4: {
                            this.outputStream.writeLong(this.remotedInputStream.available());
                            this.outputStream.flush();
                            continue block25;
                        }
                        case 5: {
                            this.outputStream.writeLong(this.remotedInputStream.skip(this.inputStream.readLong()));
                            this.outputStream.flush();
                            continue block25;
                        }
                        case 6: {
                            return;
                        }
                    }
                    LOGGER.error((Object)("Unknown remote command: " + command));
                    continue;
                    break;
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
                return;
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
                return;
            }
            finally {
                try {
                    this.remotedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

