/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.remote;

import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.longs.AbstractLongList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.mg4j.index.remote.RemoteIndexServerConnection;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.log4j.Logger;

public class RemoteOffsetList
extends AbstractLongList
implements Serializable {
    static final long serialVersionUID = 2L;
    private transient RemoteIndexServerConnection connection;
    private SocketAddress address;
    private int size;

    public RemoteOffsetList(SocketAddress addr, int size) {
        this.address = addr;
        this.size = size;
    }

    public long getLong(int index) {
        try {
            if (this.connection == null) {
                this.connection = new RemoteIndexServerConnection(this.address, 5);
            }
            this.connection.outputStream.writeInt(index);
            this.connection.outputStream.flush();
            return this.connection.inputStream.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.size;
    }

    public static class ServerThread
    extends it.unimi.dsi.mg4j.index.remote.ServerThread {
        private static final boolean DEBUG = false;
        private static final Logger LOGGER = Util.getLogger(ServerThread.class);
        private final LongList list;

        public ServerThread(Socket socket, LongList list) throws IOException {
            super(socket);
            this.list = list;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    int index = this.inputStream.readInt();
                    this.outputStream.writeLong(this.list.getLong(index));
                    this.outputStream.flush();
                }
            }
            catch (EOFException e) {
                LOGGER.warn((Object)"The socket has been closed");
            }
            catch (Exception e) {
                LOGGER.fatal((Object)e, (Throwable)e);
            }
        }
    }
}

