/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.index.snowball;

import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.snowball.Among;
import java.lang.reflect.InvocationTargetException;

public abstract class AbstractSnowballTermProcessor
implements TermProcessor,
Cloneable {
    protected MutableString current;
    protected MutableString copy = new MutableString();
    protected char[] array;
    protected int cursor;
    protected int limit;
    protected int limit_backward;
    protected int bra;
    protected int ket;

    protected abstract boolean stem();

    @Override
    public boolean processTerm(MutableString term) {
        if (term == null) {
            return false;
        }
        this.current = term.toLowerCase();
        this.copy.replace(this.current);
        this.cursor = 0;
        this.limit = this.current.length();
        this.array = this.current.array();
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
        boolean b = this.stem();
        if (this.current.length() == 0) {
            this.current.replace(this.copy);
        }
        this.current = null;
        this.array = null;
        return b;
    }

    @Override
    public boolean processPrefix(MutableString prefix) {
        return prefix != null;
    }

    @Override
    public AbstractSnowballTermProcessor copy() {
        try {
            return (AbstractSnowballTermProcessor)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void copy_from(AbstractSnowballTermProcessor other) {
        this.current = other.current;
        this.cursor = other.cursor;
        this.limit = other.limit;
        this.limit_backward = other.limit_backward;
        this.bra = other.bra;
        this.ket = other.ket;
    }

    protected boolean in_grouping(char[] s, int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.array[this.cursor];
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_grouping_b(char[] s, int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.array[this.cursor - 1];
        if (ch > max || ch < min) {
            return false;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_grouping(char[] s, int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.array[this.cursor];
        if (ch > max || ch < min) {
            ++this.cursor;
            return true;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    protected boolean out_grouping_b(char[] s, int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.array[this.cursor - 1];
        if (ch > max || ch < min) {
            --this.cursor;
            return true;
        }
        if ((s[(ch = (char)(ch - min)) >> 3] & 1 << (ch & 7)) == 0) {
            --this.cursor;
            return true;
        }
        return false;
    }

    protected boolean in_range(int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.array[this.cursor];
        if (ch > max || ch < min) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean in_range_b(int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.array[this.cursor - 1];
        if (ch > max || ch < min) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean out_range(int min, int max) {
        if (this.cursor >= this.limit) {
            return false;
        }
        char ch = this.array[this.cursor];
        if (ch <= max && ch >= min) {
            return false;
        }
        ++this.cursor;
        return true;
    }

    protected boolean out_range_b(int min, int max) {
        if (this.cursor <= this.limit_backward) {
            return false;
        }
        char ch = this.array[this.cursor - 1];
        if (ch <= max && ch >= min) {
            return false;
        }
        --this.cursor;
        return true;
    }

    protected boolean eq_s(int s_size, String s) {
        if (this.limit - this.cursor < s_size) {
            return false;
        }
        for (int i = 0; i != s_size; ++i) {
            if (this.array[this.cursor + i] == s.charAt(i)) continue;
            return false;
        }
        this.cursor += s_size;
        return true;
    }

    protected boolean eq_s_b(int s_size, String s) {
        if (this.cursor - this.limit_backward < s_size) {
            return false;
        }
        for (int i = 0; i != s_size; ++i) {
            if (this.array[this.cursor - s_size + i] == s.charAt(i)) continue;
            return false;
        }
        this.cursor -= s_size;
        return true;
    }

    protected boolean eq_v(MutableString s) {
        return this.eq_s(s.length(), s.toString());
    }

    protected boolean eq_v_b(MutableString s) {
        return this.eq_s_b(s.length(), s.toString());
    }

    protected int find_among(Among[] v, int v_size) {
        Among w;
        int i = 0;
        int j = v_size;
        int c = this.cursor;
        int l = this.limit;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = common; i2 < w2.s_size; ++i2) {
                if (c + common == l) {
                    diff = -1;
                    break;
                }
                diff = this.array[c + common] - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            boolean res;
            w = v[i];
            if (common_i < w.s_size) continue;
            this.cursor = c + w.s_size;
            if (w.method == null) {
                return w.result;
            }
            try {
                Object resobj = w.method.invoke((Object)w.methodobject, new Object[0]);
                res = resobj.toString().equals("true");
            }
            catch (InvocationTargetException e) {
                res = false;
            }
            catch (IllegalAccessException e) {
                res = false;
            }
            this.cursor = c + w.s_size;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int find_among_b(Among[] v, int v_size) {
        Among w;
        int i = 0;
        int j = v_size;
        int c = this.cursor;
        int lb = this.limit_backward;
        int common_i = 0;
        int common_j = 0;
        boolean first_key_inspected = false;
        while (true) {
            int k = i + (j - i >> 1);
            int diff = 0;
            int common = common_i < common_j ? common_i : common_j;
            Among w2 = v[k];
            for (int i2 = w2.s_size - 1 - common; i2 >= 0; --i2) {
                if (c - common == lb) {
                    diff = -1;
                    break;
                }
                diff = this.array[c - 1 - common] - w2.s[i2];
                if (diff != 0) break;
                ++common;
            }
            if (diff < 0) {
                j = k;
                common_j = common;
            } else {
                i = k;
                common_i = common;
            }
            if (j - i > 1) continue;
            if (i > 0 || j == i || first_key_inspected) break;
            first_key_inspected = true;
        }
        do {
            boolean res;
            w = v[i];
            if (common_i < w.s_size) continue;
            this.cursor = c - w.s_size;
            if (w.method == null) {
                return w.result;
            }
            try {
                Object resobj = w.method.invoke((Object)w.methodobject, new Object[0]);
                res = resobj.toString().equals("true");
            }
            catch (InvocationTargetException e) {
                res = false;
            }
            catch (IllegalAccessException e) {
                res = false;
            }
            this.cursor = c - w.s_size;
            if (!res) continue;
            return w.result;
        } while ((i = w.substring_i) >= 0);
        return 0;
    }

    protected int replace_s(int c_bra, int c_ket, String s) {
        int adjustment = s.length() - (c_ket - c_bra);
        this.current.replace(c_bra, c_ket, s);
        this.array = this.current.array();
        this.limit += adjustment;
        if (this.cursor >= c_ket) {
            this.cursor += adjustment;
        } else if (this.cursor > c_bra) {
            this.cursor = c_bra;
        }
        return adjustment;
    }

    protected void slice_check() {
        if (this.bra < 0 || this.bra > this.ket || this.ket > this.limit || this.limit > this.current.length()) {
            throw new IllegalArgumentException("Faulty slice operation");
        }
    }

    protected void slice_from(String s) {
        this.slice_check();
        this.replace_s(this.bra, this.ket, s);
    }

    protected void slice_del() {
        this.slice_from("");
    }

    protected void insert(int c_bra, int c_ket, String s) {
        int adjustment = this.replace_s(c_bra, c_ket, s);
        if (c_bra <= this.bra) {
            this.bra += adjustment;
        }
        if (c_bra <= this.ket) {
            this.ket += adjustment;
        }
    }

    protected void insert(int c_bra, int c_ket, MutableString s) {
        this.insert(c_bra, c_ket, s.toString());
    }

    protected MutableString slice_to(MutableString s) {
        this.slice_check();
        s.replace(0, s.length(), this.current.substring(this.bra, this.ket));
        return s;
    }

    protected MutableString assign_to(MutableString s) {
        s.replace(0, s.length(), this.current.substring(0, this.limit));
        return s;
    }
}

