/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.io.InputBitStream;
import java.io.IOException;

public final class ArithmeticDecoder {
    public static final int BITS = 63;
    private static final long HALF = 0x4000000000000000L;
    private static final long QUARTER = 0x2000000000000000L;
    private int[] count;
    private int total;
    private int n;
    private long range = 0x4000000000000000L;
    private long buffer = -1L;
    private long window = 0L;

    public ArithmeticDecoder(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("You cannot use " + n + " symbols.");
        }
        this.n = n;
        this.count = new int[n + 1];
        for (int i = 0; i < n; ++i) {
            this.incrementCount(i);
        }
        this.total = n;
    }

    private void incrementCount(int x) {
        ++x;
        while (x <= this.n) {
            int n = x;
            this.count[n] = this.count[n] + 1;
            x += x & -x;
        }
    }

    private int getCount(int x) {
        int c = 0;
        while (x != 0) {
            c += this.count[x];
            x &= x - 1;
        }
        return c;
    }

    public int decode(InputBitStream ibs) throws IOException {
        long r;
        int x;
        if (this.buffer == -1L) {
            this.window = this.buffer = ibs.readLong(62);
        }
        if (this.total - 1 < (x = (int)(this.buffer / (r = this.range / (long)this.total)))) {
            x = this.total - 1;
        }
        for (int i = 1; i <= this.n; ++i) {
            if (x >= this.getCount(i)) continue;
            x = i - 1;
            break;
        }
        int lowCount = this.getCount(x);
        int highCount = this.getCount(x + 1);
        this.buffer -= r * (long)lowCount;
        this.range = x != this.n - 1 ? r * (long)(highCount - lowCount) : (this.range -= r * (long)lowCount);
        this.incrementCount(x);
        ++this.total;
        while (this.range <= 0x2000000000000000L) {
            this.buffer <<= 1;
            this.range <<= 1;
            this.window <<= 1;
            if (ibs.readBit() == 0) continue;
            ++this.buffer;
            ++this.window;
        }
        return x;
    }

    public void flush(InputBitStream ibs) throws IOException {
        long roundup;
        long bits;
        long value;
        int nbits;
        long low = (this.window & 0x3FFFFFFFFFFFFFFFL) + 0x4000000000000000L - this.buffer;
        for (nbits = 1; nbits <= 63 && (low > (value = (bits = low + (roundup = (1L << 63 - nbits) - 1L) >>> 63 - nbits) << 63 - nbits) || value + roundup > low + (this.range - 1L) && (value + roundup < 0L || low + (this.range - 1L) >= 0L)); ++nbits) {
        }
        for (int i = 1; i <= nbits; ++i) {
            this.window <<= 1;
            this.window |= (long)ibs.readBit();
        }
    }

    public long getWindow() {
        return this.window & Long.MAX_VALUE;
    }
}

