/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.io;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.mg4j.tool.Scan;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;

public class ByteArrayPostingList
implements Flushable,
Closeable {
    private static final boolean DEBUG = false;
    private static final int POSTINGS_EMERGENCY_INCREMENT = 1024;
    private static final int POSITIONS_EMERGENCY_INCREMENT = 64;
    public byte[] buffer;
    public int frequency;
    public long globCount;
    public long posNumBits;
    private int count;
    public int maxCount;
    public boolean outOfMemoryError;
    private int current;
    private int free;
    private int pos;
    private int avail;
    private int[] position;
    private int lastPointer;
    private final boolean differential;
    private final int completeness;

    public ByteArrayPostingList(byte[] a, boolean differential, Scan.Completeness completeness) {
        this.differential = differential;
        this.completeness = completeness.ordinal();
        this.free = 8;
        this.buffer = a;
        this.avail = a.length;
        if (this.completeness >= Scan.Completeness.POSITIONS.ordinal()) {
            this.position = new int[2];
        }
        this.lastPointer = -1;
    }

    private void write(int b) {
        if (this.avail == 0) {
            int oldLength = this.buffer.length;
            try {
                this.buffer = ByteArrays.grow((byte[])this.buffer, (int)(this.buffer.length + 1));
            }
            catch (OutOfMemoryError e) {
                this.outOfMemoryError = true;
                try {
                    File temp = File.createTempFile(ByteArrayPostingList.class.getSimpleName(), "dump");
                    temp.deleteOnExit();
                    BinIO.storeBytes((byte[])this.buffer, (File)temp);
                    this.buffer = null;
                    this.buffer = new byte[oldLength + 1024];
                    BinIO.loadBytes((File)temp, (byte[])this.buffer);
                    temp.delete();
                }
                catch (IOException f) {
                    throw new RuntimeException(f);
                }
            }
            this.avail += this.buffer.length - oldLength;
        }
        --this.avail;
        this.buffer[this.pos++] = (byte)b;
    }

    public int align() {
        if (this.free != 8) {
            return this.writeInCurrent(0, this.free);
        }
        return 0;
    }

    private int writeInCurrent(int b, int len) {
        this.current |= (b & (1 << len) - 1) << (this.free -= len);
        if (this.free == 0) {
            this.write(this.current);
            this.free = 8;
            this.current = 0;
        }
        return len;
    }

    private int writeInt(int x, int len) {
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot write " + len + " bits to an integer.");
        }
        if (len <= this.free) {
            return this.writeInCurrent(x, len);
        }
        int i = len - this.free;
        int queue = i & 7;
        if (this.free != 0) {
            this.writeInCurrent(x >>> i, this.free);
        }
        if (queue != 0) {
            i -= queue;
            this.writeInCurrent(x, queue);
            x >>>= queue;
        }
        if (i == 32) {
            this.write(x >>> 24);
        }
        if (i > 23) {
            this.write(x >>> 16);
        }
        if (i > 15) {
            this.write(x >>> 8);
        }
        if (i > 7) {
            this.write(x);
        }
        return len;
    }

    private int writeUnary(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < this.free) {
            return this.writeInCurrent(1, x + 1);
        }
        int shift = this.free;
        this.write(this.current);
        this.free = 8;
        this.current = 0;
        int i = (x -= shift) >> 3;
        while (i-- != 0) {
            this.write(0);
        }
        this.writeInCurrent(1, (x & 7) + 1);
        return x + shift + 1;
    }

    private int writeGamma(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096) {
            return this.writeInt(OutputBitStream.GAMMA[x], OutputBitStream.GAMMA[x] >>> 26);
        }
        int msb = Fast.mostSignificantBit((int)(++x));
        int l = this.writeUnary(msb);
        return l + (msb != 0 ? this.writeInt(x, msb) : 0);
    }

    private int writeDelta(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("The argument " + x + " is negative");
        }
        if (x < 4096) {
            return this.writeInt(OutputBitStream.DELTA[x], OutputBitStream.DELTA[x] >>> 26);
        }
        int msb = Fast.mostSignificantBit((int)(++x));
        int l = this.writeGamma(msb);
        return l + (msb != 0 ? this.writeInt(x, msb) : 0);
    }

    @Override
    public void flush() {
        if (this.count != 0) {
            if (this.completeness >= Scan.Completeness.COUNTS.ordinal()) {
                this.writeGamma(this.count - 1);
            }
            this.globCount += (long)this.count;
            if (this.maxCount < this.count) {
                this.maxCount = this.count;
            }
            if (this.completeness >= Scan.Completeness.POSITIONS.ordinal()) {
                this.posNumBits += (long)this.writeDelta(this.position[0]);
                for (int i = 1; i < this.count; ++i) {
                    this.posNumBits += (long)this.writeDelta(this.position[i] - this.position[i - 1] - 1);
                }
            }
            this.count = 0;
        }
    }

    public void setDocumentPointer(int pointer) {
        if (pointer != this.lastPointer) {
            this.flush();
            this.writeDelta(this.differential ? pointer - this.lastPointer - 1 : pointer);
            this.lastPointer = pointer;
            ++this.frequency;
        }
    }

    public void addPosition(int pos) {
        if (this.lastPointer == -1) {
            throw new IllegalStateException();
        }
        if (this.completeness >= Scan.Completeness.POSITIONS.ordinal()) {
            if (this.count == this.position.length) {
                try {
                    this.position = IntArrays.grow((int[])this.position, (int)(this.count + 1));
                }
                catch (OutOfMemoryError e) {
                    this.outOfMemoryError = true;
                    try {
                        File temp = File.createTempFile(ByteArrayPostingList.class.getSimpleName(), "dump");
                        temp.deleteOnExit();
                        BinIO.storeInts((int[])this.position, (File)temp);
                        int oldLength = this.position.length;
                        this.position = null;
                        this.position = new int[oldLength + 64];
                        BinIO.loadInts((File)temp, (int[])this.position);
                        temp.delete();
                    }
                    catch (IOException f) {
                        throw new RuntimeException(f);
                    }
                }
            }
            this.position[this.count] = pos;
        }
        ++this.count;
    }

    public long writtenBits() {
        return (long)this.pos * 8L + 8L - (long)this.free;
    }

    public void stripPointers(OutputBitStream obs, long bitLength) throws IOException {
        InputBitStream ibs = new InputBitStream(this.buffer);
        while (ibs.readBits() < bitLength) {
            ibs.readDelta();
            if (this.completeness < Scan.Completeness.COUNTS.ordinal()) continue;
            int count = ibs.readGamma() + 1;
            obs.writeGamma(count - 1);
            if (this.completeness < Scan.Completeness.POSITIONS.ordinal()) continue;
            while (count-- != 0) {
                obs.writeDelta(ibs.readDelta());
            }
        }
    }

    @Override
    public void close() {
        this.flush();
        this.position = null;
    }
}

