/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import javax.activation.MimetypesFileTypeMap;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ResourceHandler;

public class HttpFileServer {
    private static final Server SERVER;
    private static final HttpFileServer INSTANCE;
    private static int port;
    private static final MimetypesFileTypeMap MIME_TYPES_FILE_TYPE_MAP;

    public static HttpFileServer getServer() {
        return INSTANCE;
    }

    public static int getPort() {
        if (port == 0) {
            if (!SERVER.isStarted()) {
                throw new IllegalStateException("The server is not started yet");
            }
            port = SERVER.getConnectors()[0].getLocalPort();
        }
        return port;
    }

    private HttpFileServer() {
    }

    static {
        INSTANCE = new HttpFileServer();
        MIME_TYPES_FILE_TYPE_MAP = new MimetypesFileTypeMap();
        System.setProperty("org.mortbay.util.FileResource.checkAliases", Boolean.FALSE.toString());
        SERVER = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(Integer.parseInt(System.getProperty(HttpFileServer.class.getName() + ".port", "0")));
        SERVER.addConnector((Connector)connector);
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        context.setResourceBase("/");
        SERVER.addHandler((Handler)context);
        ResourceHandler resourceHandler = new ResourceHandler();
        context.addHandler((Handler)resourceHandler);
        new Thread(){

            @Override
            public void run() {
                try {
                    SERVER.start();
                }
                catch (Exception e) {
                    throw new RuntimeException();
                }
            }
        }.start();
    }
}

