/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.Util;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.query.FileSystemItem;
import it.unimi.dsi.mg4j.query.HelpPage;
import it.unimi.dsi.mg4j.query.QueryEngine;
import it.unimi.dsi.mg4j.query.QueryServlet;
import java.util.List;
import javax.servlet.http.HttpServlet;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.log4j.Logger;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.ServletHandler;

public class HttpQueryServer {
    private static final Logger LOGGER = Util.getLogger(HttpQueryServer.class);
    public final Server server;

    public static ExtendedProperties setLiberalResourceLoading(ExtendedProperties p) {
        if (!p.containsKey((Object)"resource.loader")) {
            p.setProperty("resource.loader", (Object)"class, current, absolute");
            p.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            p.setProperty("current.resource.loader.class", (Object)FileResourceLoader.class.getName());
            p.setProperty("current.resource.loader.path", (Object)System.getProperty("user.dir"));
            p.setProperty("absolute.resource.loader.class", (Object)FileResourceLoader.class.getName());
            p.setProperty("absolute.resource.loader.path", (Object)"");
            p.setProperty("input.encoding", (Object)"utf-8");
            p.setProperty("output.encoding", (Object)"utf-8");
            p.setProperty("default.contentType", (Object)"text/html; charset=UTF-8");
        }
        return p;
    }

    public HttpQueryServer(QueryEngine queryEngine, DocumentCollection collection, Class<? extends HttpServlet> itemClass, String itemMimeType, int port, List<? extends CharSequence> titleList) throws Exception {
        LOGGER.debug((Object)("itemClass: " + itemClass));
        LOGGER.debug((Object)("itemMimeType: " + itemMimeType));
        LOGGER.debug((Object)("queryEngine: " + queryEngine));
        LOGGER.debug((Object)("port: " + port));
        this.server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath("");
        this.server.addHandler((Handler)contextHandler);
        ServletHandler servlets = new ServletHandler();
        contextHandler.addHandler((Handler)servlets);
        contextHandler.setAttribute("queryEngine", (Object)queryEngine);
        contextHandler.setAttribute("collection", (Object)collection);
        contextHandler.setAttribute("titleList", titleList);
        contextHandler.setAttribute("action", (Object)"/Query");
        contextHandler.setAttribute("template", (Object)System.getProperty("it.unimi.dsi.mg4j.query.QueryServlet.template"));
        servlets.addServletWithMapping(QueryServlet.class, "/Query");
        servlets.addServletWithMapping(HelpPage.class, "/Help");
        if (itemClass != null) {
            servlets.addServletWithMapping(itemClass, "/Item");
            if (itemClass == FileSystemItem.class) {
                contextHandler.setAttribute("derelativise", (Object)Boolean.TRUE);
            }
        } else {
            contextHandler.setAttribute("uri", (Object)Boolean.TRUE);
        }
        contextHandler.setAttribute("mimeType", (Object)itemMimeType);
        this.server.start();
    }
}

