/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.lang.FlyweightPrototype;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.query.SelectedInterval;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import java.io.IOException;
import java.util.Iterator;

public class IntervalSelector
implements FlyweightPrototype<IntervalSelector> {
    private static final SelectedInterval[] INIT = new SelectedInterval[]{new SelectedInterval(Interval.valueOf((int)-1), null), new SelectedInterval(Interval.valueOf((int)Integer.MAX_VALUE), null)};
    private final int maxIntervals;
    private final int intervalMaxLength;
    private final ObjectRBTreeSet<SelectedInterval> leftOrderedIntervals = new ObjectRBTreeSet();
    private final ObjectArrayList<Interval> intervals = new ObjectArrayList();

    public IntervalSelector() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public IntervalSelector(int maxIntervals, int intervalMaxLength) {
        this.maxIntervals = maxIntervals;
        this.intervalMaxLength = intervalMaxLength;
    }

    public IntervalSelector copy() {
        return new IntervalSelector(this.maxIntervals, this.intervalMaxLength);
    }

    public SelectedInterval[] select(IntervalIterator intervalIterator) {
        ObjectBidirectionalIterator iterator;
        if (intervalIterator == IntervalIterators.TRUE) {
            return SelectedInterval.TRUE_ARRAY;
        }
        if (intervalIterator == IntervalIterators.FALSE) {
            return SelectedInterval.FALSE_ARRAY;
        }
        if (!intervalIterator.hasNext()) {
            return SelectedInterval.EMPTY_ARRAY;
        }
        this.intervals.clear();
        ObjectIterators.pour((Iterator)intervalIterator, this.intervals);
        if (this.maxIntervals == Integer.MIN_VALUE && this.intervalMaxLength == Integer.MIN_VALUE) {
            SelectedInterval[] result = new SelectedInterval[this.intervals.size()];
            int i = this.intervals.size();
            while (i-- != 0) {
                result[i] = new SelectedInterval((Interval)this.intervals.get(i), SelectedInterval.IntervalType.WHOLE);
            }
            return result;
        }
        ObjectHeapPriorityQueue shortIntervals = new ObjectHeapPriorityQueue(this.intervals.toArray((Object[])Intervals.EMPTY_ARRAY), this.intervals.size(), Intervals.LENGTH_COMPARATOR);
        this.leftOrderedIntervals.add((Object)INIT[0]);
        this.leftOrderedIntervals.add((Object)INIT[1]);
        Interval interval = (Interval)shortIntervals.dequeue();
        if (interval.length() < this.intervalMaxLength) {
            this.leftOrderedIntervals.add((Object)new SelectedInterval(interval, SelectedInterval.IntervalType.WHOLE));
        } else {
            this.leftOrderedIntervals.add((Object)new SelectedInterval(Interval.valueOf((int)interval.left, (int)(interval.left + this.intervalMaxLength / 2)), SelectedInterval.IntervalType.PREFIX));
            this.leftOrderedIntervals.add((Object)new SelectedInterval(Interval.valueOf((int)(interval.right - this.intervalMaxLength / 2), (int)interval.right), SelectedInterval.IntervalType.SUFFIX));
        }
        while (this.leftOrderedIntervals.size() - INIT.length < this.maxIntervals && !shortIntervals.isEmpty() && (interval = (Interval)shortIntervals.dequeue()).length() <= this.intervalMaxLength) {
            iterator = this.leftOrderedIntervals.iterator((Object)new SelectedInterval(interval, null));
            iterator.previous();
            SelectedInterval left = (SelectedInterval)iterator.next();
            SelectedInterval right = (SelectedInterval)iterator.next();
            if (interval.left <= left.interval.right || interval.right >= right.interval.left) continue;
            this.leftOrderedIntervals.add((Object)new SelectedInterval(interval, SelectedInterval.IntervalType.WHOLE));
        }
        iterator = this.leftOrderedIntervals.iterator();
        iterator.next();
        Object[] result = new SelectedInterval[this.leftOrderedIntervals.size() - INIT.length];
        ObjectIterators.unwrap((Iterator)iterator, (Object[])result);
        this.leftOrderedIntervals.clear();
        return result;
    }

    public Reference2ObjectMap<Index, SelectedInterval[]> select(DocumentIterator documentIterator, Reference2ObjectMap<Index, SelectedInterval[]> index2Interval) throws IOException {
        index2Interval.clear();
        for (Index index : documentIterator.indices()) {
            if (!index.hasPositions) continue;
            IntervalIterator intervalIterator = documentIterator.intervalIterator(index);
            if (intervalIterator == IntervalIterators.TRUE) {
                index2Interval.put((Object)index, (Object)SelectedInterval.TRUE_ARRAY);
                continue;
            }
            index2Interval.put((Object)index, (Object)this.select(documentIterator.intervalIterator(index)));
        }
        return index2Interval;
    }
}

