/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.WordReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.query.Marker;
import it.unimi.dsi.mg4j.query.SelectedInterval;
import java.io.IOException;

public class MarkingMutableString
extends MutableString {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_INTERVAL_SURROUND = 8;
    public boolean resume = true;
    public boolean marking;
    private SelectedInterval[] interval;
    private int count;
    private int currMarkingInterval;
    private int currResumeInterval;
    private boolean skipping;
    private boolean oneCharOut;
    private final Marker marker;
    private final EscapeStrategy escapeStrategy;
    private static final char[] HTML_ESCAPE_CHAR = new char[]{'<', '&'};
    private static final String[] HTML_ESCAPE_STRING = new String[]{"&lt;", "&amp;"};
    public static final EscapeStrategy NULL_ESCAPE = new NullEscape();
    public static final EscapeStrategy HTML_ESCAPE = new HtmlEscape();
    private final int intervalSurround;

    public MarkingMutableString(Marker marker, EscapeStrategy escapeStrategy, int intervalSurround) {
        this.marker = marker;
        this.escapeStrategy = escapeStrategy;
        this.intervalSurround = intervalSurround;
    }

    public MarkingMutableString(Marker marker, EscapeStrategy escapeStrategy) {
        this(marker, escapeStrategy, 8);
    }

    public MarkingMutableString(Marker marker) {
        this(marker, NULL_ESCAPE);
    }

    public MarkingMutableString startField(SelectedInterval[] interval) {
        if (interval == null) {
            throw new IllegalArgumentException();
        }
        this.count = -1;
        this.currMarkingInterval = 0;
        this.currResumeInterval = 0;
        this.marking = false;
        this.oneCharOut = false;
        this.skipping = false;
        this.interval = interval;
        this.append(this.marker.startOfField());
        return this;
    }

    public MarkingMutableString endField() {
        this.append(this.marker.endOfField());
        return this;
    }

    private int leftRadius(int currResumeInterval) {
        switch (this.interval[currResumeInterval].type) {
            case WHOLE: {
                return this.intervalSurround;
            }
            case PREFIX: {
                return this.intervalSurround;
            }
            case SUFFIX: {
                return 0;
            }
        }
        throw new IllegalArgumentException();
    }

    private int rightRadius(int currResumeInterval) {
        switch (this.interval[currResumeInterval].type) {
            case WHOLE: {
                return this.intervalSurround;
            }
            case PREFIX: {
                return 0;
            }
            case SUFFIX: {
                return this.intervalSurround;
            }
        }
        throw new IllegalArgumentException();
    }

    public MarkingMutableString appendAndMark(String s) {
        return this.appendAndMark(new MutableString(s));
    }

    public MarkingMutableString appendAndMark(MutableString s) {
        return this.appendAndMark((WordReader)new FastBufferedReader(s));
    }

    public MarkingMutableString appendAndMark(WordReader wordReader) {
        MutableString word = new MutableString();
        MutableString nonWord = new MutableString();
        try {
            while (wordReader.next(word, nonWord)) {
                if (word.length() != 0) {
                    ++this.count;
                }
                if (this.resume) {
                    while (this.currResumeInterval < this.interval.length && this.interval[this.currResumeInterval].interval.compareTo(this.count, this.leftRadius(this.currResumeInterval), this.rightRadius(this.currResumeInterval)) > 0) {
                        ++this.currResumeInterval;
                    }
                    if (this.currResumeInterval == this.interval.length || !this.interval[this.currResumeInterval].interval.contains(this.count, this.leftRadius(this.currResumeInterval), this.rightRadius(this.currResumeInterval))) {
                        if (!this.skipping && this.oneCharOut) {
                            this.append(this.marker.endOfBlock());
                        }
                        if (this.resume && this.currResumeInterval == this.interval.length) {
                            return this;
                        }
                        this.skipping = true;
                        continue;
                    }
                    if (this.skipping) {
                        this.append(this.marker.startOfBlock());
                    }
                    this.skipping = false;
                }
                if (word.length() != 0) {
                    if (!this.marking && this.currMarkingInterval < this.interval.length && this.interval[this.currMarkingInterval].interval.contains(this.count)) {
                        this.append(this.marker.startOfMark());
                        this.marking = true;
                    }
                    this.append(word);
                    if (this.marking && (this.currMarkingInterval == this.interval.length || !this.interval[this.currMarkingInterval].interval.contains(this.count + 1))) {
                        this.append(this.marker.endOfMark());
                        this.marking = false;
                    }
                    this.oneCharOut = true;
                    if (this.currMarkingInterval < this.interval.length && this.interval[this.currMarkingInterval].interval.compareTo(this.count + 1) > 0) {
                        ++this.currMarkingInterval;
                    }
                }
                if (nonWord.length() <= 0) continue;
                this.oneCharOut = true;
                nonWord.squeezeWhitespace();
                this.append(this.escapeStrategy.escape(nonWord));
            }
            if (this.marking) {
                this.append(this.marker.endOfMark());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private static final class NullEscape
    implements EscapeStrategy {
        private NullEscape() {
        }

        @Override
        public MutableString escape(MutableString s) {
            return s;
        }
    }

    private static final class HtmlEscape
    implements EscapeStrategy {
        private HtmlEscape() {
        }

        @Override
        public MutableString escape(MutableString s) {
            return s.replace(HTML_ESCAPE_CHAR, HTML_ESCAPE_STRING);
        }
    }

    public static interface EscapeStrategy {
        public MutableString escape(MutableString var1);
    }
}

