/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.mg4j.document.AbstractDocumentSequence;
import it.unimi.dsi.mg4j.document.Document;
import it.unimi.dsi.mg4j.document.DocumentCollection;
import it.unimi.dsi.mg4j.document.DocumentFactory;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.query.HttpQueryServer;
import it.unimi.dsi.mg4j.query.IntervalSelector;
import it.unimi.dsi.mg4j.query.Marker;
import it.unimi.dsi.mg4j.query.MarkingMutableString;
import it.unimi.dsi.mg4j.query.QueryEngine;
import it.unimi.dsi.mg4j.query.SelectedInterval;
import it.unimi.dsi.mg4j.query.TextMarker;
import it.unimi.dsi.mg4j.query.nodes.QueryTransformer;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.query.parser.SimpleParser;
import it.unimi.dsi.mg4j.search.DocumentIteratorBuilderVisitor;
import it.unimi.dsi.mg4j.search.score.BM25Scorer;
import it.unimi.dsi.mg4j.search.score.DocumentScoreInfo;
import it.unimi.dsi.mg4j.search.score.Scorer;
import it.unimi.dsi.mg4j.search.score.VignaScorer;
import it.unimi.dsi.mg4j.util.MG4JClassParser;
import it.unimi.dsi.sux4j.io.FileLinesList;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class Query {
    private static final Logger LOGGER = Util.getLogger(Query.class);
    private static final NumberFormat FORMATTER = new DecimalFormat("0.0000000000");
    public static final int MAX_STEMMING = 1024;
    private int maxOutput = 10;
    private int trecTopicNumber;
    private String trecRunTag;
    private OutputType displayMode = OutputType.SHORT;
    private PrintStream output = System.out;
    private final QueryEngine queryEngine;

    public Query(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    private static void loadIndicesFromSpec(String[] basenameWeight, boolean loadSizes, DocumentCollection documentCollection, Object2ReferenceMap<String, Index> name2Index, Reference2DoubleMap<Index> index2Weight) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (int i = 0; i < basenameWeight.length; ++i) {
            Index index;
            int split = basenameWeight[i].lastIndexOf(58);
            double weight = 1.0;
            if (split != -1) {
                try {
                    weight = Double.parseDouble(basenameWeight[i].substring(split + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (split == -1 || basenameWeight[i].startsWith("mg4j://")) {
                index = Index.getInstance(basenameWeight[i], true, loadSizes);
                index2Weight.put((Object)index, 1.0);
            } else {
                index = Index.getInstance(basenameWeight[i].substring(0, split));
                index2Weight.put((Object)index, weight);
            }
            if (documentCollection != null && index.numberOfDocuments != documentCollection.size()) {
                LOGGER.warn((Object)("Index " + index + " has " + index.numberOfDocuments + " documents, but the document collection has size " + documentCollection.size()));
            }
            name2Index.put((Object)(index.field != null ? index.field : basenameWeight[i]), (Object)index);
        }
    }

    private static <S> double loadClassFromSpec(String spec, S[] array, int index) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        int pos = spec.indexOf(58);
        Class<?> klass = array.getClass().getComponentType();
        double weightSpec = 1.0;
        if (pos >= 0) {
            try {
                weightSpec = Double.parseDouble(spec.substring(pos + 1));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Malformed weight " + spec.substring(0, pos));
            }
            spec = spec.substring(0, pos);
        }
        array[index] = ObjectParser.fromSpec((String)spec, klass, (String[])new String[]{"it.unimi.dsi.mg4j.search.score", "it.unimi.dsi.mg4j.query.nodes"});
        return weightSpec;
    }

    public boolean interpretCommand(String line) {
        Command command;
        String[] part = line.substring(1).split("[ \t\n\r]+");
        if (part[0].length() == 0) {
            System.err.println("$                                                       prints this help.");
            System.err.println("$mode [time|short|long|snippet|trec <topicNo> <runTag>] chooses display mode.");
            System.err.println("$select [<maxIntervals> <maxLength>] [all]              installs or removes an interval selector.");
            System.err.println("$limit <max>                                            output at most <max> results per query.");
            System.err.println("$divert [<filename>]                                    diverts output to <filename> or to stdout.");
            System.err.println("$weight {index:weight}                                  set index weights (unspecified weights are set to 1).");
            System.err.println("$mplex [<on>|<off>]                                     set/unset multiplex mode.");
            System.err.println("$equalize <sample>                                      equalize scores using the given sample size.");
            System.err.println("$score {<scorerClass>(<arg>,...)[:<weight>]}            order documents according to <scorerClass>.");
            System.err.println("$expand {<expanderClass>(<arg>,...)}                    expand terms and prefixes according to <expanderClass>.");
            System.err.println("$quit                                                   quits.");
            return true;
        }
        try {
            command = Command.valueOf(part[0].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid command \"" + part[0] + "\"; type $ for help.");
            return true;
        }
        switch (command) {
            case MODE: {
                if (part.length >= 2) {
                    try {
                        OutputType tempMode = OutputType.valueOf(part[1].toUpperCase());
                        if (tempMode != OutputType.TREC && part.length > 2) {
                            System.err.println("Extra arguments.");
                            break;
                        }
                        if (tempMode == OutputType.TREC && part.length != 4) {
                            System.err.println("Missing or extra arguments.");
                            break;
                        }
                        this.displayMode = tempMode;
                        if (this.displayMode != OutputType.TREC) break;
                        this.trecTopicNumber = Integer.parseInt(part[2]);
                        this.trecRunTag = part[3];
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("Unknown mode: " + part[1]);
                    }
                    break;
                }
                System.err.println("Missing mode.");
                break;
            }
            case LIMIT: {
                int out = -1;
                if (part.length == 2) {
                    try {
                        out = Integer.parseInt(part[1]);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (out >= 0) {
                        this.maxOutput = out;
                    }
                }
                if (out >= 0) break;
                System.err.println("Missing or incorrect limit.");
                break;
            }
            case SELECT: {
                int maxIntervals = -1;
                int maxLength = -1;
                if (part.length == 1) {
                    this.queryEngine.intervalSelector = null;
                    System.err.println("Intervals have been disabled.");
                    break;
                }
                if (part.length == 2 && "all".equals(part[1])) {
                    this.queryEngine.intervalSelector = new IntervalSelector();
                    System.err.println("Interval selection has been disabled (will compute all intervals).");
                    break;
                }
                if (part.length == 3) {
                    try {
                        maxIntervals = Integer.parseInt(part[1]);
                        maxLength = Integer.parseInt(part[2]);
                        this.queryEngine.intervalSelector = new IntervalSelector(maxIntervals, maxLength);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (maxIntervals >= 0 && maxLength >= 0) break;
                System.err.println("Missing or incorrect selector parameters.");
                break;
            }
            case SCORE: {
                int i;
                Scorer[] scorer = new Scorer[part.length - 1];
                double[] weight = new double[part.length - 1];
                for (i = 1; i < part.length; ++i) {
                    try {
                        weight[i - 1] = Query.loadClassFromSpec(part[i], scorer, i - 1);
                        if (!(weight[i - 1] < 0.0)) continue;
                        throw new IllegalArgumentException("Weights should be non-negative");
                    }
                    catch (Exception e) {
                        System.err.print("Error while parsing specification: ");
                        e.printStackTrace(System.err);
                        break;
                    }
                }
                if (i != part.length) break;
                this.queryEngine.score(scorer, weight);
                break;
            }
            case EXPAND: {
                if (part.length > 2) {
                    System.err.println("Wrong argument(s) to command");
                    break;
                }
                if (part.length == 1) {
                    this.queryEngine.transformer(null);
                    break;
                }
                QueryTransformer[] t = new QueryTransformer[1];
                try {
                    Query.loadClassFromSpec(part[1], t, 0);
                    this.queryEngine.transformer(t[0]);
                }
                catch (Exception e) {
                    System.err.print("Error while parsing specification: ");
                    e.printStackTrace(System.err);
                }
                break;
            }
            case MPLEX: {
                if (part.length != 2 || part.length == 2 && !"on".equals(part[1]) && !"off".equals(part[1])) {
                    System.err.println("Wrong argument(s) to command");
                    break;
                }
                if (part.length > 1) {
                    this.queryEngine.multiplex = "on".equals(part[1]);
                }
                System.err.println("Multiplex: " + part[1]);
                break;
            }
            case DIVERT: {
                if (part.length > 2) {
                    System.err.println("Wrong argument(s) to command");
                    break;
                }
                if (this.output != System.out) {
                    this.output.close();
                }
                try {
                    this.output = part.length == 1 ? System.out : new PrintStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(part[1])));
                }
                catch (FileNotFoundException e) {
                    System.err.println("Cannot create file " + part[1]);
                    this.output = System.out;
                }
                break;
            }
            case WEIGHT: {
                int i;
                Reference2DoubleOpenHashMap newIndex2Weight = new Reference2DoubleOpenHashMap();
                for (i = 1; i < part.length; ++i) {
                    int pos = part[i].indexOf(58);
                    if (pos < 0) {
                        System.err.println("Missing colon: " + part[i]);
                        break;
                    }
                    if (!this.queryEngine.indexMap.containsKey((Object)part[i].substring(0, pos))) {
                        System.err.println("Unknown index: " + part[i].substring(0, pos));
                        break;
                    }
                    try {
                        double newWeight = Double.parseDouble(part[i].substring(pos + 1));
                        newIndex2Weight.put(this.queryEngine.indexMap.get((Object)part[i].substring(0, pos)), newWeight);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Wrong weight specification: " + part[i].substring(pos + 1));
                        break;
                    }
                }
                if (i != part.length) break;
                if (i > 1) {
                    this.queryEngine.setWeights((Reference2DoubleMap<Index>)newIndex2Weight);
                }
                for (String key : this.queryEngine.indexMap.keySet()) {
                    System.err.print(key + ":" + newIndex2Weight.getDouble(this.queryEngine.indexMap.get((Object)key)) + " ");
                }
                System.err.println();
                break;
            }
            case EQUALIZE: {
                try {
                    if (part.length != 2) {
                        throw new NumberFormatException("Illegal number of arguments");
                    }
                    this.queryEngine.equalize(Integer.parseInt(part[1]));
                    System.err.println("Equalization sample set to " + Integer.parseInt(part[1]));
                }
                catch (NumberFormatException e) {
                    System.err.println(e.getMessage());
                }
                break;
            }
            case QUIT: {
                return false;
            }
        }
        return true;
    }

    public int output(ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>> results, final DocumentCollection documentCollection, List<? extends CharSequence> titleList, Marker marker) throws IOException {
        int i;
        if (this.displayMode == OutputType.TREC) {
            if (titleList == null) {
                throw new IllegalStateException("You cannot use TREC mode without a title list");
            }
            for (i = 0; i < results.size(); ++i) {
                DocumentScoreInfo dsi = (DocumentScoreInfo)results.get(i);
                this.output.println(this.trecTopicNumber + " Q0 " + titleList.get(dsi.document) + " " + i + " " + FORMATTER.format(dsi.score) + " " + this.trecRunTag);
            }
            if (results.size() == 0) {
                this.output.println(this.trecTopicNumber + " Q0 GX000-00-0000000 1 0 " + this.trecRunTag);
            }
        } else {
            for (i = 0; i < results.size(); ++i) {
                DocumentScoreInfo dsi = (DocumentScoreInfo)results.get(i);
                int document = dsi.document;
                this.output.print("Document #" + document);
                this.output.printf(" [%.6f]", dsi.score);
                Document d = null;
                if (titleList != null) {
                    this.output.println(" " + titleList.get(document));
                } else if (documentCollection != null) {
                    d = documentCollection.document(document);
                    this.output.println(" " + ((Object)d.title()).toString().trim());
                    d.close();
                } else {
                    this.output.println();
                }
                if (this.displayMode != OutputType.LONG && this.displayMode != OutputType.SNIPPET || dsi.info == null || this.queryEngine.intervalSelector == null) continue;
                Index[] sortedIndex = (Index[])((Reference2ObjectMap)dsi.info).keySet().toArray((Object[])new Index[0]);
                if (documentCollection != null) {
                    Arrays.sort(sortedIndex, new Comparator<Index>(){

                        @Override
                        public int compare(Index i0, Index i1) {
                            return documentCollection.factory().fieldIndex(i0.field) - documentCollection.factory().fieldIndex(i1.field);
                        }
                    });
                }
                for (Index index : sortedIndex) {
                    int fieldIndex;
                    if (index.hasPositions) {
                        int fieldIndex2;
                        Object[] interval = (SelectedInterval[])((Reference2ObjectMap)dsi.info).get((Object)index);
                        if (interval == SelectedInterval.TRUE_ARRAY) {
                            this.output.println(index.field + ": TRUE");
                            continue;
                        }
                        if (interval == SelectedInterval.FALSE_ARRAY) {
                            this.output.println(index.field + ": FALSE");
                            continue;
                        }
                        if (this.displayMode == OutputType.LONG || documentCollection == null) {
                            this.output.println(index.field + ": " + Arrays.toString(interval));
                            continue;
                        }
                        MarkingMutableString s = new MarkingMutableString(marker);
                        s.startField((SelectedInterval[])interval);
                        if (d == null) {
                            d = documentCollection.document(document);
                        }
                        if ((fieldIndex2 = documentCollection.factory().fieldIndex(index.field)) == -1 || documentCollection.factory().fieldType(fieldIndex2) != DocumentFactory.FieldType.TEXT) continue;
                        Reader reader = (Reader)d.content(fieldIndex2);
                        s.appendAndMark(d.wordReader(fieldIndex2).setReader(reader));
                        s.endField();
                        d.close();
                        this.output.println(index.field + ": " + s.toString());
                        continue;
                    }
                    if (!index.hasPayloads || ((Reference2ObjectMap)dsi.info).get((Object)index) != SelectedInterval.TRUE_ARRAY) continue;
                    if (d == null) {
                        d = documentCollection.document(document);
                    }
                    if ((fieldIndex = documentCollection.factory().fieldIndex(index.field)) == -1) continue;
                    this.output.println(d.content(fieldIndex));
                }
                this.output.println();
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP(Query.class.getName(), "Loads indices relative to a collection, possibly loads the collection, and answers to queries.", new Parameter[]{new FlaggedOption("collection", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "collection", "The collection of documents indexed by the given indices."), new FlaggedOption("objectCollection", (StringParser)new ObjectParser(DocumentCollection.class, MG4JClassParser.PACKAGE), JSAP.NO_DEFAULT, false, 'o', "object-collection", "An object specification describing a document collection."), new FlaggedOption("titleList", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 't', "title-list", "A serialized list of titles (will override collection titles if specified)."), new FlaggedOption("titleFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'T', "title-file", "A file of newline-separated, UTF-8 titles (will override collection titles if specified)."), new FlaggedOption("input", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'I', "input", "A file containing the input."), new Switch("noSizes", 'n', "no-sizes", "Disable loading document sizes (they are necessary for BM25 scoring)."), new Switch("http", 'h', "http", "Starts an HTTP query server."), new Switch("verbose", 'v', "verbose", "Print full exception stack traces."), new FlaggedOption("itemClass", (StringParser)MG4JClassParser.getParser(), JSAP.NO_DEFAULT, false, 'i', "item-class", "The class that will handle item display in the HTTP server."), new FlaggedOption("itemMimeType", (StringParser)JSAP.STRING_PARSER, "text/html", false, 'm', "item-mime-type", "A MIME type suggested to the class handling item display in the HTTP server."), new FlaggedOption("port", (StringParser)JSAP.INTEGER_PARSER, "4242", false, 'p', "port", "The port on localhost where the server will appear."), new UnflaggedOption("basenameWeight", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The indices that the servlet will use. Indices are specified using their basename, optionally followed by a colon and a double representing the weight used to score results from that index. Indices without a specified weight are weighted 1.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        DocumentCollection documentCollection = (DocumentCollection)(jsapResult.userSpecified("collection") ? AbstractDocumentSequence.load(jsapResult.getString("collection")) : (jsapResult.userSpecified("objectCollection") ? jsapResult.getObject("objectCollection") : null));
        List titleList = (List)(jsapResult.userSpecified("titleList") ? BinIO.loadObject((CharSequence)jsapResult.getString("titleList")) : (jsapResult.userSpecified("titleFile") ? new FileLinesList((CharSequence)jsapResult.getString("titleFile"), "UTF-8") : null));
        String[] basenameWeight = jsapResult.getStringArray("basenameWeight");
        Object2ReferenceLinkedOpenHashMap indexMap = new Object2ReferenceLinkedOpenHashMap(16, 0.5f);
        Reference2DoubleOpenHashMap index2Weight = new Reference2DoubleOpenHashMap();
        boolean verbose = jsapResult.getBoolean("verbose");
        boolean loadSizes = !jsapResult.getBoolean("noSizes");
        Query.loadIndicesFromSpec(basenameWeight, loadSizes, documentCollection, (Object2ReferenceMap<String, Index>)indexMap, (Reference2DoubleMap<Index>)index2Weight);
        Object2ObjectOpenHashMap termProcessors = new Object2ObjectOpenHashMap(indexMap.size());
        for (String alias : indexMap.keySet()) {
            termProcessors.put((Object)alias, (Object)((Index)indexMap.get((Object)alias)).termProcessor);
        }
        SimpleParser simpleParser = new SimpleParser((Set<String>)indexMap.keySet(), (String)indexMap.firstKey(), (Map<String, ? extends TermProcessor>)termProcessors);
        Reference2ReferenceOpenHashMap index2Parser = new Reference2ReferenceOpenHashMap();
        QueryEngine queryEngine = new QueryEngine(simpleParser, new DocumentIteratorBuilderVisitor((Object2ReferenceMap<String, Index>)indexMap, (Reference2ReferenceMap<Index, Object>)index2Parser, (Index)indexMap.get(indexMap.firstKey()), 1024), (Object2ReferenceMap<String, Index>)indexMap);
        queryEngine.setWeights((Reference2DoubleMap<Index>)index2Weight);
        queryEngine.score(new Scorer[]{new BM25Scorer(), new VignaScorer()}, new double[]{1.0, 1.0});
        queryEngine.intervalSelector = documentCollection != null ? new IntervalSelector(4, 40) : new IntervalSelector();
        queryEngine.multiplex = true;
        queryEngine.equalize(1000);
        Query query = new Query(queryEngine);
        query.displayMode = OutputType.SNIPPET;
        System.err.println("Welcome to the MG4J query class (setup with $mode snippet, $score BM25Scorer VignaScorer, $mplex on, $equalize 1000, $select " + (documentCollection != null ? "4 40" : "all") + ")");
        System.err.println("Please type $ for help.");
        String prompt = indexMap.keySet().toString() + ">";
        HttpQueryServer httpQueryServer = null;
        if (jsapResult.getBoolean("http")) {
            httpQueryServer = new HttpQueryServer(queryEngine, documentCollection, jsapResult.getClass("itemClass"), jsapResult.getString("itemMimeType"), jsapResult.getInt("port"), titleList);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(jsapResult.userSpecified("input") ? new FileInputStream(jsapResult.getString("input")) : System.in));
            ObjectArrayList results = new ObjectArrayList();
            while (true) {
                int n;
                System.out.print(prompt);
                String q = br.readLine();
                if (q == null) {
                    System.err.println();
                    break;
                }
                if (q.length() == 0) continue;
                if (q.charAt(0) == '$') {
                    if (query.interpretCommand(q)) continue;
                    break;
                }
                long time = -System.currentTimeMillis();
                try {
                    n = queryEngine.process(q, 0, query.maxOutput, (ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>>)results);
                }
                catch (QueryParserException e) {
                    if (verbose) {
                        e.getCause().printStackTrace(System.err);
                        continue;
                    }
                    System.err.println(e.getCause());
                    continue;
                }
                catch (Exception e) {
                    if (verbose) {
                        e.printStackTrace(System.err);
                        continue;
                    }
                    System.err.println(e);
                    continue;
                }
                query.output((ObjectArrayList<DocumentScoreInfo<Reference2ObjectMap<Index, SelectedInterval[]>>>)results, documentCollection, titleList, TextMarker.TEXT_BOLDFACE);
                System.err.println(results.size() + " results; " + n + " documents examined; " + (time += System.currentTimeMillis()) + " ms; " + Util.format((double)((double)n * 1000.0 / (double)time)) + " documents/s");
            }
        }
        finally {
            if (httpQueryServer != null) {
                httpQueryServer.server.stop();
            }
            if (query.output != System.out) {
                query.output.close();
            }
        }
    }

    public static enum OutputType {
        TIME,
        SHORT,
        LONG,
        SNIPPET,
        TREC;

    }

    public static enum Command {
        MODE,
        LIMIT,
        SELECT,
        SCORE,
        MPLEX,
        EXPAND,
        DIVERT,
        WEIGHT,
        EQUALIZE,
        QUIT;

    }
}

