/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query.nodes;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import it.unimi.dsi.mg4j.query.nodes.Align;
import it.unimi.dsi.mg4j.query.nodes.And;
import it.unimi.dsi.mg4j.query.nodes.Consecutive;
import it.unimi.dsi.mg4j.query.nodes.Difference;
import it.unimi.dsi.mg4j.query.nodes.False;
import it.unimi.dsi.mg4j.query.nodes.LowPass;
import it.unimi.dsi.mg4j.query.nodes.MultiTerm;
import it.unimi.dsi.mg4j.query.nodes.Not;
import it.unimi.dsi.mg4j.query.nodes.Or;
import it.unimi.dsi.mg4j.query.nodes.OrderedAnd;
import it.unimi.dsi.mg4j.query.nodes.Prefix;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitor;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.nodes.Range;
import it.unimi.dsi.mg4j.query.nodes.Remap;
import it.unimi.dsi.mg4j.query.nodes.Select;
import it.unimi.dsi.mg4j.query.nodes.Term;
import it.unimi.dsi.mg4j.query.nodes.True;
import it.unimi.dsi.mg4j.query.nodes.Weight;
import java.util.Set;

public class CheckForSelectQueryVisitor
implements QueryBuilderVisitor<Set<String>> {
    private final String defaultIndex;
    private ObjectArrayList<String> currentIndex = new ObjectArrayList();
    public String errorMessage;

    public CheckForSelectQueryVisitor(String defaultIndex) {
        this.defaultIndex = defaultIndex;
    }

    @Override
    public QueryBuilderVisitor<Set<String>> prepare() {
        this.currentIndex.clear();
        this.currentIndex.push((Object)this.defaultIndex);
        return this;
    }

    public Set<String>[] newArray(int len) {
        return new Set[len];
    }

    @Override
    public QueryBuilderVisitor<Set<String>> copy() {
        return new CheckForSelectQueryVisitor(this.defaultIndex);
    }

    private static Set<String> union(Set<String>[] a) {
        ObjectOpenHashSet s = new ObjectOpenHashSet();
        for (Set<String> t : a) {
            s.addAll(t);
        }
        return s;
    }

    private Set<String> checkUnion(Set<String>[] a, String operator) {
        ObjectOpenHashSet s = new ObjectOpenHashSet();
        for (Set<String> t : a) {
            s.addAll(t);
        }
        if (s.size() == 1) {
            return s;
        }
        this.errorMessage = "The " + operator + " operator requires subqueries on the same index";
        return null;
    }

    @Override
    public boolean visitPre(And node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(Consecutive node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(LowPass node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(Not node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(Or node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(OrderedAnd node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(Align node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(MultiTerm node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(Select node) throws QueryBuilderVisitorException {
        this.currentIndex.push((Object)((Object)node.index).toString());
        return true;
    }

    @Override
    public boolean visitPre(Remap node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(Weight node) throws QueryBuilderVisitorException {
        return true;
    }

    @Override
    public boolean visitPre(Difference node) throws QueryBuilderVisitorException {
        return true;
    }

    public Set<String> visitPost(And node, Set<String>[] v) throws QueryBuilderVisitorException {
        return CheckForSelectQueryVisitor.union(v);
    }

    public Set<String> visitPost(Consecutive node, Set<String>[] v) throws QueryBuilderVisitorException {
        return this.checkUnion(v, "phrase");
    }

    @Override
    public Set<String> visitPost(LowPass node, Set<String> v) throws QueryBuilderVisitorException {
        return v;
    }

    @Override
    public Set<String> visitPost(Not node, Set<String> v) throws QueryBuilderVisitorException {
        return v;
    }

    public Set<String> visitPost(Or node, Set<String>[] v) throws QueryBuilderVisitorException {
        return CheckForSelectQueryVisitor.union(v);
    }

    public Set<String> visitPost(OrderedAnd node, Set<String>[] v) throws QueryBuilderVisitorException {
        return this.checkUnion(v, "ordered AND");
    }

    public Set<String> visitPost(Align node, Set<String>[] v) throws QueryBuilderVisitorException {
        for (Set<String> t : v) {
            if (t.size() == 1) continue;
            this.errorMessage = "The alignment operator requires single-index subqueries";
            return null;
        }
        return v[0];
    }

    public Set<String> visitPost(MultiTerm node, Set<String>[] v) throws QueryBuilderVisitorException {
        return this.checkUnion(v, "expansion");
    }

    @Override
    public Set<String> visitPost(Select node, Set<String> v) {
        this.currentIndex.pop();
        return v;
    }

    @Override
    public Set<String> visitPost(Remap node, Set<String> v) throws QueryBuilderVisitorException {
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        for (String index : v) {
            String remappedIndex = (String)node.indexRemapping.get((Object)index);
            result.add((Object)(remappedIndex == null ? index : remappedIndex));
        }
        return result;
    }

    @Override
    public Set<String> visitPost(Weight node, Set<String> v) throws QueryBuilderVisitorException {
        return v;
    }

    public Set<String> visitPost(Difference node, Set<String>[] v) throws QueryBuilderVisitorException {
        return CheckForSelectQueryVisitor.union(v);
    }

    @Override
    public Set<String> visit(Term node) throws QueryBuilderVisitorException {
        return ObjectSets.singleton((Object)this.currentIndex.top());
    }

    @Override
    public Set<String> visit(Prefix node) throws QueryBuilderVisitorException {
        return ObjectSets.singleton((Object)this.currentIndex.top());
    }

    @Override
    public Set<String> visit(Range node) throws QueryBuilderVisitorException {
        return ObjectSets.singleton((Object)this.currentIndex.top());
    }

    @Override
    public Set<String> visit(True node) throws QueryBuilderVisitorException {
        return ObjectSets.singleton((Object)this.currentIndex.top());
    }

    @Override
    public Set<String> visit(False node) throws QueryBuilderVisitorException {
        return ObjectSets.singleton((Object)this.currentIndex.top());
    }
}

