/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query.nodes;

import it.unimi.dsi.mg4j.query.nodes.AbstractTermExpander;
import it.unimi.dsi.mg4j.query.nodes.Consecutive;
import it.unimi.dsi.mg4j.query.nodes.Or;
import it.unimi.dsi.mg4j.query.nodes.OrderedAnd;
import it.unimi.dsi.mg4j.query.nodes.Prefix;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.nodes.Select;
import it.unimi.dsi.mg4j.query.nodes.Term;

public class MultiIndexTermExpander
extends AbstractTermExpander {
    private final String[] index;
    private final int n;
    private final ExpanderVisitor expanderVisitor = new ExpanderVisitor();

    @Override
    protected ExpanderVisitor expanderVisitor() {
        return this.expanderVisitor;
    }

    public MultiIndexTermExpander(String ... index) {
        this.index = index;
        this.n = index.length;
    }

    protected Query expand(Consecutive consecutive) {
        Query[] query = new Query[this.n];
        for (int i = 0; i < this.n; ++i) {
            query[i] = new Select(this.index[i], consecutive);
        }
        return new Or(query);
    }

    protected Query expand(OrderedAnd orderedAnd) {
        Query[] query = new Query[this.n];
        for (int i = 0; i < this.n; ++i) {
            query[i] = new Select(this.index[i], orderedAnd);
        }
        return new Or(query);
    }

    @Override
    public Query expand(Term term) {
        Query[] query = new Query[this.n];
        for (int i = 0; i < this.n; ++i) {
            query[i] = new Select(this.index[i], term);
        }
        return new Or(query);
    }

    @Override
    public Query expand(Prefix prefix) {
        Query[] query = new Query[this.n];
        for (int i = 0; i < this.n; ++i) {
            query[i] = new Select(this.index[i], prefix);
        }
        return new Or(query);
    }

    protected class ExpanderVisitor
    extends AbstractTermExpander.ExpanderVisitor {
        int dontExpand;

        protected ExpanderVisitor() {
        }

        @Override
        public ExpanderVisitor copy() {
            return new ExpanderVisitor();
        }

        @Override
        public boolean visitPre(Consecutive node) {
            ++this.dontExpand;
            return true;
        }

        @Override
        public Query visitPost(Consecutive node, Query[] subNode) throws QueryBuilderVisitorException {
            --this.dontExpand;
            return MultiIndexTermExpander.this.expand(node);
        }

        @Override
        public boolean visitPre(OrderedAnd node) {
            ++this.dontExpand;
            return true;
        }

        @Override
        public Query visitPost(OrderedAnd node, Query[] subNode) throws QueryBuilderVisitorException {
            --this.dontExpand;
            return MultiIndexTermExpander.this.expand(node);
        }
    }
}

