/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.query.nodes;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.query.nodes.Composite;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitor;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.nodes.Term;
import it.unimi.dsi.mg4j.query.nodes.Weight;
import java.util.Arrays;

public class MultiTerm
extends Composite {
    private static final long serialVersionUID = 1L;

    public MultiTerm(Query ... query) {
        super(query);
        ObjectOpenHashSet s = new ObjectOpenHashSet(query.length);
        for (Query q : query) {
            if (!(q instanceof Term || q instanceof Weight && ((Weight)q).query instanceof Term)) {
                throw new IllegalArgumentException();
            }
            s.add((Object)new MutableString(q instanceof Term ? ((Term)q).term : ((Term)((Weight)q).query).term));
        }
        if (s.size() != query.length) {
            throw new IllegalArgumentException("Multiterm nodes require distinct terms");
        }
    }

    public String toString() {
        return super.toString("MULTITERM(", ")", ", ");
    }

    @Override
    public <T> T accept(QueryBuilderVisitor<T> visitor) throws QueryBuilderVisitorException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] result = visitor.newArray(this.query.length);
        for (int i = 0; i < this.query.length; ++i) {
            result[i] = this.query[i].accept(visitor);
            if (result[i] != null) continue;
            return null;
        }
        return visitor.visitPost(this, result);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiTerm)) {
            return false;
        }
        return Arrays.equals(this.query, ((MultiTerm)o).query);
    }

    public int hashCode() {
        return Arrays.hashCode(this.query) ^ this.getClass().hashCode();
    }
}

