/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import java.io.IOException;

public abstract class AbstractCompositeDocumentIterator
extends AbstractDocumentIterator
implements DocumentIterator {
    public final int n;
    protected final DocumentIterator[] documentIterator;
    protected final IndexIterator[] indexIterator;
    protected final ReferenceArraySet<Index> indices = new ReferenceArraySet();
    protected final Index soleIndex;

    protected AbstractCompositeDocumentIterator(Index index, DocumentIterator ... documentIterator) {
        int i;
        this.documentIterator = documentIterator;
        this.n = documentIterator.length;
        if (index == null) {
            i = this.n;
            while (i-- != 0) {
                this.indices.addAll(documentIterator[i].indices());
            }
            this.soleIndex = this.indices.size() == 1 ? (Index)this.indices.iterator().next() : null;
        } else {
            this.soleIndex = index;
            this.indices.add((Object)index);
        }
        i = this.n;
        while (i-- != 0 && documentIterator[i] instanceof IndexIterator) {
        }
        if (i == -1) {
            this.indexIterator = new IndexIterator[this.n];
            System.arraycopy(documentIterator, 0, this.indexIterator, 0, this.n);
        } else {
            this.indexIterator = null;
        }
    }

    protected AbstractCompositeDocumentIterator(DocumentIterator ... documentIterator) {
        this((Index)null, documentIterator);
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] a = visitor.newArray(this.n);
        if (a == null) {
            for (int i = 0; i < this.n; ++i) {
                if (this.documentIterator[i] == null || this.documentIterator[i].accept(visitor) != null) continue;
                return null;
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                if (this.documentIterator[i] == null || (a[i] = this.documentIterator[i].accept(visitor)) != null) continue;
                return null;
            }
        }
        return visitor.visitPost(this, a);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] a = visitor.newArray(this.n);
        if (a == null) {
            for (int i = 0; i < this.n; ++i) {
                if (this.documentIterator[i] == null || this.documentIterator[i].acceptOnTruePaths(visitor) != null) continue;
                return null;
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                if (this.documentIterator[i] == null || (a[i] = this.documentIterator[i].acceptOnTruePaths(visitor)) != null) continue;
                return null;
            }
        }
        return visitor.visitPost(this, a);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.indices;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return this.intervalIterator(this.soleIndex);
    }

    @Override
    public void dispose() throws IOException {
        for (DocumentIterator d : this.documentIterator) {
            d.dispose();
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.getClass().getSimpleName()).append("(");
        for (int i = 0; i < this.n; ++i) {
            res.append(i > 0 ? "," : "").append(this.documentIterator[i]);
        }
        res.append(")");
        if (this.weight != 1.0) {
            res.append('{').append(this.weight).append('}');
        }
        return res.toString();
    }

    protected static abstract class AbstractCompositeIndexIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator {
        protected int[][] position;
        protected int[] currPos;
        protected int[] curr;
        protected int[] count;

        public AbstractCompositeIndexIntervalIterator(int n) {
            this.position = new int[n][];
            this.count = new int[n];
            this.currPos = new int[n];
            this.curr = new int[n];
        }

        public String toString() {
            MutableString res = new MutableString();
            res.append(this.getClass().getName()).append("(").delete(0, res.lastIndexOf('.') + 1);
            for (int i = 0; i < this.position.length; ++i) {
                res.append(i > 0 ? "," : "").append(this.position[i] != null ? IntArrayList.wrap((int[])this.position[i], (int)this.count[i]) : "{}");
            }
            return res.append(")").toString();
        }
    }

    protected static abstract class AbstractCompositeIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator {
        protected IntervalIterator[] intervalIterator;
        protected Interval[] curr;

        public AbstractCompositeIntervalIterator(int n) {
            this.curr = new Interval[n];
            this.intervalIterator = new IntervalIterator[n];
        }

        public String toString() {
            MutableString res = new MutableString();
            res.append(this.getClass().getName()).append("(").delete(0, res.lastIndexOf('.') + 1);
            for (int i = 0; i < this.intervalIterator.length; ++i) {
                res.append(i > 0 ? "," : "").append((Object)this.intervalIterator[i]);
            }
            return res.append(")").toString();
        }
    }
}

