/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.util.Interval;
import java.io.IOException;
import java.util.NoSuchElementException;

public abstract class AbstractDocumentIterator
extends AbstractIntIterator
implements DocumentIterator {
    protected int curr = -1;
    protected boolean ahead;
    protected double weight = 1.0;

    protected static int toNextDocument(int curr) {
        return curr + 1 & Integer.MIN_VALUE | curr;
    }

    protected static int fromNextDocument(int d) {
        return d & Integer.MAX_VALUE;
    }

    @Override
    public double weight() {
        return this.weight;
    }

    @Override
    public DocumentIterator weight(double weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public IntervalIterator iterator() {
        try {
            return this.intervalIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasNext() {
        if (!this.ahead) {
            try {
                this.ahead = this.nextDocument() != -1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.ahead;
    }

    @Override
    @Deprecated
    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.ahead = false;
        return this.curr;
    }

    protected abstract int nextDocumentInternal() throws IOException;

    @Override
    public int nextDocument() throws IOException {
        if (this.ahead) {
            this.ahead = false;
            return this.curr;
        }
        if (this.curr == Integer.MAX_VALUE) {
            return -1;
        }
        return this.nextDocumentInternal();
    }

    protected final void ensureOnADocument() {
        if (this.ahead || (this.curr | Integer.MIN_VALUE) == -1) {
            throw new IllegalStateException();
        }
    }

    @Override
    public int document() {
        if (this.ahead) {
            throw new IllegalStateException();
        }
        return this.curr;
    }

    protected static abstract class AbstractIntervalIterator
    extends AbstractObjectIterator<Interval>
    implements IntervalIterator {
        protected Interval next;

        protected AbstractIntervalIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                try {
                    this.next = this.nextInterval();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.next != null;
        }

        @Override
        @Deprecated
        public Interval next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Interval result = this.next;
            this.next = null;
            return result;
        }
    }
}

