/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.AbstractCompositeDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.PayloadPredicateDocumentIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public abstract class AbstractIntersectionDocumentIterator
extends AbstractCompositeDocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    protected final Reference2ReferenceArrayMap<Index, IntervalIterator> intervalIterators;
    protected final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    protected final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;
    private final DocumentIterator[] sortedIterator;
    private final DocumentIterator lastIterator;
    private final PayloadPredicateDocumentIterator[] payloadPredicateDocumentIterator;
    private final int predicateStart;

    protected AbstractIntersectionDocumentIterator(Index index, DocumentIterator[] documentIterator) throws IOException {
        super(index, documentIterator);
        if (documentIterator.length == 0) {
            throw new IllegalArgumentException("The provided array of document iterators is empty.");
        }
        this.sortedIterator = (DocumentIterator[])documentIterator.clone();
        this.intervalIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.currentIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
        Arrays.sort(this.sortedIterator, new Comparator<DocumentIterator>(){

            @Override
            public int compare(DocumentIterator d0, DocumentIterator d1) {
                IndexIterator i1;
                PayloadPredicateDocumentIterator p1;
                PayloadPredicateDocumentIterator p0 = d0 instanceof PayloadPredicateDocumentIterator ? (PayloadPredicateDocumentIterator)d0 : null;
                PayloadPredicateDocumentIterator payloadPredicateDocumentIterator = p1 = d1 instanceof PayloadPredicateDocumentIterator ? (PayloadPredicateDocumentIterator)d1 : null;
                if (p0 != null && p1 != null) {
                    return 0;
                }
                if (p0 != null) {
                    return -1;
                }
                if (p1 != null) {
                    return 1;
                }
                IndexIterator i0 = d0 instanceof IndexIterator ? (IndexIterator)d0 : null;
                IndexIterator indexIterator = i1 = d1 instanceof IndexIterator ? (IndexIterator)d1 : null;
                if (i0 == null && i1 == null) {
                    return 0;
                }
                if (i0 != null != (i1 != null)) {
                    return i0 != null ? 1 : -1;
                }
                try {
                    return i1.frequency() - i0.frequency();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.lastIterator = this.sortedIterator[this.n - 1];
        int i = this.n;
        while (i-- != 0 && !(this.sortedIterator[i] instanceof PayloadPredicateDocumentIterator)) {
        }
        this.predicateStart = i + 1;
        this.payloadPredicateDocumentIterator = new PayloadPredicateDocumentIterator[this.predicateStart];
        i = this.predicateStart;
        while (i-- != 0) {
            this.payloadPredicateDocumentIterator[i] = (PayloadPredicateDocumentIterator)this.sortedIterator[i];
        }
        i = this.n;
        while (i-- != 0) {
            if (this.sortedIterator[i].nextDocument() != -1) continue;
            this.curr = Integer.MAX_VALUE;
            return;
        }
        this.ahead = this.align();
    }

    protected AbstractIntersectionDocumentIterator(DocumentIterator[] documentIterator) throws IOException {
        this((Index)null, documentIterator);
    }

    private boolean align() throws IOException {
        int i;
        int candidate = this.lastIterator.document();
        block0: do {
            i = this.n;
            while (i-- != 0) {
                int res = i < this.predicateStart ? this.payloadPredicateDocumentIterator[i].skipUnconditionallyTo(candidate) : this.sortedIterator[i].skipTo(candidate);
                if (res == Integer.MAX_VALUE) {
                    this.curr = Integer.MAX_VALUE;
                    return false;
                }
                if (res == candidate) continue;
                if (res > candidate) {
                    candidate = res;
                    continue block0;
                }
                ++candidate;
                continue block0;
            }
        } while (i != -1);
        this.curr = candidate;
        return true;
    }

    @Override
    public int skipTo(int n) throws IOException {
        this.ahead = false;
        if (this.curr >= n) {
            return this.curr;
        }
        this.currentIterators.clear();
        this.curr = this.lastIterator.skipTo(n);
        if (this.curr != Integer.MAX_VALUE) {
            this.align();
        }
        return this.curr;
    }

    @Override
    protected int nextDocumentInternal() throws IOException {
        this.currentIterators.clear();
        if (this.lastIterator.nextDocument() != -1) {
            this.align();
        } else {
            this.curr = Integer.MAX_VALUE;
        }
        return AbstractIntersectionDocumentIterator.toNextDocument(this.curr);
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        ObjectIterator i = this.indices.iterator();
        while (i.hasNext()) {
            this.intervalIterator((Index)i.next());
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        this.ensureOnADocument();
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.FALSE;
        }
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        int t = 0;
        int f = 0;
        if (this.indexIterator == null) {
            for (int i = 0; i < this.n; ++i) {
                intervalIterator = this.documentIterator[i].intervalIterator(index);
                if (intervalIterator == IntervalIterators.TRUE) {
                    ++t;
                }
                if (intervalIterator != IntervalIterators.FALSE) continue;
                ++f;
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                Index indexIteratorIndex = this.indexIterator[i].index();
                if (indexIteratorIndex != index) {
                    ++f;
                    continue;
                }
                if (this.indexIterator[i].index().hasPositions) continue;
                ++t;
            }
        }
        if (f == this.n) {
            intervalIterator = IntervalIterators.FALSE;
        } else if (t + f == this.n) {
            intervalIterator = IntervalIterators.TRUE;
        } else {
            intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
            if (intervalIterator == null) {
                intervalIterator = this.getComposedIntervalIterator(index);
                this.intervalIterators.put((Object)index, (Object)intervalIterator);
            }
            intervalIterator.reset();
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        return intervalIterator;
    }

    protected abstract IntervalIterator getComposedIntervalIterator(Index var1);
}

