/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractCompositeDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;

public abstract class AbstractUnionDocumentIterator
extends AbstractCompositeDocumentIterator {
    private static final boolean DEBUG = false;
    protected final IntHeapSemiIndirectPriorityQueue queue;
    protected final int[] front;
    protected final int[] refArray = new int[this.n];
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> intervalIterators;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;
    protected int frontSize = -1;

    protected AbstractUnionDocumentIterator(DocumentIterator ... documentIterator) throws IOException {
        super(documentIterator);
        this.queue = new IntHeapSemiIndirectPriorityQueue(this.refArray);
        this.intervalIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.currentIterators = new Reference2ReferenceArrayMap(this.indices.size());
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
        for (int i = 0; i < this.n; ++i) {
            this.refArray[i] = documentIterator[i].nextDocument();
            if (this.refArray[i] == -1) continue;
            this.queue.enqueue(i);
        }
        if (this.queue.isEmpty()) {
            this.curr = Integer.MAX_VALUE;
        } else {
            this.curr = this.refArray[this.queue.first()];
            this.ahead = true;
        }
        this.front = new int[this.queue.size()];
    }

    @Override
    public int skipTo(int n) throws IOException {
        int first;
        this.ahead = false;
        if (this.curr >= n) {
            return this.curr;
        }
        this.currentIterators.clear();
        this.frontSize = -1;
        while (this.refArray[first = this.queue.first()] < n) {
            int res = this.documentIterator[first].skipTo(n);
            if (res == Integer.MAX_VALUE) {
                this.queue.dequeue();
                if (!this.queue.isEmpty()) continue;
                this.curr = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.refArray[first] = res;
            this.queue.changed();
        }
        this.curr = this.refArray[first];
        return this.curr;
    }

    @Override
    protected int nextDocumentInternal() throws IOException {
        int first;
        this.currentIterators.clear();
        this.frontSize = -1;
        int c = this.refArray[this.queue.first()];
        while (this.refArray[first = this.queue.first()] == c) {
            this.refArray[first] = this.documentIterator[first].nextDocument();
            if (this.refArray[first] != -1) {
                this.queue.changed();
                continue;
            }
            this.queue.dequeue();
            if (!this.queue.isEmpty()) continue;
            this.curr = Integer.MAX_VALUE;
            return -1;
        }
        this.curr = this.refArray[first];
        return this.curr;
    }

    protected int computeFront() {
        if (this.frontSize == -1) {
            this.frontSize = this.queue.front(this.front);
        }
        return this.frontSize;
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        ObjectIterator i = this.indices.iterator();
        while (i.hasNext()) {
            this.intervalIterator((Index)i.next());
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        this.ensureOnADocument();
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.FALSE;
        }
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        int t = 0;
        int f = 0;
        int c = this.computeFront();
        IntervalIterator soleIterator = null;
        if (this.indexIterator == null) {
            int i = c;
            while (i-- != 0) {
                intervalIterator = this.documentIterator[this.front[i]].intervalIterator(index);
                if (intervalIterator == IntervalIterators.TRUE) {
                    ++t;
                    continue;
                }
                if (intervalIterator == IntervalIterators.FALSE) {
                    ++f;
                    continue;
                }
                if (soleIterator != null) continue;
                soleIterator = intervalIterator;
            }
        } else {
            int i = c;
            while (i-- != 0) {
                Index indexIteratorIndex = this.indexIterator[this.front[i]].index();
                if (indexIteratorIndex != index) {
                    ++f;
                    continue;
                }
                if (!indexIteratorIndex.hasPositions) {
                    ++t;
                    continue;
                }
                if (soleIterator != null) continue;
                soleIterator = this.indexIterator[this.front[i]].intervalIterator(index);
            }
        }
        if (f == c) {
            intervalIterator = IntervalIterators.FALSE;
        } else if (f + t == c) {
            intervalIterator = IntervalIterators.TRUE;
        } else if (f + t < c - 1) {
            intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
            if (intervalIterator == null) {
                intervalIterator = this.getComposedIntervalIterator(index);
                this.intervalIterators.put((Object)index, (Object)intervalIterator);
            }
            intervalIterator.reset();
        } else {
            intervalIterator = soleIterator;
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        return intervalIterator;
    }

    protected abstract IntervalIterator getComposedIntervalIterator(Index var1);

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        int s = this.computeFront();
        T[] a = visitor.newArray(s);
        if (a == null) {
            for (int i = 0; i < s; ++i) {
                if (this.documentIterator[this.front[i]].acceptOnTruePaths(visitor) != null) continue;
                return null;
            }
        } else {
            for (int i = 0; i < s; ++i) {
                a[i] = this.documentIterator[this.front[i]].acceptOnTruePaths(visitor);
                if (a[i] != null) continue;
                return null;
            }
        }
        return visitor.visitPost(this, a);
    }
}

