/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import java.io.IOException;

public class AlignDocumentIterator
extends AbstractDocumentIterator {
    private static final boolean DEBUG = false;
    private final DocumentIterator firstIterator;
    private final DocumentIterator secondIterator;
    private final IndexIterator firstIndexIterator;
    private final IndexIterator secondIndexIterator;
    private final Index index;
    private final Reference2ReferenceMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;
    private IntervalIterator intervalIterator;
    private IntervalIterator currentIterator;

    public static DocumentIterator getInstance(DocumentIterator firstIterator, DocumentIterator secondIterator) {
        return new AlignDocumentIterator(firstIterator, secondIterator);
    }

    protected AlignDocumentIterator(DocumentIterator firstIterator, DocumentIterator secondIterator) {
        this.firstIterator = firstIterator;
        this.secondIterator = secondIterator;
        if (firstIterator instanceof IndexIterator && secondIterator instanceof IndexIterator) {
            this.firstIndexIterator = (IndexIterator)firstIterator;
            this.secondIndexIterator = (IndexIterator)secondIterator;
        } else {
            this.secondIndexIterator = null;
            this.firstIndexIterator = null;
        }
        if (firstIterator.indices().size() != 1 || secondIterator.indices().size() != 1) {
            throw new IllegalArgumentException("You can align single-index iterators only");
        }
        this.index = (Index)firstIterator.indices().iterator().next();
        this.currentIterators = new Reference2ReferenceArrayMap(1);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.firstIterator.indices();
    }

    @Override
    protected int nextDocumentInternal() throws IOException {
        this.currentIterator = null;
        int first = this.firstIterator.nextDocument();
        if (first != -1) {
            int second = -1;
            while (true) {
                if (first < second) {
                    first = this.firstIterator.skipTo(second);
                    if (first != Integer.MAX_VALUE) continue;
                    break;
                }
                if (second < first) {
                    second = this.secondIterator.skipTo(first);
                    if (second != Integer.MAX_VALUE) continue;
                    break;
                }
                this.curr = first;
                if (this.intervalIterator().hasNext()) {
                    return first;
                }
                this.currentIterator = null;
                first = this.firstIterator.nextDocument();
                if (first == -1) break;
            }
        }
        this.curr = Integer.MAX_VALUE;
        return -1;
    }

    @Override
    public int skipTo(int n) throws IOException {
        this.ahead = false;
        if (this.curr >= n) {
            return this.curr;
        }
        this.currentIterator = null;
        int first = this.firstIterator.skipTo(n);
        if (first == Integer.MAX_VALUE) {
            this.curr = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        int second = -1;
        while (true) {
            if (first < second) {
                first = this.firstIterator.skipTo(second);
                if (first != Integer.MAX_VALUE) continue;
                this.curr = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (second < first) {
                second = this.secondIterator.skipTo(first);
                if (second != Integer.MAX_VALUE) continue;
                this.curr = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.curr = first;
            if (this.intervalIterator().hasNext()) {
                return first;
            }
            this.currentIterator = null;
            first = this.firstIterator.nextDocument();
            if (first == -1) break;
        }
        this.curr = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        return this.intervalIterator(this.index);
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        this.currentIterators.put((Object)this.index, (Object)this.intervalIterator());
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        this.ensureOnADocument();
        if (index != this.index) {
            return IntervalIterators.FALSE;
        }
        if (this.currentIterator != null) {
            return this.currentIterator;
        }
        IntervalIterator firstIntervalIterator = this.firstIterator.intervalIterator();
        IntervalIterator secondIntervalIterator = this.secondIterator.intervalIterator();
        if (secondIntervalIterator == IntervalIterators.FALSE) {
            this.currentIterator = IntervalIterators.FALSE;
            return this.currentIterator;
        }
        if (secondIntervalIterator == IntervalIterators.TRUE) {
            this.currentIterator = firstIntervalIterator == IntervalIterators.TRUE ? IntervalIterators.TRUE : IntervalIterators.FALSE;
            return this.currentIterator;
        }
        if (firstIntervalIterator == IntervalIterators.TRUE) {
            this.currentIterator = IntervalIterators.FALSE;
            return this.currentIterator;
        }
        if (this.intervalIterator == null) {
            this.intervalIterator = this.firstIndexIterator == null ? new AlignIntervalIterator() : new AlignIndexIntervalIterator();
        }
        this.intervalIterator.reset();
        this.currentIterator = this.intervalIterator;
        return this.currentIterator;
    }

    @Override
    public void dispose() throws IOException {
        this.firstIterator.dispose();
        this.secondIterator.dispose();
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] a = visitor.newArray(2);
        if (a == null) {
            if (this.firstIterator.accept(visitor) == null) {
                return null;
            }
            if (this.secondIterator.accept(visitor) == null) {
                return null;
            }
        } else {
            a[0] = this.firstIterator.accept(visitor);
            if (a[0] == null) {
                return null;
            }
            a[1] = this.secondIterator.accept(visitor);
            if (a[1] == null) {
                return null;
            }
        }
        return visitor.visitPost(this, a);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] a = visitor.newArray(1);
        if (a == null ? this.firstIterator.acceptOnTruePaths(visitor) == null : (a[0] = this.firstIterator.acceptOnTruePaths(visitor)) == null) {
            return null;
        }
        return visitor.visitPost(this, a);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.firstIterator + ", " + this.secondIterator + ")";
    }

    private class AlignIndexIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator
    implements IntervalIterator {
        private boolean endOfProcess;
        private int[] firstPosition;
        private int[] secondPosition;
        private int firstCount;
        private int secondCount;
        private int firstCurr;
        private int secondCurr;

        private AlignIndexIntervalIterator() {
        }

        @Override
        public void reset() throws IOException {
            this.next = null;
            this.endOfProcess = false;
            this.firstPosition = AlignDocumentIterator.this.firstIndexIterator.positionArray();
            this.secondPosition = AlignDocumentIterator.this.secondIndexIterator.positionArray();
            this.firstCount = AlignDocumentIterator.this.firstIndexIterator.count();
            this.secondCount = AlignDocumentIterator.this.secondIndexIterator.count();
            this.secondCurr = -1;
            this.firstCurr = -1;
        }

        @Override
        public void intervalTerms(IntSet terms) {
            terms.add(AlignDocumentIterator.this.firstIndexIterator.termNumber());
        }

        @Override
        public Interval nextInterval() {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            int[] firstPosition = this.firstPosition;
            int[] secondPosition = this.secondPosition;
            if (++this.firstCurr == this.firstCount || ++this.secondCurr == this.secondCount) {
                this.endOfProcess = true;
                return null;
            }
            while (firstPosition[this.firstCurr] != secondPosition[this.secondCurr]) {
                if (firstPosition[this.firstCurr] < secondPosition[this.secondCurr]) {
                    if (++this.firstCurr != this.firstCount) continue;
                    this.endOfProcess = true;
                    return null;
                }
                if (++this.secondCurr != this.secondCount) continue;
                this.endOfProcess = true;
                return null;
            }
            return Interval.valueOf((int)secondPosition[this.secondCurr]);
        }

        @Override
        public int extent() {
            return 1;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + AlignDocumentIterator.this.firstIterator + ", " + AlignDocumentIterator.this.secondIterator + ")";
        }
    }

    private class AlignIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator
    implements IntervalIterator {
        private IntervalIterator firstIntervalIterator;
        private IntervalIterator secondIntervalIterator;
        private boolean endOfProcess;

        private AlignIntervalIterator() {
        }

        @Override
        public void reset() throws IOException {
            this.next = null;
            this.endOfProcess = false;
            this.firstIntervalIterator = AlignDocumentIterator.this.firstIterator.intervalIterator();
            this.secondIntervalIterator = AlignDocumentIterator.this.secondIterator.intervalIterator();
        }

        @Override
        public void intervalTerms(IntSet terms) {
            this.firstIntervalIterator.intervalTerms(terms);
        }

        @Override
        public Interval nextInterval() throws IOException {
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            Interval firstInterval = null;
            Interval secondInterval = null;
            firstInterval = this.firstIntervalIterator.nextInterval();
            secondInterval = this.secondIntervalIterator.nextInterval();
            if (firstInterval == null || secondInterval == null) {
                this.endOfProcess = true;
                return null;
            }
            while (!firstInterval.equals((Object)secondInterval)) {
                if (firstInterval.left <= secondInterval.left) {
                    firstInterval = this.firstIntervalIterator.nextInterval();
                    if (firstInterval != null) continue;
                    this.endOfProcess = true;
                    return null;
                }
                secondInterval = this.secondIntervalIterator.nextInterval();
                if (secondInterval != null) continue;
                this.endOfProcess = true;
                return null;
            }
            return firstInterval;
        }

        @Override
        public int extent() {
            return this.firstIntervalIterator.extent();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + AlignDocumentIterator.this.firstIterator + ", " + AlignDocumentIterator.this.secondIterator + ")";
        }
    }
}

