/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractCompositeDocumentIterator;
import it.unimi.dsi.mg4j.search.AbstractIntersectionDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.TrueDocumentIterator;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import java.io.IOException;

public class AndDocumentIterator
extends AbstractIntersectionDocumentIterator {
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;

    public static DocumentIterator getInstance(Index index, DocumentIterator ... documentIterator) throws IOException {
        if (documentIterator.length == 0) {
            return TrueDocumentIterator.getInstance(index);
        }
        if (documentIterator.length == 1) {
            return documentIterator[0];
        }
        return new AndDocumentIterator(documentIterator);
    }

    public static DocumentIterator getInstance(DocumentIterator ... documentIterator) throws IOException {
        if (documentIterator.length == 0) {
            throw new IllegalArgumentException("The provided array of document iterators is empty.");
        }
        return AndDocumentIterator.getInstance(null, documentIterator);
    }

    protected AndDocumentIterator(DocumentIterator[] documentIterator) throws IOException {
        super(documentIterator);
    }

    @Override
    protected IntervalIterator getComposedIntervalIterator(Index index) {
        return this.indexIterator == null ? new AndIntervalIterator(index) : new AndIndexIntervalIterator(index);
    }

    private class AndIndexIntervalIterator
    extends AbstractCompositeDocumentIterator.AbstractCompositeIndexIntervalIterator
    implements IntervalIterator {
        private final Index index;
        private final IntHeapSemiIndirectPriorityQueue queue;
        private boolean endOfProcess;
        private int lastLeft;
        private int maxRight;

        public AndIndexIntervalIterator(Index index) {
            super(AndDocumentIterator.this.n);
            this.index = index;
            this.queue = new IntHeapSemiIndirectPriorityQueue(this.curr);
        }

        @Override
        public void reset() throws IOException {
            this.queue.clear();
            this.maxRight = Integer.MIN_VALUE;
            this.lastLeft = Integer.MIN_VALUE;
            this.next = null;
            this.endOfProcess = false;
            for (int i = 0; i < AndDocumentIterator.this.n; ++i) {
                Index indexIteratorIndex = AndDocumentIterator.this.indexIterator[i].index();
                if (indexIteratorIndex != this.index || !indexIteratorIndex.hasPositions) continue;
                this.position[i] = AndDocumentIterator.this.indexIterator[i].positionArray();
                this.count[i] = AndDocumentIterator.this.indexIterator[i].count();
                this.currPos[i] = 0;
                this.curr[i] = this.position[i][0];
                this.queue.enqueue(i);
                this.maxRight = Math.max(this.maxRight, this.curr[i]);
            }
        }

        @Override
        public void intervalTerms(IntSet terms) {
            int i = AndDocumentIterator.this.n;
            while (i-- != 0) {
                terms.add(AndDocumentIterator.this.indexIterator[i].termNumber());
            }
        }

        @Override
        public Interval nextInterval() {
            int nextLeft;
            int nextRight;
            int first;
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            while (this.curr[first = this.queue.first()] == this.lastLeft) {
                int n = first;
                this.currPos[n] = this.currPos[n] + 1;
                if (this.currPos[n] == this.count[first]) {
                    this.endOfProcess = true;
                    return null;
                }
                this.curr[first] = this.position[first][this.currPos[first]];
                this.maxRight = Math.max(this.maxRight, this.curr[first]);
                this.queue.changed();
            }
            do {
                first = this.queue.first();
                nextLeft = this.curr[first];
                nextRight = this.maxRight;
                if (this.curr[first] == this.maxRight) break;
                int n = first;
                this.currPos[n] = this.currPos[n] + 1;
                this.endOfProcess = this.currPos[n] == this.count[first];
                if (this.endOfProcess) break;
                this.curr[first] = this.position[first][this.currPos[first]];
                if (this.maxRight < this.curr[first]) {
                    this.maxRight = this.curr[first];
                }
                this.queue.changed();
            } while (this.maxRight == nextRight);
            this.lastLeft = nextLeft;
            return Interval.valueOf((int)this.lastLeft, (int)nextRight);
        }

        @Override
        public int extent() {
            return AndDocumentIterator.this.n;
        }
    }

    private class AndIntervalIterator
    extends AbstractCompositeDocumentIterator.AbstractCompositeIntervalIterator
    implements IntervalIterator {
        private final Index index;
        private final ObjectHeapSemiIndirectPriorityQueue<Interval> queue;
        private boolean endOfProcess;
        private int lastLeft;
        private int maxRight;

        public AndIntervalIterator(Index index) {
            super(AndDocumentIterator.this.n);
            this.index = index;
            this.queue = new ObjectHeapSemiIndirectPriorityQueue((Object[])this.curr, Intervals.STARTS_BEFORE_OR_PROLONGS);
        }

        @Override
        public void reset() throws IOException {
            ObjectArrays.fill((Object[])this.curr, null);
            this.queue.clear();
            this.next = null;
            this.maxRight = Integer.MIN_VALUE;
            this.lastLeft = Integer.MIN_VALUE;
            this.endOfProcess = false;
            for (int i = 0; i < AndDocumentIterator.this.n; ++i) {
                this.intervalIterator[i] = AndDocumentIterator.this.documentIterator[i].intervalIterator(this.index);
                if (this.intervalIterator[i] == IntervalIterators.TRUE || this.intervalIterator[i] == IntervalIterators.FALSE) continue;
                this.curr[i] = this.intervalIterator[i].nextInterval();
                this.queue.enqueue(i);
                this.maxRight = Math.max(this.maxRight, this.curr[i].right);
            }
        }

        @Override
        public void intervalTerms(IntSet terms) {
            int i = AndDocumentIterator.this.n;
            while (i-- != 0) {
                this.intervalIterator[i].intervalTerms(terms);
            }
        }

        @Override
        public Interval nextInterval() throws IOException {
            int nextLeft;
            int nextRight;
            int first;
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.endOfProcess) {
                return null;
            }
            while (true) {
                first = this.queue.first();
                if (this.curr[first].left != this.lastLeft) break;
                this.curr[first] = this.intervalIterator[first].nextInterval();
                if (this.curr[first] == null) {
                    this.endOfProcess = true;
                    return null;
                }
                this.maxRight = Math.max(this.maxRight, this.curr[first].right);
                this.queue.changed();
            }
            do {
                first = this.queue.first();
                nextLeft = this.curr[first].left;
                nextRight = this.maxRight;
                if (this.curr[first].right == this.maxRight || (this.endOfProcess = (this.curr[first] = this.intervalIterator[first].nextInterval()) == null)) break;
                this.maxRight = Math.max(this.maxRight, this.curr[first].right);
                this.queue.changed();
            } while (this.maxRight == nextRight);
            this.lastLeft = nextLeft;
            return Interval.valueOf((int)this.lastLeft, (int)nextRight);
        }

        @Override
        public int extent() {
            int s = 0;
            int i = AndDocumentIterator.this.n;
            while (i-- != 0) {
                s += this.intervalIterator[i].extent();
            }
            return s;
        }
    }
}

