/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import java.io.IOException;

public class DifferenceDocumentIterator
extends AbstractDocumentIterator
implements DocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private final DocumentIterator minuendIterator;
    private final DocumentIterator subtrahendIterator;
    private final Index soleIndex;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> intervalIterators;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;
    private final int leftMargin;
    private final int rightMargin;
    private boolean noSubtrahend;
    private boolean nonEmptySubtrahend;

    protected DifferenceDocumentIterator(DocumentIterator minuendIterator, DocumentIterator subtrahendIterator, int leftMargin, int rightMargin) {
        if (leftMargin < 0 || rightMargin < 0) {
            throw new IllegalArgumentException("Illegal margins: " + leftMargin + ", " + rightMargin);
        }
        this.minuendIterator = minuendIterator;
        this.subtrahendIterator = subtrahendIterator;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        int n = minuendIterator.indices().size();
        this.soleIndex = n == 1 ? (Index)this.indices().iterator().next() : null;
        this.nonEmptySubtrahend = subtrahendIterator.hasNext();
        this.intervalIterators = new Reference2ReferenceArrayMap(n);
        this.currentIterators = new Reference2ReferenceArrayMap(n);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
    }

    public static DocumentIterator getInstance(DocumentIterator minuendIterator, DocumentIterator subtrahendIterator) {
        return DifferenceDocumentIterator.getInstance(minuendIterator, subtrahendIterator, 0, 0);
    }

    public static DocumentIterator getInstance(DocumentIterator minuendIterator, DocumentIterator subtrahendIterator, int leftMargin, int rightMargin) {
        return new DifferenceDocumentIterator(minuendIterator, subtrahendIterator, leftMargin, rightMargin);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.minuendIterator.indices();
    }

    @Override
    protected int nextDocumentInternal() throws IOException {
        do {
            this.currentIterators.clear();
        } while ((this.curr = this.minuendIterator.nextDocument()) != -1 && this.nonEmptySubtrahend && !this.isValid());
        int d = this.curr;
        this.curr = DifferenceDocumentIterator.fromNextDocument(d);
        return d;
    }

    @Override
    public int skipTo(int n) throws IOException {
        this.ahead = false;
        if (this.curr >= n) {
            return this.curr;
        }
        this.currentIterators.clear();
        this.curr = this.minuendIterator.skipTo(n);
        if (this.curr != Integer.MAX_VALUE) {
            if (this.isValid()) {
                return this.curr;
            }
            this.nextDocumentInternal();
        }
        return this.curr;
    }

    private boolean isValid() throws IOException {
        this.noSubtrahend = this.subtrahendIterator.skipTo(this.curr) != this.curr;
        if (this.noSubtrahend) {
            return true;
        }
        if (this.soleIndex != null) {
            return this.intervalIterator(this.soleIndex).hasNext();
        }
        for (Index index : this.indices()) {
            if (!this.intervalIterator(index).hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        for (Index index : this.indices()) {
            this.intervalIterator(index);
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return this.intervalIterator(this.soleIndex);
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        this.ensureOnADocument();
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator != null) {
            return intervalIterator;
        }
        intervalIterator = this.minuendIterator.intervalIterator(index);
        if (intervalIterator == IntervalIterators.FALSE) {
            return IntervalIterators.FALSE;
        }
        if (this.nonEmptySubtrahend && !this.noSubtrahend) {
            IntervalIterator subtrahendIntervalIterator = this.subtrahendIterator.intervalIterator(index);
            if (subtrahendIntervalIterator == IntervalIterators.TRUE) {
                intervalIterator = IntervalIterators.FALSE;
            } else if (intervalIterator != IntervalIterators.TRUE && subtrahendIntervalIterator != IntervalIterators.FALSE) {
                intervalIterator = (IntervalIterator)this.intervalIterators.get((Object)index);
                if (intervalIterator == null) {
                    intervalIterator = new DifferenceIntervalIterator(index);
                    this.intervalIterators.put((Object)index, (Object)intervalIterator);
                }
                intervalIterator.reset();
                if (!intervalIterator.hasNext()) {
                    intervalIterator = IntervalIterators.FALSE;
                }
            }
        }
        this.currentIterators.put((Object)index, (Object)intervalIterator);
        return intervalIterator;
    }

    @Override
    public void dispose() throws IOException {
        this.minuendIterator.dispose();
        this.subtrahendIterator.dispose();
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] a = visitor.newArray(2);
        if (a == null) {
            if (this.minuendIterator.accept(visitor) == null) {
                return null;
            }
            if (this.subtrahendIterator.accept(visitor) == null) {
                return null;
            }
        } else {
            a[0] = this.minuendIterator.accept(visitor);
            if (a[0] == null) {
                return null;
            }
            a[1] = this.subtrahendIterator.accept(visitor);
            if (a[1] == null) {
                return null;
            }
        }
        return visitor.visitPost(this, a);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] a = visitor.newArray(1);
        if (a == null ? this.minuendIterator.acceptOnTruePaths(visitor) == null : (a[0] = this.minuendIterator.acceptOnTruePaths(visitor)) == null) {
            return null;
        }
        return visitor.visitPost(this, a);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.minuendIterator + (this.leftMargin == 0 && this.rightMargin == 0 ? " - " : " -[" + this.leftMargin + "," + this.rightMargin + "] ") + this.subtrahendIterator + ")";
    }

    private class DifferenceIntervalIterator
    extends AbstractDocumentIterator.AbstractIntervalIterator
    implements IntervalIterator {
        final Index index;
        private IntervalIterator minuendIntervalIterator;
        private IntervalIterator subtrahendIntervalIterator;
        private Interval subtrahendInterval;

        public DifferenceIntervalIterator(Index index) {
            this.index = index;
        }

        @Override
        public void reset() throws IOException {
            this.next = null;
            this.subtrahendInterval = Intervals.MINUS_INFINITY;
            this.minuendIntervalIterator = DifferenceDocumentIterator.this.minuendIterator.intervalIterator(this.index);
            this.subtrahendIntervalIterator = DifferenceDocumentIterator.this.subtrahendIterator.intervalIterator(this.index);
        }

        @Override
        public void intervalTerms(IntSet terms) {
            this.minuendIntervalIterator.intervalTerms(terms);
        }

        @Override
        public Interval nextInterval() throws IOException {
            Interval minuendInterval;
            if (this.next != null) {
                Interval result = this.next;
                this.next = null;
                return result;
            }
            if (this.subtrahendInterval == Intervals.MINUS_INFINITY) {
                this.subtrahendInterval = this.subtrahendIntervalIterator.nextInterval();
            }
            while ((minuendInterval = this.minuendIntervalIterator.nextInterval()) != null) {
                while (this.subtrahendInterval != null && this.subtrahendInterval.left - DifferenceDocumentIterator.this.leftMargin < minuendInterval.left && this.subtrahendInterval.right + DifferenceDocumentIterator.this.rightMargin < minuendInterval.right) {
                    this.subtrahendInterval = this.subtrahendIntervalIterator.nextInterval();
                }
                if (this.subtrahendInterval != null && this.subtrahendInterval.left - DifferenceDocumentIterator.this.leftMargin >= minuendInterval.left && this.subtrahendInterval.right + DifferenceDocumentIterator.this.rightMargin <= minuendInterval.right) continue;
                return minuendInterval;
            }
            return null;
        }

        @Override
        public int extent() {
            return this.minuendIntervalIterator.extent();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.minuendIntervalIterator + (DifferenceDocumentIterator.this.leftMargin == 0 && DifferenceDocumentIterator.this.rightMargin == 0 ? " - " : " -[" + DifferenceDocumentIterator.this.leftMargin + "," + DifferenceDocumentIterator.this.rightMargin + "] ") + this.subtrahendIntervalIterator + ")";
        }
    }
}

