/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.MultiTermIndexIterator;
import it.unimi.dsi.mg4j.index.TooManyTermsException;
import it.unimi.dsi.mg4j.index.payload.Payload;
import it.unimi.dsi.mg4j.query.nodes.AbstractQueryBuilderVisitor;
import it.unimi.dsi.mg4j.query.nodes.Align;
import it.unimi.dsi.mg4j.query.nodes.And;
import it.unimi.dsi.mg4j.query.nodes.Consecutive;
import it.unimi.dsi.mg4j.query.nodes.Difference;
import it.unimi.dsi.mg4j.query.nodes.False;
import it.unimi.dsi.mg4j.query.nodes.LowPass;
import it.unimi.dsi.mg4j.query.nodes.MultiTerm;
import it.unimi.dsi.mg4j.query.nodes.Not;
import it.unimi.dsi.mg4j.query.nodes.Or;
import it.unimi.dsi.mg4j.query.nodes.OrderedAnd;
import it.unimi.dsi.mg4j.query.nodes.Prefix;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.nodes.Range;
import it.unimi.dsi.mg4j.query.nodes.Remap;
import it.unimi.dsi.mg4j.query.nodes.Select;
import it.unimi.dsi.mg4j.query.nodes.Term;
import it.unimi.dsi.mg4j.query.nodes.True;
import it.unimi.dsi.mg4j.query.nodes.Weight;
import it.unimi.dsi.mg4j.search.AlignDocumentIterator;
import it.unimi.dsi.mg4j.search.AndDocumentIterator;
import it.unimi.dsi.mg4j.search.ConsecutiveDocumentIterator;
import it.unimi.dsi.mg4j.search.DifferenceDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.FalseDocumentIterator;
import it.unimi.dsi.mg4j.search.LowPassDocumentIterator;
import it.unimi.dsi.mg4j.search.NotDocumentIterator;
import it.unimi.dsi.mg4j.search.OrDocumentIterator;
import it.unimi.dsi.mg4j.search.OrderedAndDocumentIterator;
import it.unimi.dsi.mg4j.search.PayloadPredicateDocumentIterator;
import it.unimi.dsi.mg4j.search.RemappingDocumentIterator;
import it.unimi.dsi.mg4j.search.TrueDocumentIterator;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.NoSuchElementException;

public class DocumentIteratorBuilderVisitor
extends AbstractQueryBuilderVisitor<DocumentIterator> {
    protected final Object2ReferenceMap<String, Index> indexMap;
    protected final Reference2ReferenceMap<Index, Object> index2Parser;
    protected final Index defaultIndex;
    protected final int numberOfDocuments;
    protected final int limit;
    protected ObjectArrayList<Index> curr;
    protected DoubleArrayList weights;
    protected double weight;

    public DocumentIteratorBuilderVisitor(Object2ReferenceMap<String, Index> indexMap, Index defaultIndex, int limit) {
        this(indexMap, (Reference2ReferenceMap<Index, Object>)Reference2ReferenceMaps.EMPTY_MAP, defaultIndex, limit);
    }

    public DocumentIteratorBuilderVisitor(Object2ReferenceMap<String, Index> indexMap, Reference2ReferenceMap<Index, Object> index2Parser, Index defaultIndex, int limit) {
        this.indexMap = indexMap;
        this.defaultIndex = defaultIndex;
        this.index2Parser = index2Parser;
        this.limit = limit;
        this.weights = new DoubleArrayList();
        this.weight = Double.NaN;
        this.curr = new ObjectArrayList();
        this.curr.push((Object)defaultIndex);
        this.numberOfDocuments = defaultIndex.numberOfDocuments;
    }

    protected void pushWeight() {
        this.weights.push(Double.isNaN(this.weight) ? 1.0 : this.weight);
        this.weight = Double.NaN;
    }

    protected double weight() {
        double result = Double.isNaN(this.weight) ? 1.0 : this.weight;
        this.weight = Double.NaN;
        return result;
    }

    public DocumentIteratorBuilderVisitor copy() {
        return new DocumentIteratorBuilderVisitor(this.indexMap, this.defaultIndex, this.limit);
    }

    public DocumentIteratorBuilderVisitor prepare() {
        this.curr.size(1);
        this.weights.size(0);
        this.weight = Double.NaN;
        return this;
    }

    public DocumentIterator[] newArray(int len) {
        return new DocumentIterator[len];
    }

    @Override
    public DocumentIterator visit(Term node) throws QueryBuilderVisitorException {
        try {
            if (node.termNumber != -1) {
                return ((Index)this.curr.top()).documents(node.termNumber).weight(this.weight());
            }
            return ((Index)this.curr.top()).documents(node.term).weight(this.weight());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public DocumentIterator visit(Prefix node) throws QueryBuilderVisitorException {
        try {
            return ((Index)this.curr.top()).documents(node.prefix, this.limit).weight(this.weight());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
        catch (TooManyTermsException e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public DocumentIterator visit(Range node) throws QueryBuilderVisitorException {
        Index index = (Index)this.curr.top();
        if (!index.hasPayloads) {
            throw new IllegalStateException("Index " + index + " does not have payloads");
        }
        try {
            Payload parser = this.index2Parser.containsKey((Object)index) ? this.index2Parser.get((Object)index) : index.payload;
            Method method = parser.getClass().getMethod("parse", String.class);
            Payload left = index.payload.copy();
            Payload right = index.payload.copy();
            if (node.left != null) {
                left.set(method.invoke((Object)parser, ((Object)node.left).toString()));
            }
            if (node.right != null) {
                right.set(method.invoke((Object)parser, ((Object)node.right).toString()));
            }
            return PayloadPredicateDocumentIterator.getInstance(index.documents(0), index.payload.rangeFilter(node.left == null ? null : left, node.right == null ? null : right)).weight(this.weight());
        }
        catch (InvocationTargetException e) {
            throw new QueryBuilderVisitorException(e.getCause());
        }
        catch (Exception e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public boolean visitPre(And node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    public DocumentIterator visitPost(And node, DocumentIterator[] subNode) throws QueryBuilderVisitorException {
        try {
            return AndDocumentIterator.getInstance((Index)this.curr.top(), subNode).weight(this.weights.popDouble());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public boolean visitPre(Consecutive node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    public DocumentIterator visitPost(Consecutive node, DocumentIterator[] subNode) throws QueryBuilderVisitorException {
        try {
            return ConsecutiveDocumentIterator.getInstance(subNode, node.gap).weight(this.weights.popDouble());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public boolean visitPre(LowPass node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    @Override
    public DocumentIterator visitPost(LowPass node, DocumentIterator subNode) {
        return LowPassDocumentIterator.getInstance(subNode, node.k).weight(this.weights.popDouble());
    }

    @Override
    public boolean visitPre(Not node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    @Override
    public DocumentIterator visitPost(Not node, DocumentIterator subNode) throws QueryBuilderVisitorException {
        try {
            return NotDocumentIterator.getInstance(subNode, this.numberOfDocuments).weight(this.weights.popDouble());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public boolean visitPre(Or node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    public DocumentIterator visitPost(Or node, DocumentIterator[] subNode) throws QueryBuilderVisitorException {
        try {
            return OrDocumentIterator.getInstance((Index)this.curr.top(), subNode).weight(this.weights.popDouble());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public boolean visitPre(OrderedAnd node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    public DocumentIterator visitPost(OrderedAnd node, DocumentIterator[] subNode) throws QueryBuilderVisitorException {
        try {
            return OrderedAndDocumentIterator.getInstance((Index)this.curr.top(), subNode).weight(this.weights.popDouble());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
    }

    @Override
    public boolean visitPre(Align node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    public DocumentIterator visitPost(Align node, DocumentIterator[] subNode) throws QueryBuilderVisitorException {
        return AlignDocumentIterator.getInstance(subNode[0], subNode[1]).weight(this.weights.popDouble());
    }

    @Override
    public boolean visitPre(Difference node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    public DocumentIterator visitPost(Difference node, DocumentIterator[] subNode) {
        return DifferenceDocumentIterator.getInstance(subNode[0], subNode[1], node.leftMargin, node.rightMargin).weight(this.weights.popDouble());
    }

    @Override
    public boolean visitPre(MultiTerm node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    public DocumentIterator visitPost(MultiTerm node, DocumentIterator[] subNode) throws QueryBuilderVisitorException {
        IndexIterator result;
        IndexIterator[] indexIterator = new IndexIterator[subNode.length];
        System.arraycopy(subNode, 0, indexIterator, 0, indexIterator.length);
        try {
            result = MultiTermIndexIterator.getInstance((Index)this.curr.top(), indexIterator).weight(this.weights.popDouble());
        }
        catch (IOException e) {
            throw new QueryBuilderVisitorException(e);
        }
        result.term(node.toString());
        return result;
    }

    @Override
    public boolean visitPre(Select node) throws QueryBuilderVisitorException {
        if (this.indexMap == null) {
            throw new IllegalArgumentException("You cannot use Select nodes without an index map");
        }
        Index index = (Index)this.indexMap.get((Object)((Object)node.index).toString());
        if (index == null) {
            throw new NoSuchElementException("The selected index (" + node.index + ")" + " does not appear in the index map (" + this.indexMap + ")");
        }
        this.curr.push(this.indexMap.get((Object)((Object)node.index).toString()));
        return true;
    }

    @Override
    public DocumentIterator visitPost(Select node, DocumentIterator subNode) {
        this.curr.pop();
        return subNode;
    }

    @Override
    public boolean visitPre(Remap node) throws QueryBuilderVisitorException {
        this.pushWeight();
        return true;
    }

    @Override
    public DocumentIterator visitPost(Remap node, DocumentIterator subNode) {
        if (this.indexMap == null) {
            throw new IllegalArgumentException("You cannot use Remap nodes without an index map");
        }
        Reference2ReferenceArrayMap indexInverseRemapping = new Reference2ReferenceArrayMap(node.indexInverseRemapping.size());
        for (Map.Entry e : node.indexInverseRemapping.entrySet()) {
            Index externalIndex = (Index)this.indexMap.get(e.getKey());
            Index internalIndex = (Index)this.indexMap.get(e.getValue());
            if (internalIndex == null) {
                throw new NoSuchElementException("The internal index \"" + (String)e.getValue() + "\" does not appear in the index map (" + this.indexMap + ")");
            }
            if (externalIndex == null) {
                throw new NoSuchElementException("The external index \"" + (String)e.getKey() + "\" does not appear in the index map (" + this.indexMap + ")");
            }
            indexInverseRemapping.put((Object)externalIndex, (Object)internalIndex);
        }
        return new RemappingDocumentIterator(subNode, (Reference2ReferenceMap<? extends Index, ? extends Index>)indexInverseRemapping);
    }

    @Override
    public boolean visitPre(Weight node) throws QueryBuilderVisitorException {
        this.weight = node.weight;
        return true;
    }

    @Override
    public DocumentIterator visitPost(Weight node, DocumentIterator subNode) {
        return subNode;
    }

    @Override
    public DocumentIterator visit(True node) throws QueryBuilderVisitorException {
        return TrueDocumentIterator.getInstance((Index)this.curr.top());
    }

    @Override
    public DocumentIterator visit(False node) throws QueryBuilderVisitorException {
        return FalseDocumentIterator.getInstance((Index)this.curr.top());
    }
}

