/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;

public class NotDocumentIterator
extends AbstractDocumentIterator {
    private static final boolean DEBUG = false;
    private static final boolean ASSERTS = false;
    private final DocumentIterator documentIterator;
    private final Index soleIndex;
    private final int numberOfDocuments;
    private final Reference2ReferenceMap<Index, IntervalIterator> intervalIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableIntervalIterators;
    private int nextToSkip;
    private int nextCandidate;

    protected NotDocumentIterator(DocumentIterator documentIterator, int numberOfDocuments) throws IOException {
        int n;
        this.documentIterator = documentIterator;
        this.numberOfDocuments = numberOfDocuments;
        this.nextToSkip = documentIterator.nextDocument();
        if (this.nextToSkip == -1) {
            this.nextToSkip = numberOfDocuments;
        }
        this.soleIndex = (n = documentIterator.indices().size()) == 1 ? (Index)this.indices().iterator().next() : null;
        this.intervalIterators = new Reference2ReferenceArrayMap(n);
        for (Index i : this.indices()) {
            this.intervalIterators.put((Object)i, (Object)IntervalIterators.TRUE);
        }
        this.intervalIterators.defaultReturnValue((Object)IntervalIterators.FALSE);
        this.unmodifiableIntervalIterators = Reference2ReferenceMaps.unmodifiable(this.intervalIterators);
    }

    public static NotDocumentIterator getInstance(DocumentIterator it, int numberOfDocuments) throws IOException {
        return new NotDocumentIterator(it, numberOfDocuments);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.documentIterator.indices();
    }

    @Override
    public int skipTo(int n) throws IOException {
        this.ahead = false;
        if (this.curr >= n) {
            return this.curr;
        }
        this.nextCandidate = n;
        this.nextToSkip = this.documentIterator.skipTo(n);
        if (this.nextToSkip == Integer.MAX_VALUE) {
            this.nextToSkip = this.numberOfDocuments;
        }
        this.nextDocumentInternal();
        return this.curr;
    }

    @Override
    protected int nextDocumentInternal() throws IOException {
        while (true) {
            if (this.nextCandidate >= this.numberOfDocuments) {
                this.curr = Integer.MAX_VALUE;
                return -1;
            }
            if (this.nextCandidate < this.nextToSkip) {
                this.curr = this.nextCandidate++;
                return this.curr;
            }
            ++this.nextCandidate;
            this.nextToSkip = this.documentIterator.nextDocument();
            if (this.nextToSkip != -1) continue;
            this.nextToSkip = this.numberOfDocuments;
        }
    }

    @Override
    public void dispose() throws IOException {
        this.documentIterator.dispose();
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) throws IOException {
        if (!visitor.visitPre(this)) {
            return null;
        }
        T[] a = visitor.newArray(1);
        if (a == null ? this.documentIterator.accept(visitor) == null : (a[0] = this.documentIterator.accept(visitor)) == null) {
            return null;
        }
        return visitor.visitPost(this, a);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) {
        if (!visitor.visitPre(this)) {
            return null;
        }
        return visitor.visitPost(this, null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.documentIterator + ")";
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
        return this.unmodifiableIntervalIterators;
    }

    @Override
    public IntervalIterator intervalIterator() {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return IntervalIterators.TRUE;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) {
        return (IntervalIterator)this.intervalIterators.get((Object)index);
    }
}

