/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;
import java.io.IOException;
import java.util.Map;

public class RemappingDocumentIterator
extends AbstractIntIterator
implements DocumentIterator {
    private final DocumentIterator documentIterator;
    private final Index soleIndex;
    private final ReferenceSet<Index> indices;
    private final Reference2ReferenceMap<? extends Index, ? extends Index> indexInverseRemapping;
    private final Reference2ReferenceArrayMap<Index, IntervalIterator> currentIterators;
    private final Reference2ReferenceMap<Index, IntervalIterator> unmodifiableCurrentIterators;

    public RemappingDocumentIterator(DocumentIterator documentIterator, Reference2ReferenceMap<? extends Index, ? extends Index> indexInverseRemapping) {
        this.documentIterator = documentIterator;
        this.indexInverseRemapping = indexInverseRemapping;
        int n = documentIterator.indices().size();
        this.currentIterators = new Reference2ReferenceArrayMap((Object[])new Index[n], (Object[])new IntervalIterator[n]);
        this.unmodifiableCurrentIterators = Reference2ReferenceMaps.unmodifiable(this.currentIterators);
        this.indices = new ReferenceArraySet(documentIterator.indices().size());
        ReferenceArraySet nonIndices = new ReferenceArraySet();
        for (Map.Entry e : indexInverseRemapping.entrySet()) {
            if (documentIterator.indices().contains(e.getKey())) {
                throw new IllegalArgumentException("You cannot remap index " + e.getValue() + " to index " + e.getKey() + " as the latter already belongs to the document iterator");
            }
            if (!documentIterator.indices().contains(e.getValue())) {
                throw new IllegalArgumentException("You cannot remap index " + e.getValue() + " to index " + e.getKey() + " as the former does not belong to the document iterator");
            }
            nonIndices.add(e.getValue());
            this.indices.add(e.getKey());
        }
        for (Index index : documentIterator.indices()) {
            if (nonIndices.contains((Object)index)) continue;
            this.indices.add((Object)index);
        }
        this.soleIndex = n == 1 ? (Index)this.indices.iterator().next() : null;
    }

    @Override
    public int document() {
        return this.documentIterator.document();
    }

    public boolean hasNext() {
        return this.documentIterator.hasNext();
    }

    private Index remapIndex(Index index) {
        Index result = (Index)this.indexInverseRemapping.get((Object)index);
        return result == null ? index : result;
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.indices;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) throws IOException {
        if (!this.indices.contains((Object)index)) {
            return IntervalIterators.FALSE;
        }
        Index remappedIndex = this.remapIndex(index);
        IntervalIterator intervalIterator = (IntervalIterator)this.currentIterators.get((Object)index);
        if (intervalIterator == null) {
            intervalIterator = this.documentIterator.intervalIterator(remappedIndex);
            this.currentIterators.put((Object)index, (Object)intervalIterator);
        }
        return intervalIterator;
    }

    @Override
    public IntervalIterator intervalIterator() throws IOException {
        if (this.soleIndex == null) {
            throw new IllegalStateException();
        }
        return this.intervalIterator(this.soleIndex);
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() throws IOException {
        for (Index i : this.indices) {
            this.intervalIterator(i);
        }
        return this.unmodifiableCurrentIterators;
    }

    @Override
    public int nextDocument() throws IOException {
        this.currentIterators.clear();
        return this.documentIterator.nextDocument();
    }

    @Override
    public int nextInt() {
        this.currentIterators.clear();
        return this.nextInt();
    }

    @Override
    public int skipTo(int n) throws IOException {
        this.currentIterators.clear();
        return this.documentIterator.skipTo(n);
    }

    @Override
    public void dispose() throws IOException {
        this.documentIterator.dispose();
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) throws IOException {
        return this.documentIterator.accept(visitor);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) throws IOException {
        return this.documentIterator.acceptOnTruePaths(visitor);
    }

    @Override
    public IntervalIterator iterator() {
        try {
            return this.intervalIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public double weight() {
        return this.documentIterator.weight();
    }

    @Override
    public DocumentIterator weight(double weight) {
        return this.documentIterator.weight(weight);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.documentIterator + ", " + this.indexInverseRemapping + ")";
    }
}

