/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.AbstractDocumentIterator;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.visitor.DocumentIteratorVisitor;

public class TrueDocumentIterator
extends AbstractDocumentIterator {
    private final ReferenceSet<Index> indices;
    private final Index soleIndex;

    protected TrueDocumentIterator(Index index) {
        this.soleIndex = index;
        this.indices = ReferenceSets.singleton((Object)this.soleIndex);
    }

    public static TrueDocumentIterator getInstance(Index index) {
        return new TrueDocumentIterator(index);
    }

    @Override
    public IntervalIterator intervalIterator() {
        return IntervalIterators.TRUE;
    }

    @Override
    public IntervalIterator intervalIterator(Index index) {
        return index == this.soleIndex ? IntervalIterators.TRUE : IntervalIterators.FALSE;
    }

    @Override
    public Reference2ReferenceMap<Index, IntervalIterator> intervalIterators() {
        return Reference2ReferenceMaps.singleton((Object)this.soleIndex, (Object)IntervalIterators.TRUE);
    }

    @Override
    public ReferenceSet<Index> indices() {
        return this.indices;
    }

    @Override
    protected int nextDocumentInternal() {
        if (this.curr < this.soleIndex.numberOfDocuments - 1) {
            return ++this.curr;
        }
        this.curr = Integer.MAX_VALUE;
        return -1;
    }

    @Override
    public int skipTo(int n) {
        this.ahead = false;
        if (n <= this.curr) {
            return this.curr;
        }
        this.curr = n >= this.soleIndex.numberOfDocuments ? Integer.MAX_VALUE : n;
        return this.curr;
    }

    @Override
    public <T> T accept(DocumentIteratorVisitor<T> visitor) {
        if (!visitor.visitPre(this)) {
            return null;
        }
        return visitor.visitPost(this, null);
    }

    @Override
    public <T> T acceptOnTruePaths(DocumentIteratorVisitor<T> visitor) {
        if (!visitor.visitPre(this)) {
            return null;
        }
        return visitor.visitPost(this, null);
    }

    @Override
    public void dispose() {
    }
}

