/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractScorer;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class AbstractWeightedScorer
extends AbstractScorer {
    private static final Logger LOGGER = Logger.getLogger(AbstractWeightedScorer.class);
    protected Reference2DoubleOpenHashMap<Index> index2Weight = new Reference2DoubleOpenHashMap(1, 0.25f);
    private Index[] index;
    private double[] indexNumber2Weight;

    public AbstractWeightedScorer() {
        this.index2Weight.defaultReturnValue(1.0);
    }

    @Override
    public synchronized boolean setWeights(Reference2DoubleMap<Index> index2Weight) {
        this.index2Weight.clear();
        this.index2Weight.defaultReturnValue(0.0);
        double weightSum = 0.0;
        DoubleIterator i = index2Weight.values().iterator();
        while (i.hasNext()) {
            weightSum += i.nextDouble();
        }
        if (weightSum == 0.0) {
            weightSum = 1.0;
        }
        for (Reference2DoubleMap.Entry e : index2Weight.entrySet()) {
            this.index2Weight.put(e.getKey(), e.getDoubleValue() / weightSum);
        }
        this.index2Weight.trim();
        LOGGER.debug((Object)("New weight map for " + this + ": " + this.index2Weight));
        return true;
    }

    @Override
    public final synchronized Reference2DoubleMap<Index> getWeights() {
        return new Reference2DoubleOpenHashMap(this.index2Weight, 0.25f);
    }

    @Override
    public double score() throws IOException {
        double[] indexNumber2Weight = this.indexNumber2Weight;
        Index[] index = this.index;
        double result = 0.0;
        int i = index.length;
        while (i-- != 0) {
            result += indexNumber2Weight[i] * this.score(index[i]);
        }
        return result;
    }

    @Override
    public void wrap(DocumentIterator documentIterator) throws IOException {
        super.wrap(documentIterator);
        this.index = (Index[])documentIterator.indices().toArray((Object[])new Index[documentIterator.indices().size()]);
        this.indexNumber2Weight = new double[this.index.length];
        int i = this.index.length;
        while (i-- != 0) {
            this.indexNumber2Weight[i] = this.index2Weight.getDouble((Object)this.index[i]);
        }
    }
}

