/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.mg4j.search.visitor.CounterCollectionVisitor;
import it.unimi.dsi.mg4j.search.visitor.CounterSetupVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import it.unimi.dsi.util.SemiExternalGammaList;
import it.unimi.dsi.util.StringMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class BM25FScorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    private static final Logger LOGGER = Logger.getLogger(BM25FScorer.class);
    private static final boolean DEBUG = false;
    public static final double DEFAULT_K1 = 1.2;
    public static final double DEFAULT_B = 0.5;
    public static final double EPSILON_SCORE = 1.0E-6;
    private final CounterCollectionVisitor counterCollectionVisitor;
    private final CounterSetupVisitor setupVisitor;
    private final TermCollectionVisitor termVisitor;
    public final double k1;
    public final Reference2DoubleMap<Index> bByIndex;
    private final double k1Plus1;
    private double[] avgDocumentSize;
    private IntList[] sizes;
    private double[] idfPart;
    private double[] offset2Weight;
    private int[] offset2TermId;
    private final StringMap<? extends CharSequence> termMap;
    private final LongList frequencies;
    private int[] offset2Index;
    private double[] virtualCount;
    private double[] virtualIdfCount;
    private int[] size;
    private double[] weight;
    private double[] index2B;
    private Object2DoubleMap<String> bByName;

    public BM25FScorer(double k1, Reference2DoubleMap<Index> b, StringMap<? extends CharSequence> termMap, LongList frequencies) {
        this.termMap = termMap;
        this.termVisitor = new TermCollectionVisitor();
        this.setupVisitor = new CounterSetupVisitor(this.termVisitor);
        this.counterCollectionVisitor = new CounterCollectionVisitor(this.setupVisitor);
        this.k1 = k1;
        this.bByIndex = b;
        this.frequencies = frequencies;
        this.k1Plus1 = k1 + 1.0;
        this.bByName = null;
    }

    public BM25FScorer(double k1, StringMap<? extends CharSequence> termMap, LongList frequencies, Object2DoubleMap<String> b) {
        this.termMap = termMap;
        this.termVisitor = new TermCollectionVisitor();
        this.setupVisitor = new CounterSetupVisitor(this.termVisitor);
        this.counterCollectionVisitor = new CounterCollectionVisitor(this.setupVisitor);
        this.k1 = k1;
        this.bByName = b;
        this.frequencies = frequencies;
        this.k1Plus1 = k1 + 1.0;
        this.bByIndex = null;
    }

    public BM25FScorer(double k1, Reference2DoubleMap<Index> b) {
        this(k1, b, null, null);
    }

    private static Object2DoubleMap<String> parseBArray(String[] b) {
        Object2DoubleOpenHashMap result = new Object2DoubleOpenHashMap();
        for (int i = 3; i < b.length; ++i) {
            String[] part = b[i].split("=");
            result.put((Object)part[0], Double.parseDouble(part[1]));
        }
        return result;
    }

    public BM25FScorer(String ... arg) throws NumberFormatException, FileNotFoundException, IOException, ClassNotFoundException {
        this(Double.parseDouble(arg[0]), (StringMap<? extends CharSequence>)(arg[1].length() == 0 ? null : (StringMap)BinIO.loadObject((CharSequence)arg[1])), (LongList)(arg[2].length() == 0 ? null : new SemiExternalGammaList(new InputBitStream(arg[2]))), BM25FScorer.parseBArray(arg));
    }

    @Override
    public synchronized BM25FScorer copy() {
        BM25FScorer scorer = new BM25FScorer(this.k1, this.bByIndex, this.termMap, this.frequencies);
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    @Override
    public double score() throws IOException {
        int term2Index;
        this.setupVisitor.clear();
        this.documentIterator.acceptOnTruePaths(this.counterCollectionVisitor);
        int document = this.documentIterator.document();
        int[] count = this.setupVisitor.count;
        double[] offset2Weight = this.offset2Weight;
        int[] offset2TermId = this.offset2TermId;
        double[] idfPart = this.idfPart;
        double[] virtualCount = this.virtualCount;
        double[] virtualIdfCount = this.virtualIdfCount;
        double[] index2B = this.index2B;
        int[] size = this.size;
        int i = size.length;
        while (i-- != 0) {
            size[i] = this.sizes[i].getInt(document);
        }
        DoubleArrays.fill((double[])virtualCount, (double)0.0);
        double score = 0.0;
        if (this.termMap != null) {
            int i2 = offset2TermId.length;
            while (i2-- != 0) {
                term2Index = this.offset2Index[i2];
                int n = offset2TermId[i2];
                virtualCount[n] = virtualCount[n] + (double)count[i2] * offset2Weight[i2] / (1.0 - index2B[term2Index] + index2B[term2Index] * (double)size[term2Index] / this.avgDocumentSize[term2Index]);
            }
            i2 = virtualCount.length;
            while (i2-- != 0) {
                double v = virtualCount[i2];
                score += this.k1Plus1 * v / (v + this.k1) * idfPart[i2];
            }
        } else {
            DoubleArrays.fill((double[])virtualIdfCount, (double)0.0);
            int i3 = offset2TermId.length;
            while (i3-- != 0) {
                term2Index = this.offset2Index[i3];
                int termId = offset2TermId[i3];
                double v = (double)count[i3] * offset2Weight[i3] / (1.0 - index2B[term2Index] + index2B[term2Index] * (double)size[term2Index] / this.avgDocumentSize[term2Index]);
                int n = termId;
                virtualCount[n] = virtualCount[n] + v;
                int n2 = termId;
                virtualIdfCount[n2] = virtualIdfCount[n2] + idfPart[i3] * v;
            }
            i3 = virtualCount.length;
            while (i3-- != 0) {
                score += this.k1Plus1 * virtualIdfCount[i3] / (virtualCount[i3] + this.k1);
            }
        }
        return score;
    }

    @Override
    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DocumentIterator d) throws IOException {
        super.wrap(d);
        this.documentIterator = d;
        this.termVisitor.prepare((ReferenceSet<Index>)this.index2Weight.keySet());
        d.accept(this.termVisitor);
        Index[] index = this.termVisitor.indices();
        if (!this.index2Weight.keySet().containsAll(Arrays.asList(index))) {
            throw new IllegalArgumentException("A BM25F scorer must have a weight for all indices involved in a query");
        }
        for (Index i : index) {
            if ((this.bByIndex == null || this.bByIndex.containsKey((Object)i)) && (this.bByName == null || this.bByName.containsKey((Object)i.field))) continue;
            throw new IllegalArgumentException("A BM25F scorer must have a b parameter for all indices involved in a query");
        }
        this.sizes = new IntList[index.length];
        int i = index.length;
        while (i-- != 0) {
            this.sizes[i] = index[i].sizes;
            if (this.sizes[i] != null) continue;
            throw new IllegalStateException("A BM25F scorer requires document sizes");
        }
        this.setupVisitor.prepare();
        d.accept(this.setupVisitor);
        this.avgDocumentSize = new double[index.length];
        this.weight = new double[index.length];
        i = this.weight.length;
        while (i-- != 0) {
            this.weight[i] = this.index2Weight.getDouble((Object)index[i]);
            this.avgDocumentSize[i] = (double)index[i].numberOfOccurrences / (double)index[i].numberOfDocuments;
        }
        this.offset2TermId = this.setupVisitor.offset2TermId;
        this.offset2Index = this.setupVisitor.indexNumber;
        this.offset2Weight = new double[this.offset2Index.length];
        this.index2B = new double[index.length];
        for (i = 0; i < this.index2B.length; ++i) {
            this.index2B[i] = this.bByIndex != null ? this.bByIndex.getDouble((Object)index[i]) : this.bByName.getDouble((Object)index[i].field);
        }
        i = this.offset2Weight.length;
        while (i-- != 0) {
            this.offset2Weight[i] = this.index2Weight.getDouble((Object)index[this.offset2Index[i]]);
        }
        this.idfPart = new double[this.termVisitor.numberOfPairs()];
        if (this.termMap != null) {
            i = this.idfPart.length;
            while (i-- != 0) {
                int id = (int)this.termMap.getLong((Object)this.setupVisitor.termId2Term[this.setupVisitor.offset2TermId[i]]);
                if (id == -1) {
                    throw new IllegalStateException("The term map passed to a BM25F scorer must contain all terms appearing in all indices");
                }
                long f = this.frequencies.getLong(id);
                this.idfPart[i] = Math.max(1.0E-6, Math.log(((double)((long)index[0].numberOfDocuments - f) + 0.5) / ((double)f + 0.5)));
            }
        } else {
            int[] frequency = this.setupVisitor.frequency;
            int[] indexNumber = this.setupVisitor.indexNumber;
            int i2 = this.idfPart.length;
            while (i2-- != 0) {
                this.idfPart[i2] = Math.max(1.0E-6, Math.log(((double)(index[indexNumber[i2]].numberOfDocuments - frequency[i2]) + 0.5) / ((double)frequency[i2] + 0.5)));
            }
        }
        this.size = new int[index.length];
        this.virtualCount = new double[this.setupVisitor.termId2Term.length];
        if (this.termMap == null) {
            this.virtualIdfCount = new double[this.setupVisitor.termId2Term.length];
        }
    }

    @Override
    public boolean usesIntervals() {
        return false;
    }
}

