/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.mg4j.search.visitor.CounterCollectionVisitor;
import it.unimi.dsi.mg4j.search.visitor.CounterSetupVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class BM25Scorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    private static final Logger LOGGER = Logger.getLogger(BM25Scorer.class);
    private static final boolean DEBUG = true;
    public static final double DEFAULT_K1 = 1.2;
    public static final double DEFAULT_B = 0.5;
    public static final double EPSILON_SCORE = 1.0E-6;
    private final CounterCollectionVisitor counterCollectionVisitor;
    private final CounterSetupVisitor setupVisitor;
    private final TermCollectionVisitor termVisitor = new TermCollectionVisitor();
    public final double k1;
    public final double b;
    private final double k1Plus1;
    private double[] averageDocumentSize;
    private IntList[] sizes;
    private int[] size;
    private double[] weightedIdfPart;

    public BM25Scorer() {
        this(1.2, 0.5);
    }

    public BM25Scorer(double k1, double b) {
        this.setupVisitor = new CounterSetupVisitor(this.termVisitor);
        this.counterCollectionVisitor = new CounterCollectionVisitor(this.setupVisitor);
        this.k1 = k1;
        this.b = b;
        this.k1Plus1 = k1 + 1.0;
    }

    public BM25Scorer(String k1, String b) {
        this(Double.parseDouble(k1), Double.parseDouble(b));
    }

    @Override
    public synchronized BM25Scorer copy() {
        BM25Scorer scorer = new BM25Scorer(this.k1, this.b);
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    @Override
    public double score() throws IOException {
        this.setupVisitor.clear();
        this.documentIterator.acceptOnTruePaths(this.counterCollectionVisitor);
        int document = this.documentIterator.document();
        int[] count = this.setupVisitor.count;
        int[] indexNumber = this.setupVisitor.indexNumber;
        double[] weightedIdfPart = this.weightedIdfPart;
        double[] averageDocumentSize = this.averageDocumentSize;
        int[] size = this.size;
        int i = size.length;
        while (i-- != 0) {
            size[i] = this.sizes[i].getInt(document);
        }
        double score = 0.0;
        int i2 = count.length;
        while (i2-- != 0) {
            int k = indexNumber[i2];
            score += this.k1Plus1 * (double)count[i2] / ((double)count[i2] + this.k1 * (1.0 - this.b + this.b * (double)size[k] / averageDocumentSize[k])) * weightedIdfPart[i2];
        }
        return score;
    }

    @Override
    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DocumentIterator d) throws IOException {
        super.wrap(d);
        this.termVisitor.prepare((ReferenceSet<Index>)this.index2Weight.keySet());
        d.accept(this.termVisitor);
        LOGGER.debug((Object)("Term Visitor found " + this.termVisitor.numberOfPairs() + " leaves"));
        Object[] index = this.termVisitor.indices();
        LOGGER.debug((Object)("Indices: " + Arrays.toString(index)));
        this.sizes = new IntList[index.length];
        int i = index.length;
        while (i-- != 0) {
            this.sizes[i] = ((Index)index[i]).sizes;
            if (this.sizes[i] != null) continue;
            throw new IllegalStateException("A BM25 scorer requires document sizes");
        }
        this.averageDocumentSize = new double[index.length];
        i = index.length;
        while (i-- != 0) {
            this.averageDocumentSize[i] = (double)((Index)index[i]).numberOfOccurrences / (double)((Index)index[i]).numberOfDocuments;
        }
        LOGGER.debug((Object)("Average document sizes: " + Arrays.toString(this.averageDocumentSize)));
        this.setupVisitor.prepare();
        d.accept(this.setupVisitor);
        int[] frequency = this.setupVisitor.frequency;
        int[] indexNumber = this.setupVisitor.indexNumber;
        this.weightedIdfPart = new double[frequency.length];
        int i2 = this.weightedIdfPart.length;
        while (i2-- != 0) {
            this.weightedIdfPart[i2] = Math.max(1.0E-6, Math.log(((double)(((Index)index[indexNumber[i2]]).numberOfDocuments - frequency[i2]) + 0.5) / ((double)frequency[i2] + 0.5))) * this.index2Weight.getDouble(index[indexNumber[i2]]);
        }
        this.size = new int[index.length];
    }

    @Override
    public boolean usesIntervals() {
        return false;
    }
}

