/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.mg4j.search.visitor.CounterCollectionVisitor;
import it.unimi.dsi.mg4j.search.visitor.CounterSetupVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CountScorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    static Logger LOGGER = Logger.getLogger(CountScorer.class);
    private final CounterCollectionVisitor counterCollectionVisitor;
    private final CounterSetupVisitor counterSetupVisitor;
    private final TermCollectionVisitor termCollectionVisitor = new TermCollectionVisitor();
    protected double[] indexNumber2Weight;

    public CountScorer() {
        this.counterSetupVisitor = new CounterSetupVisitor(this.termCollectionVisitor);
        this.counterCollectionVisitor = new CounterCollectionVisitor(this.counterSetupVisitor);
    }

    @Override
    public double score() throws IOException {
        this.counterSetupVisitor.clear();
        this.documentIterator.acceptOnTruePaths(this.counterCollectionVisitor);
        double score = 0.0;
        int[] count = this.counterSetupVisitor.count;
        int[] indexNumber = this.counterSetupVisitor.indexNumber;
        int i = count.length;
        while (i-- != 0) {
            score += (double)count[i] * this.indexNumber2Weight[indexNumber[i]];
        }
        return score;
    }

    @Override
    public double score(Index index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DocumentIterator d) throws IOException {
        super.wrap(d);
        this.termCollectionVisitor.prepare((ReferenceSet<Index>)this.index2Weight.keySet());
        d.accept(this.termCollectionVisitor);
        Index[] index = this.termCollectionVisitor.indices();
        this.indexNumber2Weight = new double[index.length];
        int i = index.length;
        while (i-- != 0) {
            this.indexNumber2Weight[i] = this.index2Weight.getDouble((Object)index[i]);
        }
        this.counterSetupVisitor.prepare();
        d.accept(this.counterSetupVisitor);
    }

    @Override
    public synchronized CountScorer copy() {
        CountScorer scorer = new CountScorer();
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    @Override
    public boolean usesIntervals() {
        return false;
    }
}

