/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.score;

import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.mg4j.search.IntervalIterators;
import it.unimi.dsi.mg4j.search.score.AbstractWeightedScorer;
import it.unimi.dsi.mg4j.search.score.DelegatingScorer;
import it.unimi.dsi.util.Interval;
import java.io.IOException;

public class VignaScorer
extends AbstractWeightedScorer
implements DelegatingScorer {
    @Override
    public double score(Index index) throws IOException {
        Interval interval;
        IntervalIterator it = this.documentIterator.intervalIterator(index);
        if (it == IntervalIterators.TRUE || it == IntervalIterators.FALSE) {
            return 0.0;
        }
        double score = 0.0;
        double residual = 1.0;
        int extent = it.extent();
        while ((interval = it.nextInterval()) != null) {
            int length = interval.length();
            double t = residual * Math.min((double)extent / (double)length, 1.0) / 2.0;
            residual -= t;
            if (!((score += t) > 0.99)) continue;
            return 1.0;
        }
        return score;
    }

    public String toString() {
        return "Vigna()";
    }

    @Override
    public synchronized VignaScorer copy() {
        VignaScorer scorer = new VignaScorer();
        scorer.setWeights((Reference2DoubleMap<Index>)this.index2Weight);
        return scorer;
    }

    @Override
    public boolean usesIntervals() {
        return true;
    }
}

