/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.visitor;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.visitor.AbstractDocumentIteratorVisitor;
import it.unimi.dsi.mg4j.search.visitor.TermCollectionVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;

public class CounterSetupVisitor
extends AbstractDocumentIteratorVisitor {
    public int[] indexNumber;
    public String[] offset2Term;
    public int[] count;
    public int[] frequency;
    public int[] offset2TermId;
    public String[] termId2Term;
    private final TermCollectionVisitor termCollectionVisitor;

    public CounterSetupVisitor(TermCollectionVisitor termCollectionVisitor) {
        this.termCollectionVisitor = termCollectionVisitor;
        this.prepare();
    }

    @Override
    public CounterSetupVisitor prepare() {
        int numberOfPairs = this.termCollectionVisitor.numberOfPairs();
        this.count = new int[numberOfPairs];
        this.frequency = new int[numberOfPairs];
        this.indexNumber = new int[numberOfPairs];
        this.offset2Term = new String[numberOfPairs];
        this.offset2TermId = new int[numberOfPairs];
        this.termId2Term = new String[this.termCollectionVisitor.term2Id().size()];
        Iterator i$ = this.termCollectionVisitor.term2Id().keySet().iterator();
        while (i$.hasNext()) {
            String term;
            this.termId2Term[this.termCollectionVisitor.term2Id().getInt((Object)term)] = term = (String)i$.next();
        }
        return this;
    }

    @Override
    public Boolean visit(IndexIterator indexIterator) throws IOException {
        int id = indexIterator.id();
        if (id != -1) {
            this.frequency[id] = indexIterator.frequency();
            this.indexNumber[id] = this.termCollectionVisitor.indexMap().getInt((Object)indexIterator.index());
            this.offset2Term[id] = indexIterator.term();
            this.offset2TermId[id] = this.termCollectionVisitor.term2Id().getInt((Object)indexIterator.term());
        }
        return Boolean.TRUE;
    }

    public void update(IndexIterator indexIterator) throws IOException {
        this.count[indexIterator.id()] = indexIterator.count();
    }

    public void clear() {
        IntArrays.fill((int[])this.count, (int)0);
    }

    public String toString() {
        return "[" + Arrays.toString(this.frequency) + ", " + Arrays.toString(this.count) + "]";
    }
}

