/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.search.visitor;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.search.visitor.AbstractDocumentIteratorVisitor;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TermCollectionVisitor
extends AbstractDocumentIteratorVisitor {
    private static final Logger LOGGER = Logger.getLogger(TermCollectionVisitor.class);
    private static final boolean DEBUG = false;
    private final Reference2ObjectMap<Index, Object2IntMap<String>> index2termMap = new Reference2ObjectOpenHashMap();
    private final Reference2IntMap<Index> indexMap = new Reference2IntLinkedOpenHashMap(16, 0.5f);
    private final Object2IntLinkedOpenHashMap<String> term2Id = new Object2IntLinkedOpenHashMap();
    private int numberOfPairs;
    private Index[] index;
    private boolean rigid;

    public TermCollectionVisitor() {
        this.term2Id.defaultReturnValue(-1);
    }

    private void reset() {
        this.index = null;
        this.index2termMap.clear();
        this.indexMap.clear();
        this.term2Id.clear();
        this.numberOfPairs = 0;
    }

    @Override
    public TermCollectionVisitor prepare() {
        this.rigid = false;
        this.reset();
        return this;
    }

    public TermCollectionVisitor prepare(ReferenceSet<Index> indices) {
        if (indices.isEmpty()) {
            return this.prepare();
        }
        this.rigid = true;
        this.reset();
        int c = 0;
        for (Index i : indices) {
            this.indexMap.put((Object)i, c++);
            Object2IntLinkedOpenHashMap termMap = new Object2IntLinkedOpenHashMap(16, 0.5f);
            this.index2termMap.put((Object)i, (Object)termMap);
            termMap.defaultReturnValue(-1);
        }
        return this;
    }

    @Override
    public Boolean visit(IndexIterator indexIterator) throws IOException {
        if (indexIterator.frequency() > 0 && indexIterator.index().hasCounts && (!this.rigid || this.indexMap.containsKey((Object)indexIterator.index()))) {
            Object2IntMap termMap;
            Index index = indexIterator.index();
            String term = indexIterator.term();
            if (term == null) {
                throw new NullPointerException("This visitor needs a non-null term for each index iterator of nonzero frequency");
            }
            if (!this.term2Id.containsKey((Object)term)) {
                this.term2Id.put((Object)term, this.term2Id.size());
            }
            if (!this.indexMap.containsKey((Object)index)) {
                this.indexMap.put((Object)index, this.indexMap.size());
                termMap = new Object2IntLinkedOpenHashMap(16, 0.5f);
                this.index2termMap.put((Object)index, (Object)termMap);
                termMap.defaultReturnValue(-1);
            } else {
                termMap = (Object2IntMap)this.index2termMap.get((Object)index);
            }
            int offset = termMap.getInt((Object)term);
            if (offset == -1) {
                offset = this.numberOfPairs++;
                termMap.put((Object)term, offset);
            }
            indexIterator.id(offset);
        } else {
            indexIterator.id(-1);
        }
        return Boolean.TRUE;
    }

    public int numberOfPairs() {
        return this.numberOfPairs;
    }

    public Index[] indices() {
        if (this.index == null) {
            this.index = (Index[])this.indexMap.keySet().toArray((Object[])new Index[this.index2termMap.size()]);
        }
        return this.index;
    }

    public Reference2IntMap<Index> indexMap() {
        return this.indexMap;
    }

    public String[] terms(Index index) {
        Object2IntMap termMap = (Object2IntMap)this.index2termMap.get((Object)index);
        return termMap == null ? null : (String[])termMap.keySet().toArray((Object[])new String[termMap.size()]);
    }

    public Object2IntLinkedOpenHashMap<String> term2Id() {
        return this.term2Id;
    }

    public int offset(Index index, String term) {
        return ((Object2IntMap)this.index2termMap.get((Object)index)).getInt((Object)term);
    }

    public String toString() {
        return "[Leaves: " + this.numberOfPairs + "; " + this.index2termMap + "]";
    }
}

