/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectHeapSemiIndirectPriorityQueue;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.mg4j.index.BitStreamHPIndex;
import it.unimi.dsi.mg4j.index.BitStreamHPIndexWriter;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.BitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.SkipBitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.index.VariableQuantumIndexWriter;
import it.unimi.dsi.mg4j.index.cluster.IndexCluster;
import it.unimi.dsi.mg4j.tool.Concatenate;
import it.unimi.dsi.mg4j.tool.Merge;
import it.unimi.dsi.mg4j.tool.Paste;
import it.unimi.dsi.util.Properties;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.log4j.Logger;

public abstract class Combine {
    private static final Logger LOGGER = Util.getLogger(Combine.class);
    private static final boolean DEBUG = false;
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    protected final int numIndices;
    protected final BitStreamIndex[] index;
    protected final IndexReader[] indexReader;
    protected final IndexIterator[] indexIterator;
    protected final boolean metadataOnly;
    private final InputBitStream[] globCounts;
    private final InputBitStream[] offsets;
    private final InputBitStream[] posNumBits;
    private boolean writeGlobCounts;
    private boolean writeSizes;
    private MutableString[] term;
    private FastBufferedReader[] termReader;
    protected ObjectHeapSemiIndirectPriorityQueue<MutableString> termQueue;
    protected final int numberOfDocuments;
    protected long numberOfOccurrences;
    protected int maxCount;
    protected final String[] inputBasename;
    protected final String outputBasename;
    protected final int bufferSize;
    protected final double p;
    private final long logInterval;
    protected IndexWriter indexWriter;
    protected VariableQuantumIndexWriter variableQuantumIndexWriter;
    protected final boolean hasCounts;
    protected final boolean hasPositions;
    protected final boolean hasPayloads;
    protected final Properties additionalProperties;
    protected final int[] usedIndex;
    protected final int[] frequency;
    protected int[] position;
    protected final boolean needsSizes;
    protected int[] size;
    protected long predictedSize;
    protected long predictedLengthNumBits;

    public Combine(String outputBasename, String[] inputBasename, boolean metadataOnly, boolean requireSizes, int bufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this(outputBasename, inputBasename, null, metadataOnly, requireSizes, bufferSize, writerFlags, interleaved, skips, quantum, height, skipBufferSize, logInterval);
    }

    public Combine(String outputBasename, String[] inputBasename, IntList delete, boolean metadataOnly, boolean requireSizes, int bufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.logInterval = logInterval;
        LOGGER.debug((Object)("Combining indices " + Arrays.toString(inputBasename) + " into " + outputBasename));
        this.inputBasename = new String[inputBasename.length];
        for (int i = 0; i < inputBasename.length; ++i) {
            int questionMarkPos = inputBasename[i].indexOf(63);
            this.inputBasename[i] = questionMarkPos == -1 ? inputBasename[i] : inputBasename[i].substring(0, questionMarkPos);
        }
        this.outputBasename = outputBasename;
        this.metadataOnly = metadataOnly;
        this.bufferSize = bufferSize;
        this.needsSizes = writerFlags.get((Object)CompressionFlags.Component.POSITIONS) == CompressionFlags.Coding.GOLOMB;
        this.numIndices = inputBasename.length;
        this.index = new BitStreamIndex[this.numIndices];
        this.indexReader = new IndexReader[this.numIndices];
        this.indexIterator = new IndexIterator[this.numIndices];
        this.globCounts = new InputBitStream[this.numIndices];
        this.offsets = new InputBitStream[this.numIndices];
        this.posNumBits = new InputBitStream[this.numIndices];
        this.term = new MutableString[this.numIndices];
        this.termReader = new FastBufferedReader[this.numIndices];
        this.termQueue = new ObjectHeapSemiIndirectPriorityQueue((Object[])this.term, this.numIndices);
        boolean haveCounts = true;
        boolean havePositions = true;
        TermProcessor termProcessor = null;
        Object payload = null;
        String field = null;
        this.writeSizes = true;
        this.writeGlobCounts = true;
        boolean someGlobCounts = false;
        boolean someSizes = false;
        boolean allDataForSizeComputation = true;
        for (int i = 0; i < this.numIndices; ++i) {
            this.index[i] = (BitStreamIndex)Index.getInstance(inputBasename[i], false, requireSizes, false);
            if (i == 0) {
                termProcessor = this.index[0].termProcessor.copy();
                payload = this.index[0].payload == null ? null : this.index[0].payload.copy();
            } else {
                if (!termProcessor.equals(this.index[i].termProcessor)) {
                    throw new IllegalStateException("The term processor of the first index (" + termProcessor + ") is different from the term processor of index " + i + " (" + this.index[i].termProcessor + ")");
                }
                if (payload == null != (this.index[i].payload == null) || payload != null && !payload.compatibleWith(this.index[i].payload)) {
                    throw new IllegalStateException("The payload specification of index " + this.index[0] + " is not compatible with that of index " + this.index[i]);
                }
            }
            if (this.index[i].field != null) {
                if (field == null) {
                    if (i != 0) {
                        LOGGER.warn((Object)"Not all indices specify the field property");
                    }
                    field = this.index[i].field;
                } else if (!field.equals(this.index[i].field)) {
                    LOGGER.warn((Object)("Index fields disagree: \"" + field + "\", \"" + this.index[i].field + "\""));
                }
            }
            haveCounts &= this.index[i].hasCounts;
            havePositions &= this.index[i].hasPositions;
            this.maxCount = Math.max(this.maxCount, this.index[i].maxCount);
            this.indexReader[i] = this.index[i].getReader(bufferSize);
            if (this.index[i].properties.getLong((Enum)Index.PropertyKeys.OCCURRENCES, -1L) == -1L) {
                this.numberOfOccurrences = -1L;
            }
            if (this.numberOfOccurrences != -1L) {
                this.numberOfOccurrences += this.index[i].properties.getLong((Enum)Index.PropertyKeys.OCCURRENCES);
            }
            File globCountsFile = new File(this.inputBasename[i] + ".globcounts");
            this.writeGlobCounts &= globCountsFile.exists();
            someGlobCounts |= globCountsFile.exists();
            if (this.writeGlobCounts) {
                this.globCounts[i] = new InputBitStream(globCountsFile);
            }
            if (!metadataOnly) {
                File offsetsFile = new File(this.inputBasename[i] + ".offsets");
                if (quantum < 0 && (allDataForSizeComputation &= offsetsFile.exists())) {
                    this.offsets[i] = new InputBitStream(offsetsFile);
                }
                if (this.index[i].hasPositions) {
                    File positionsLengthsFile = new File(this.inputBasename[i] + ".posnumbits");
                    if (quantum < 0 && (allDataForSizeComputation &= positionsLengthsFile.exists())) {
                        this.posNumBits[i] = new InputBitStream(positionsLengthsFile);
                    }
                }
            }
            File sizesFile = new File(this.inputBasename[i] + ".sizes");
            this.writeSizes &= sizesFile.exists();
            someSizes |= sizesFile.exists();
            this.term[i] = new MutableString();
            this.termReader[i] = new FastBufferedReader((Reader)new InputStreamReader((InputStream)new FileInputStream(this.inputBasename[i] + ".terms"), "UTF-8"));
            if (this.termReader[i].readLine(this.term[i]) == null) continue;
            this.termQueue.enqueue(i);
        }
        if (this.writeGlobCounts != someGlobCounts) {
            LOGGER.warn((Object)"Some (but not all) global-counts file missing");
        }
        if (this.writeSizes != someSizes) {
            LOGGER.warn((Object)"Some (but not all) sizes file missing");
        }
        this.additionalProperties = new Properties();
        this.additionalProperties.setProperty((Enum)Index.PropertyKeys.TERMPROCESSOR, (Object)ObjectParser.toSpec(termProcessor));
        if (payload != null) {
            this.additionalProperties.setProperty((Enum)Index.PropertyKeys.PAYLOADCLASS, (Object)payload.getClass().getName());
        }
        this.additionalProperties.setProperty((Enum)Index.PropertyKeys.BATCHES, inputBasename.length);
        if (field != null) {
            this.additionalProperties.setProperty((Enum)Index.PropertyKeys.FIELD, field);
        }
        this.usedIndex = new int[this.numIndices];
        this.frequency = new int[this.numIndices];
        this.position = new int[this.maxCount];
        this.numberOfDocuments = this.combineNumberOfDocuments();
        this.hasCounts = writerFlags.containsKey((Object)CompressionFlags.Component.COUNTS);
        if (this.hasCounts && !haveCounts) {
            throw new IllegalArgumentException("Some of the indices to be combined do not have counts.");
        }
        this.hasPositions = writerFlags.containsKey((Object)CompressionFlags.Component.POSITIONS);
        if (this.hasPositions && !havePositions) {
            throw new IllegalArgumentException("Some of the indices to be combined do not have positions.");
        }
        this.hasPayloads = writerFlags.containsKey((Object)CompressionFlags.Component.PAYLOADS);
        if (this.hasPayloads && payload == null) {
            throw new IllegalArgumentException("Indices to be combined do not have payloads.");
        }
        if (!allDataForSizeComputation && this.hasPositions && quantum < 0) {
            throw new IllegalArgumentException("Some of the indices to be combined do not have offsets or number of bits for positions (and you required variable quanta).");
        }
        if ((skips |= !(interleaved |= !this.hasPositions || this.hasPayloads)) && (quantum == 0 || height < 0)) {
            throw new IllegalArgumentException("You must specify a nonzero quantum and a nonnegative height");
        }
        double d = this.p = skips && !metadataOnly && quantum < 0 ? (double)(-quantum) / 100.0 : 0.0;
        if (this.p != 0.0) {
            LOGGER.debug((Object)("Imposing dynamic " + Util.format((double)(this.p * 100.0)) + "% occupancy of variable-quantum skip lists"));
        }
        if (!metadataOnly) {
            this.indexWriter = interleaved ? (!skips ? new BitStreamIndexWriter(outputBasename, this.numberOfDocuments, true, writerFlags) : new SkipBitStreamIndexWriter(outputBasename, this.numberOfDocuments, true, skipBufferSize, writerFlags, skips ? (quantum < 0 ? 0 : quantum) : -1, skips ? height : -1)) : new BitStreamHPIndexWriter(outputBasename, this.numberOfDocuments, true, skipBufferSize, writerFlags, quantum < 0 ? 0 : quantum, height);
            if (skips && quantum < 0) {
                this.variableQuantumIndexWriter = (VariableQuantumIndexWriter)((Object)this.indexWriter);
            }
        }
    }

    protected abstract int combineNumberOfDocuments();

    protected IntIterator sizes(int numIndex) throws FileNotFoundException {
        if (this.index[numIndex].sizes != null) {
            return this.index[numIndex].sizes.listIterator();
        }
        LOGGER.debug((Object)("Reading sizes from " + this.inputBasename[numIndex] + ".sizes"));
        return new GammaCodedIntIterator(new InputBitStream(this.inputBasename[numIndex] + ".sizes"));
    }

    protected abstract int combineSizes(OutputBitStream var1) throws IOException;

    protected abstract int combine(int var1) throws IOException;

    public void run() throws ConfigurationException, IOException {
        int maxDocSize;
        Logger logger = Util.getLogger(this.getClass());
        ProgressLogger pl = new ProgressLogger(logger, this.logInterval);
        pl.displayFreeMemory = true;
        if (this.writeSizes) {
            logger.info((Object)"Combining sizes...");
            OutputBitStream sizesOutputBitStream = new OutputBitStream(this.outputBasename + ".sizes", this.bufferSize);
            maxDocSize = this.combineSizes(sizesOutputBitStream);
            sizesOutputBitStream.close();
            logger.info((Object)"Sizes combined.");
        } else {
            maxDocSize = -1;
        }
        OutputBitStream outputGlobCounts = this.writeGlobCounts ? new OutputBitStream(this.outputBasename + ".globcounts") : null;
        OutputBitStream frequencies = new OutputBitStream(this.outputBasename + ".frequencies");
        PrintWriter termFile = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputBasename + ".terms"), "UTF-8"), this.bufferSize));
        long numPointers = 0L;
        pl.expectedUpdates = this.writeGlobCounts ? this.numberOfOccurrences : -1L;
        pl.itemsName = this.writeGlobCounts ? "occurrences" : "terms";
        pl.logInterval = this.logInterval;
        pl.start((CharSequence)"Combining lists...");
        int numTerms = 0;
        long totalGlobCount = 0L;
        this.predictedSize = -1L;
        this.predictedLengthNumBits = -1L;
        if (this.p != 0.0) {
            for (InputBitStream ibs : this.offsets) {
                ibs.readGamma();
            }
        }
        while (!this.termQueue.isEmpty()) {
            int numUsedIndices = 0;
            int n = numUsedIndices++;
            int n2 = this.termQueue.first();
            this.usedIndex[n] = n2;
            int k = n2;
            MutableString currTerm = this.term[n2].copy();
            currTerm.println(termFile);
            if (this.termReader[k].readLine(this.term[k]) == null) {
                this.termQueue.dequeue();
            } else {
                this.termQueue.changed();
            }
            while (!this.termQueue.isEmpty() && this.term[this.termQueue.first()].equals(currTerm)) {
                this.usedIndex[numUsedIndices++] = this.termQueue.first();
                k = this.usedIndex[numUsedIndices++];
                if (this.termReader[k].readLine(this.term[k]) == null) {
                    this.termQueue.dequeue();
                    continue;
                }
                this.termQueue.changed();
            }
            if (numUsedIndices > 1) {
                Arrays.sort(this.usedIndex, 0, numUsedIndices);
            }
            int i = numUsedIndices;
            while (i-- != 0) {
                this.indexIterator[this.usedIndex[i]] = this.indexReader[this.usedIndex[i]].nextIterator();
            }
            ++numTerms;
            if (this.writeGlobCounts) {
                totalGlobCount = 0L;
                for (i = 0; i < numUsedIndices; ++i) {
                    totalGlobCount += this.globCounts[this.usedIndex[i]].readLongGamma();
                }
                outputGlobCounts.writeLongGamma(totalGlobCount);
            }
            if (this.p != 0.0) {
                this.predictedSize = 0L;
                this.predictedLengthNumBits = 0L;
                i = numUsedIndices;
                while (i-- != 0) {
                    if (this.index[this.usedIndex[i]] instanceof BitStreamHPIndex) {
                        this.predictedSize += this.offsets[this.usedIndex[i]].readLongGamma();
                        if (!this.hasPositions) continue;
                        this.predictedLengthNumBits += this.posNumBits[this.usedIndex[i]].readLongGamma();
                        continue;
                    }
                    long t = this.hasPositions ? this.posNumBits[this.usedIndex[i]].readLongGamma() : 0L;
                    this.predictedSize += this.offsets[this.usedIndex[i]].readLongGamma() - t;
                    this.predictedLengthNumBits += t;
                }
            }
            int totalFrequency = this.combine(numUsedIndices);
            frequencies.writeGamma(totalFrequency);
            numPointers += (long)totalFrequency;
            if (this.writeGlobCounts) {
                pl.count += totalGlobCount - 1L;
            }
            pl.update();
        }
        pl.done();
        if (this.writeGlobCounts) {
            outputGlobCounts.close();
        }
        termFile.close();
        frequencies.close();
        if (!this.metadataOnly) {
            int i = this.numIndices;
            while (i-- != 0) {
                this.indexReader[i].close();
                if (this.writeGlobCounts) {
                    this.globCounts[i].close();
                }
                if (this.p != 0.0) {
                    this.offsets[i].close();
                    if (this.posNumBits[i] != null) {
                        this.posNumBits[i].close();
                    }
                }
                this.termReader[i].close();
            }
            long indexSize = this.indexWriter.writtenBits();
            this.indexWriter.close();
            Properties properties = this.indexWriter.properties();
            this.additionalProperties.setProperty((Enum)Index.PropertyKeys.SIZE, indexSize);
            this.additionalProperties.setProperty((Enum)Index.PropertyKeys.MAXDOCSIZE, maxDocSize);
            this.additionalProperties.setProperty((Enum)Index.PropertyKeys.OCCURRENCES, this.numberOfOccurrences);
            properties.addAll((Configuration)this.additionalProperties);
            logger.debug((Object)("Post-merge properties: " + new ConfigurationMap((Configuration)properties)));
            properties.save(this.outputBasename + ".properties");
        }
        PrintStream stats = new PrintStream(new FileOutputStream(this.outputBasename + ".stats"));
        if (!this.metadataOnly) {
            this.indexWriter.printStats(stats);
        }
        stats.close();
    }

    public static void main(String[] arg) throws JSAPException, ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Combine.main(arg, null);
    }

    public static void main(String[] arg, Class<? extends Combine> combineClass) throws JSAPException, ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String[] inputBasename;
        SimpleJSAP jsap = new SimpleJSAP(Combine.class.getName(), "Combines several indices. By default, documents are concatenated, but you can also merge or paste them by choosing the suitable options, or invoking the corresponding subclass instead of " + Combine.class.getName() + ". Note that by combining a single input index you can recompress an index with new parameters.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x100000L), false, 'b', "buffer-size", "The size of an I/O buffer."), new FlaggedOption("comp", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "comp", "A compression flag for the index (may be specified several times).").setAllowMultipleDeclarations(true), new Switch("noSkips", '\u0000', "no-skips", "Disables skips."), new Switch("interleaved", '\u0000', "interleaved", "Forces an interleaved index."), new FlaggedOption("quantum", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(-1), false, 'Q', "quantum", "Enable skips with given quantum, if positive; fix space occupancy of variable-quantum skip towers in percentage if negative."), new FlaggedOption("height", (StringParser)JSAP.INTSIZE_PARSER, Integer.toString(16), false, 'H', "height", "The skip height."), new Switch("metadataOnly", 'o', "metadata-only", "Combines only metadata (sizes, terms, frequencies and globcounts)."), new Switch("merge", 'm', "merge", "Merges indices (duplicates cause an error)."), new Switch("duplicates", 'd', "duplicates", "Pastes indices, concatenating the document positions for duplicates."), new Switch("incremental", 'i', "incremental", "Pastes indices incrementally: positions in each index are incremented by the sum of the document sizes in previous indices."), new Switch("properties", 'p', "properties", "The only specified inputBasename will be used to load a property file written by the scanning process."), new FlaggedOption("delete", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, 'D', "delete", "A monotonically increasing array of integers in Java binary format representing documents that will be deleted from the output index."), new FlaggedOption("tempFileDir", (StringParser)FileStringParser.getParser(), JSAP.NO_DEFAULT, false, '\u0000', "temp-file-dir", "The directory for the temporary file used during pasting."), new FlaggedOption("tempFileBufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x1000000L), false, '\u0000', "temp-file-buffer-size", "The size of the buffer for the temporary file during pasting."), new FlaggedOption("skipBufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x2000000L), false, '\u0000', "skip-buffer-size", "The size of the internal temporary buffer used while creating an index with skips."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("outputBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the resulting index."), new UnflaggedOption("inputBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The basenames of the indices to be merged.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean skips = !jsapResult.getBoolean("noSkips");
        boolean interleaved = jsapResult.getBoolean("interleaved");
        if (!skips && (jsapResult.userSpecified("quantum") || jsapResult.userSpecified("height"))) {
            throw new IllegalArgumentException("You specified quantum or height, but you also disabled skips.");
        }
        if (combineClass != null && jsapResult.userSpecified("duplicates") || jsapResult.userSpecified("merge")) {
            throw new IllegalArgumentException("When invoking " + Combine.class.getName() + " from " + combineClass.getName() + " you cannot choose the combination process");
        }
        if (jsapResult.getBoolean("properties")) {
            if (jsapResult.getStringArray("inputBasename").length > 1) {
                throw new IllegalArgumentException("When using --properties, you must specify exactly one inputBasename");
            }
            inputBasename = new Properties(jsapResult.getStringArray("inputBasename")[0] + ".cluster.properties").getStringArray((Enum)IndexCluster.PropertyKeys.LOCALINDEX);
        } else {
            inputBasename = jsapResult.getStringArray("inputBasename");
        }
        (combineClass == Paste.class || jsapResult.getBoolean("duplicates") ? new Paste(jsapResult.getString("outputBasename"), inputBasename, jsapResult.getBoolean("metadataOnly"), jsapResult.getBoolean("incremental"), jsapResult.getInt("bufferSize"), jsapResult.getFile("tempFileDir"), jsapResult.getInt("tempFileBufferSize"), CompressionFlags.valueOf(jsapResult.getStringArray("comp"), CompressionFlags.DEFAULT_STANDARD_INDEX), interleaved, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getInt("skipBufferSize"), jsapResult.getLong("logInterval")) : (combineClass == Merge.class || jsapResult.getBoolean("merge") ? new Merge(jsapResult.getString("outputBasename"), inputBasename, jsapResult.getBoolean("metadataOnly"), jsapResult.getInt("bufferSize"), CompressionFlags.valueOf(jsapResult.getStringArray("comp"), CompressionFlags.DEFAULT_STANDARD_INDEX), interleaved, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getInt("skipBufferSize"), jsapResult.getLong("logInterval")) : new Concatenate(jsapResult.getString("outputBasename"), inputBasename, jsapResult.getBoolean("metadataOnly"), jsapResult.getInt("bufferSize"), CompressionFlags.valueOf(jsapResult.getStringArray("comp"), CompressionFlags.DEFAULT_STANDARD_INDEX), interleaved, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getInt("skipBufferSize"), jsapResult.getLong("logInterval")))).run();
    }

    protected static final class GammaCodedIntIterator
    extends AbstractIntIterator
    implements Closeable {
        private final InputBitStream inputBitStream;

        public GammaCodedIntIterator(InputBitStream inputBitStream) {
            this.inputBitStream = inputBitStream;
        }

        public boolean hasNext() {
            return true;
        }

        public int nextInt() {
            try {
                return this.inputBitStream.readGamma();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.inputBitStream.close();
        }
    }
}

