/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.mg4j.index.BitStreamHPIndex;
import it.unimi.dsi.mg4j.index.Index;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import org.apache.commons.configuration.ConfigurationException;

public class ComputeNumBitsPositions {
    public static void main(String[] arg) throws JSAPException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException, IOException, IllegalAccessException, InstantiationException, ConfigurationException, SecurityException, URISyntaxException {
        SimpleJSAP jsap = new SimpleJSAP(ComputeNumBitsPositions.class.getName(), "Scans and prints to standard output metadata of a collection. All line terminators in the metadata will be substituted with spaces.", new Parameter[]{new UnflaggedOption("basename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the index.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String basename = jsapResult.getString("basename");
        BitStreamHPIndex index = (BitStreamHPIndex)Index.getInstance(basename, false, false);
        InputBitStream ibs = new InputBitStream(basename + ".index");
        InputBitStream offsets = new InputBitStream(basename + ".offsets");
        OutputBitStream numBitsPos = new OutputBitStream(basename + ".posnumbits");
        long pos = 0L;
        long positionOffset = 0L;
        for (int i = 0; i < index.numberOfTerms; ++i) {
            ibs.position(pos += offsets.readLongGamma());
            long o = ibs.readLongDelta();
            if (i > 0) {
                numBitsPos.writeLongGamma(o - positionOffset);
            }
            positionOffset = o;
        }
        numBitsPos.writeLongGamma(new File(basename + ".positions").length() * 8L - positionOffset);
        numBitsPos.close();
        offsets.close();
        ibs.close();
    }
}

