/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.JSAPException;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.tool.Combine;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;

public final class Concatenate
extends Combine {
    public Concatenate(String outputBasename, String[] inputBasename, boolean metadataOnly, int bufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this(outputBasename, inputBasename, null, metadataOnly, bufferSize, writerFlags, interleaved, skips, quantum, height, skipBufferSize, logInterval);
    }

    public Concatenate(String outputBasename, String[] inputBasename, IntList delete, boolean metadataOnly, int bufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        super(outputBasename, inputBasename, delete, metadataOnly, false, bufferSize, writerFlags, interleaved, skips, quantum, height, skipBufferSize, logInterval);
    }

    @Override
    protected int combineNumberOfDocuments() {
        int n = 0;
        for (int i = 0; i < this.numIndices; ++i) {
            n += this.index[i].numberOfDocuments;
        }
        return n;
    }

    @Override
    protected int combineSizes(OutputBitStream sizesOutputBitStream) throws IOException {
        int maxDocSize = 0;
        int currDoc = 0;
        if (this.needsSizes) {
            this.size = new int[this.numberOfDocuments];
        }
        for (int i = 0; i < this.numIndices; ++i) {
            IntIterator sizes = this.sizes(i);
            int s = 0;
            int j = this.index[i].numberOfDocuments;
            while (j-- != 0) {
                s = sizes.nextInt();
                maxDocSize = Math.max(maxDocSize, s);
                if (this.needsSizes) {
                    this.size[currDoc++] = s;
                }
                sizesOutputBitStream.writeGamma(s);
            }
            if (!(sizes instanceof Closeable)) continue;
            ((Closeable)sizes).close();
        }
        return maxDocSize;
    }

    @Override
    protected int combine(int numUsedIndices) throws IOException {
        int totalFrequency = 0;
        int k = numUsedIndices;
        while (k-- != 0) {
            int n = this.indexIterator[this.usedIndex[k]].frequency();
            this.frequency[this.usedIndex[k]] = n;
            totalFrequency += n;
        }
        if (!this.metadataOnly) {
            int numPrevDocs = 0;
            if (this.p != 0.0) {
                this.variableQuantumIndexWriter.newInvertedList(totalFrequency, this.p, this.predictedSize, this.predictedLengthNumBits);
            } else {
                this.indexWriter.newInvertedList();
            }
            this.indexWriter.writeFrequency(totalFrequency);
            int currIndex = 0;
            for (int k2 = 0; k2 < numUsedIndices; ++k2) {
                while (currIndex < this.usedIndex[k2]) {
                    numPrevDocs += this.index[currIndex++].numberOfDocuments;
                }
                BitStreamIndex i = this.index[currIndex];
                IndexIterator ii = this.indexIterator[currIndex];
                int j = this.frequency[currIndex];
                while (j-- != 0) {
                    OutputBitStream obs = this.indexWriter.newDocumentRecord();
                    int currDoc = ii.nextDocument() + numPrevDocs;
                    this.indexWriter.writeDocumentPointer(obs, currDoc);
                    if (i.hasPayloads) {
                        this.indexWriter.writePayload(obs, ii.payload());
                    }
                    if (!i.hasCounts) continue;
                    int count = ii.count();
                    if (this.hasCounts) {
                        this.indexWriter.writePositionCount(obs, count);
                    }
                    if (!this.hasPositions) continue;
                    this.indexWriter.writeDocumentPositions(obs, ii.positionArray(), 0, count, this.size != null ? this.size[currDoc] : -1);
                }
            }
        }
        return totalFrequency;
    }

    public static void main(String[] arg) throws ConfigurationException, SecurityException, JSAPException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Combine.main(arg, Concatenate.class);
    }
}

