/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.JSAPException;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.CachingOutputBitStream;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.IndexIterator;
import it.unimi.dsi.mg4j.tool.Combine;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public final class Paste
extends Combine {
    private static final Logger LOGGER = Util.getLogger(Paste.class);
    public static final int DEFAULT_MEMORY_BUFFER_SIZE = 0x1000000;
    protected final int[] doc;
    private final boolean incremental;
    protected final IntHeapPriorityQueue documentQueue;
    private final File tempFile;
    private final CachingOutputBitStream cacheBitStreamOut;
    private final InputBitStream cacheBitStreamIn;
    private final InputBitStream cacheBitStreamInWrapper;
    private final int[] sizesSize;

    public Paste(String outputBasename, String[] inputBasename, boolean metadataOnly, boolean incremental, int bufferSize, File tempFileDir, int tempBufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this(outputBasename, inputBasename, null, metadataOnly, incremental, bufferSize, tempFileDir, tempBufferSize, writerFlags, interleaved, skips, quantum, height, skipBufferSize, logInterval);
    }

    public Paste(String outputBasename, String[] inputBasename, IntList delete, boolean metadataOnly, boolean incremental, int bufferSize, File tempFileDir, int tempBufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        super(outputBasename, inputBasename, delete, metadataOnly, incremental, bufferSize, writerFlags, interleaved, skips, quantum, height, skipBufferSize, logInterval);
        int i;
        this.incremental = incremental;
        this.tempFile = File.createTempFile("MG4J", ".data", tempFileDir);
        this.cacheBitStreamOut = new CachingOutputBitStream(this.tempFile, tempBufferSize);
        this.cacheBitStreamIn = new InputBitStream(this.tempFile, bufferSize);
        this.cacheBitStreamInWrapper = new InputBitStream(this.cacheBitStreamOut.buffer());
        int estimateForMaxCount = 0;
        int tempSize = 0;
        int[] nArray = this.sizesSize = incremental ? new int[this.numIndices] : null;
        if (incremental) {
            i = this.index.length;
            while (i-- != 0) {
                this.sizesSize[i] = this.index[i].sizes.size();
            }
        }
        for (i = 0; i < this.numIndices; ++i) {
            if (this.index[i].hasPayloads) {
                throw new IllegalArgumentException("You cannot paste indices with payloads");
            }
            estimateForMaxCount += this.index[i].maxCount;
            tempSize = Math.max(tempSize, this.index[i].maxCount);
        }
        if (this.hasPositions) {
            this.position = new int[estimateForMaxCount];
        }
        this.doc = new int[this.numIndices];
        this.documentQueue = new IntHeapPriorityQueue(this.numIndices, (IntComparator)new DocumentIndexComparator(this.doc));
    }

    @Override
    protected int combineNumberOfDocuments() {
        int n = 0;
        for (int i = 0; i < this.numIndices; ++i) {
            n = Math.max(n, this.index[i].numberOfDocuments);
        }
        return n;
    }

    @Override
    protected int combineSizes(OutputBitStream sizesOutputBitStream) throws IOException {
        int currDoc = 0;
        int maxDocSize = 0;
        if (this.incremental) {
            this.size = new int[this.numberOfDocuments];
            for (int i = 0; i < this.numIndices; ++i) {
                IntIterator sizes = this.sizes(i);
                int j = this.index[i].numberOfDocuments;
                currDoc = 0;
                while (j-- != 0) {
                    int n = currDoc++;
                    int n2 = this.size[n] + sizes.nextInt();
                    this.size[n] = n2;
                    maxDocSize = Math.max(maxDocSize, n2);
                }
                if (!(sizes instanceof Closeable)) continue;
                ((Closeable)sizes).close();
            }
            for (int s : this.size) {
                sizesOutputBitStream.writeGamma(s);
            }
            if (!this.needsSizes) {
                this.size = null;
            }
        } else {
            if (this.needsSizes) {
                this.size = new int[this.numberOfDocuments];
            }
            IntIterator sizes = this.sizes(this.numIndices - 1);
            int s = 0;
            for (int j = 0; j < this.numberOfDocuments; ++j) {
                s = sizes.nextInt();
                if (this.needsSizes) {
                    this.size[j] = s;
                }
                maxDocSize = Math.max(maxDocSize, s);
                sizesOutputBitStream.writeGamma(s);
            }
            if (sizes instanceof Closeable) {
                ((Closeable)sizes).close();
            }
            if (!this.needsSizes) {
                this.size = null;
            }
        }
        return maxDocSize;
    }

    @Override
    protected int combine(int numUsedIndices) throws IOException {
        int count;
        int currDoc;
        int currIndex;
        int prevDoc = -1;
        int k = numUsedIndices;
        while (k-- != 0) {
            currIndex = this.usedIndex[k];
            this.frequency[currIndex] = this.indexIterator[currIndex].frequency();
            this.doc[currIndex] = this.indexIterator[currIndex].nextDocument();
            this.documentQueue.enqueue(currIndex);
        }
        this.cacheBitStreamOut.position(0L);
        int totalFrequency = 0;
        while (!this.documentQueue.isEmpty()) {
            int k2;
            currIndex = this.documentQueue.firstInt();
            currDoc = this.doc[currIndex];
            ++totalFrequency;
            if (!this.metadataOnly) {
                this.cacheBitStreamOut.writeDelta(currDoc - prevDoc - 1);
            }
            int increment = 0;
            int prevIndex = 0;
            int totalCount = 0;
            do {
                if (this.incremental) {
                    while (prevIndex < currIndex) {
                        if (this.sizesSize[prevIndex] > currDoc) {
                            increment += this.index[prevIndex].sizes.getInt(currDoc);
                        }
                        ++prevIndex;
                    }
                }
                BitStreamIndex i = this.index[currIndex];
                i = this.index[currIndex];
                IndexIterator ii = this.indexIterator[currIndex];
                if (!this.metadataOnly && i.hasCounts) {
                    count = ii.count();
                    if (i.hasPositions) {
                        int[] temp = ii.positionArray();
                        if (!this.incremental && totalCount > 0 && temp[0] <= this.position[totalCount - 1]) {
                            throw new IllegalStateException("Positions in document " + currDoc + " are not increasing; you probably need to require an incremental pasting");
                        }
                        k2 = count;
                        while (k2-- != 0) {
                            this.position[totalCount + k2] = temp[k2] + increment;
                        }
                    }
                    totalCount += count;
                }
                int n = currIndex;
                this.frequency[n] = this.frequency[n] - 1;
                if (this.frequency[n] == 0) {
                    this.documentQueue.dequeue();
                    continue;
                }
                this.doc[currIndex] = ii.nextDocument();
                this.documentQueue.changed();
            } while (!this.documentQueue.isEmpty() && this.doc[currIndex = this.documentQueue.firstInt()] == currDoc);
            if (totalCount > this.maxCount) {
                this.maxCount = totalCount;
            }
            if (!this.metadataOnly && this.hasCounts) {
                this.cacheBitStreamOut.writeGamma(totalCount);
                if (this.hasPositions) {
                    this.cacheBitStreamOut.writeDelta(this.position[0]);
                    for (k2 = 1; k2 < totalCount; ++k2) {
                        this.cacheBitStreamOut.writeDelta(this.position[k2] - this.position[k2 - 1] - 1);
                    }
                }
            }
            prevDoc = currDoc;
        }
        if (!this.metadataOnly) {
            InputBitStream ibs;
            if (this.p != 0.0) {
                this.variableQuantumIndexWriter.newInvertedList(totalFrequency, this.p, this.predictedSize, this.predictedLengthNumBits);
            } else {
                this.indexWriter.newInvertedList();
            }
            this.indexWriter.writeFrequency(totalFrequency);
            this.cacheBitStreamOut.align();
            if (this.cacheBitStreamOut.buffer() != null) {
                ibs = this.cacheBitStreamInWrapper;
            } else {
                this.cacheBitStreamOut.flush();
                ibs = this.cacheBitStreamIn;
                ibs.flush();
            }
            ibs.position(0L);
            currDoc = -1;
            int j = totalFrequency;
            while (j-- != 0) {
                OutputBitStream obs = this.indexWriter.newDocumentRecord();
                currDoc = ibs.readDelta() + currDoc + 1;
                this.indexWriter.writeDocumentPointer(obs, currDoc);
                if (!this.hasCounts) continue;
                count = ibs.readGamma();
                this.indexWriter.writePositionCount(obs, count);
                if (!this.hasPositions) continue;
                this.position[0] = ibs.readDelta();
                for (int k3 = 1; k3 < count; ++k3) {
                    this.position[k3] = this.position[k3 - 1] + ibs.readDelta() + 1;
                }
                this.indexWriter.writeDocumentPositions(obs, this.position, 0, count, this.size != null ? this.size[currDoc] : -1);
            }
        }
        return totalFrequency;
    }

    @Override
    public void run() throws ConfigurationException, IOException {
        super.run();
        this.cacheBitStreamOut.close();
        this.tempFile.delete();
    }

    public static void main(String[] arg) throws ConfigurationException, SecurityException, JSAPException, IOException, URISyntaxException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Combine.main(arg, Paste.class);
    }

    private static final class DocumentIndexComparator
    extends AbstractIntComparator {
        private final int[] refArray;

        public DocumentIndexComparator(int[] refArray) {
            this.refArray = refArray;
        }

        public int compare(int i, int j) {
            int t = this.refArray[i] - this.refArray[j];
            return t != 0 ? t : i - j;
        }
    }
}

