/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.BitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.VariableQuantumIndexWriter;
import it.unimi.dsi.mg4j.search.AlignDocumentIterator;
import it.unimi.dsi.util.Properties;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class PrecomputeAlignments {
    private static final Logger LOGGER = Util.getLogger(PrecomputeAlignments.class);
    protected final int numberOfDocuments;
    protected final String outputBasename;
    private final long logInterval;
    protected IndexWriter indexWriter;
    protected VariableQuantumIndexWriter variableQuantumIndexWriter;
    private final BitStreamIndex alignerIndex;
    private final BitStreamIndex aligneeIndex;
    private final Collection<? extends CharSequence> terms;
    private int numberOfTerms;
    private boolean subset;

    public PrecomputeAlignments(String outputBasename, String aligneeBasename, String alignerBasename, ObjectList<? extends CharSequence> terms, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.logInterval = logInterval;
        this.subset = terms != null;
        this.aligneeIndex = (BitStreamIndex)Index.getInstance(aligneeBasename, true, false, this.subset);
        this.alignerIndex = (BitStreamIndex)Index.getInstance(alignerBasename, true, false, false);
        if (this.aligneeIndex.numberOfDocuments != this.alignerIndex.numberOfDocuments) {
            LOGGER.warn((Object)"Alignee and aligner do not have the same number of documents");
        }
        this.numberOfDocuments = this.alignerIndex.numberOfTerms + 1;
        this.terms = terms;
        this.numberOfTerms = this.subset ? terms.size() : this.aligneeIndex.numberOfTerms;
        this.outputBasename = outputBasename;
        LOGGER.debug((Object)("Precomputing alignment of " + aligneeBasename + " with " + alignerBasename + " into " + outputBasename));
        Reference2ReferenceOpenHashMap writerFlags = new Reference2ReferenceOpenHashMap(CompressionFlags.DEFAULT_STANDARD_INDEX);
        writerFlags.remove((Object)CompressionFlags.Component.COUNTS);
        writerFlags.remove((Object)CompressionFlags.Component.POSITIONS);
        this.indexWriter = new BitStreamIndexWriter(outputBasename, this.numberOfDocuments, true, (Map<CompressionFlags.Component, CompressionFlags.Coding>)writerFlags);
    }

    public void run() throws IOException, ConfigurationException {
        Logger logger = Util.getLogger(this.getClass());
        ProgressLogger pl = new ProgressLogger(logger, this.logInterval);
        pl.displayFreeMemory = true;
        OutputBitStream frequencies = new OutputBitStream(this.outputBasename + ".frequencies");
        PrintWriter termFile = this.subset ? new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputBasename + ".terms"), "UTF-8"))) : null;
        pl.expectedUpdates = this.numberOfTerms;
        pl.itemsName = "terms";
        pl.logInterval = this.logInterval;
        pl.start((CharSequence)"Precomputing alignments...");
        IntArrayList postings = new IntArrayList();
        IndexReader aligneeIndexReader = this.aligneeIndex.getReader();
        Iterator<? extends CharSequence> termIterator = this.subset ? this.terms.iterator() : null;
        MutableString term = new MutableString();
        for (int t = 0; t < this.numberOfTerms; ++t) {
            int u;
            if (this.subset) {
                term.replace(termIterator.next());
                u = (int)this.aligneeIndex.termMap.getLong((Object)term);
                if (u == -1) {
                    LOGGER.warn((Object)("Term " + term + " is not part of the index to be aligned"));
                }
                termFile.println(term);
            } else {
                u = t;
            }
            this.indexWriter.newInvertedList();
            postings.clear();
            if (u != -1) {
                IndexReader alignerIndexReader = this.alignerIndex.getReader();
                for (int a = 0; a < this.numberOfDocuments - 1; ++a) {
                    if (!AlignDocumentIterator.getInstance(aligneeIndexReader.documents(u), alignerIndexReader.nextIterator()).hasNext()) continue;
                    postings.add(a);
                }
                alignerIndexReader.close();
            }
            postings.add(this.numberOfDocuments - 1);
            this.indexWriter.writeFrequency(postings.size());
            frequencies.writeGamma(postings.size());
            Iterator i$ = postings.iterator();
            while (i$.hasNext()) {
                int p = (Integer)i$.next();
                this.indexWriter.writeDocumentPointer(this.indexWriter.newDocumentRecord(), p);
            }
            pl.update();
        }
        pl.done();
        this.indexWriter.close();
        if (this.subset) {
            termFile.close();
        }
        Properties properties = this.indexWriter.properties();
        properties.addProperty((Enum)Index.PropertyKeys.TERMPROCESSOR, (Object)ObjectParser.toSpec((Object)this.alignerIndex.termProcessor));
        properties.save(this.outputBasename + ".properties");
        frequencies.close();
    }

    public static void main(String[] arg) throws JSAPException, ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ObjectList terms;
        SimpleJSAP jsap = new SimpleJSAP(PrecomputeAlignments.class.getName(), "Precomputes alignments between two indices.", new Parameter[]{new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("outputBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the resulting index."), new UnflaggedOption("aligneeBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the index who has to be aligned."), new UnflaggedOption("alignerBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the index used to align."), new UnflaggedOption("terms", (StringParser)JSAP.STRING_PARSER, false, "A file containing a selected subset of UTF-8 coded words on which the alignments must be computed. The terms must be in sorted order, and appear in the same form as they appear in the file of terms of the alignee (i.e., no term processing will be applied).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        ObjectList objectList = terms = jsapResult.userSpecified("terms") ? new FileLinesCollection((CharSequence)jsapResult.getString("terms"), "UTF-8").allLines() : null;
        if (terms != null) {
            Collections.sort(terms);
        }
        new PrecomputeAlignments(jsapResult.getString("outputBasename"), jsapResult.getString("aligneeBasename"), jsapResult.getString("alignerBasename"), (ObjectList<? extends CharSequence>)terms, jsapResult.getLong("logInterval")).run();
    }
}

