/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.tool;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import it.unimi.dsi.Util;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.io.FileLinesCollection;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.lang.ObjectParser;
import it.unimi.dsi.logging.ProgressLogger;
import it.unimi.dsi.mg4j.index.BitStreamHPIndexWriter;
import it.unimi.dsi.mg4j.index.BitStreamIndex;
import it.unimi.dsi.mg4j.index.BitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.CompressionFlags;
import it.unimi.dsi.mg4j.index.Index;
import it.unimi.dsi.mg4j.index.IndexReader;
import it.unimi.dsi.mg4j.index.IndexWriter;
import it.unimi.dsi.mg4j.index.SkipBitStreamIndexWriter;
import it.unimi.dsi.mg4j.index.TermProcessor;
import it.unimi.dsi.mg4j.query.nodes.Query;
import it.unimi.dsi.mg4j.query.nodes.QueryBuilderVisitorException;
import it.unimi.dsi.mg4j.query.nodes.Term;
import it.unimi.dsi.mg4j.query.parser.QueryParserException;
import it.unimi.dsi.mg4j.query.parser.SimpleParser;
import it.unimi.dsi.mg4j.search.DocumentIterator;
import it.unimi.dsi.mg4j.search.DocumentIteratorBuilderVisitor;
import it.unimi.dsi.mg4j.search.IntervalIterator;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Properties;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;

public class PrecomputeIndex {
    private static final Logger LOGGER = Util.getLogger(PrecomputeIndex.class);
    protected final int numberOfDocuments;
    protected final String outputBasename;
    private final long logInterval;
    private final IndexWriter indexWriter;
    private final BitStreamIndex mainIndex;
    private Query query;
    private ReplacingDocumentIteratorBuilderVisitor visitor;
    private boolean hasPositions;
    private String fieldName;
    private FileLinesCollection.FileLinesIterator terms;
    private boolean hasCounts;

    public PrecomputeIndex(String outputBasename, String[] inputBasename, String queryString, String fieldName, int bufferSize, Map<CompressionFlags.Component, CompressionFlags.Coding> writerFlags, boolean interleaved, boolean skips, int quantum, int height, int skipBufferSize, long logInterval) throws IOException, ConfigurationException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, QueryParserException, QueryBuilderVisitorException {
        this.logInterval = logInterval;
        this.outputBasename = outputBasename;
        this.fieldName = fieldName;
        BitStreamIndex[] index = new BitStreamIndex[inputBasename.length];
        boolean havePositions = true;
        ObjectOpenHashSet indices = new ObjectOpenHashSet();
        Object2ObjectOpenHashMap termProcessors = new Object2ObjectOpenHashMap();
        Object2ReferenceOpenHashMap indexMap = new Object2ReferenceOpenHashMap();
        int numberOfDocuments = -1;
        for (int i = 0; i < inputBasename.length; ++i) {
            index[i] = (BitStreamIndex)Index.getInstance(inputBasename[i], true, false, true);
            indexMap.put((Object)index[i].field, (Object)index[i]);
            if (numberOfDocuments == -1) {
                numberOfDocuments = index[i].numberOfDocuments;
            }
            if (numberOfDocuments != index[i].numberOfDocuments) {
                throw new IllegalArgumentException("All indices must have the same number of documents");
            }
            indices.add((Object)index[i].field);
            if (index[i].termProcessor != null) {
                termProcessors.put((Object)index[i].field, (Object)index[i].termProcessor);
            }
            havePositions &= index[i].hasPositions;
        }
        this.mainIndex = index[0];
        int questionMarkPos = inputBasename[0].indexOf(63);
        this.terms = new FileLinesCollection((CharSequence)((questionMarkPos == -1 ? inputBasename[0] : inputBasename[0].substring(0, questionMarkPos)) + ".terms"), "UTF-8").iterator();
        this.numberOfDocuments = numberOfDocuments;
        this.hasPositions = havePositions;
        this.query = new SimpleParser((Set<String>)indices, this.mainIndex.field, (Map<String, ? extends TermProcessor>)termProcessors).parse(queryString);
        this.hasCounts = writerFlags.containsKey((Object)CompressionFlags.Component.COUNTS);
        if (this.hasCounts && !havePositions) {
            throw new IllegalArgumentException("Some of the indices to be combined do not have positions, which are necessary to compute counts.");
        }
        this.hasPositions = writerFlags.containsKey((Object)CompressionFlags.Component.POSITIONS);
        if (this.hasPositions && !havePositions) {
            throw new IllegalArgumentException("Some of the indices to be combined do not have positions.");
        }
        this.indexWriter = interleaved ? (!skips ? new BitStreamIndexWriter(outputBasename, numberOfDocuments, true, writerFlags) : new SkipBitStreamIndexWriter(outputBasename, numberOfDocuments, true, skipBufferSize, writerFlags, (skips |= !(interleaved |= !this.hasPositions)) ? quantum : -1, skips ? height : -1)) : new BitStreamHPIndexWriter(outputBasename, numberOfDocuments, true, skipBufferSize, writerFlags, quantum, height);
        this.visitor = new ReplacingDocumentIteratorBuilderVisitor(new MutableString("?"), (Object2ReferenceMap<String, Index>)indexMap, this.mainIndex, Integer.MAX_VALUE, bufferSize);
        LOGGER.debug((Object)("Precomputing index " + outputBasename + " from " + Arrays.toString(inputBasename) + " using query " + this.query));
    }

    public void run() throws IOException, ConfigurationException, QueryBuilderVisitorException {
        ProgressLogger pl = new ProgressLogger(LOGGER, this.logInterval);
        pl.displayFreeMemory = true;
        OutputBitStream frequencies = new OutputBitStream(this.outputBasename + ".frequencies");
        OutputBitStream occurrencies = this.hasPositions ? new OutputBitStream(this.outputBasename + ".globcounts") : null;
        PrintWriter termFile = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputBasename + ".terms"), "UTF-8")));
        pl.expectedUpdates = this.mainIndex.numberOfTerms;
        pl.itemsName = "terms";
        pl.logInterval = this.logInterval;
        pl.start((CharSequence)"Precomputing...");
        IntArrayList positions = new IntArrayList();
        long totOccurrencies = 0L;
        for (int i = 0; i < this.mainIndex.numberOfTerms; ++i) {
            MutableString term = this.terms.next();
            this.visitor.currentTerm = i;
            DocumentIterator documentIterator = this.query.accept(this.visitor);
            long f = 0L;
            while (documentIterator.nextDocument() != -1) {
                ++f;
            }
            if (f != 0L) {
                int d;
                termFile.println(term);
                this.indexWriter.newInvertedList();
                this.indexWriter.writeFrequency((int)f);
                frequencies.writeLongGamma(f);
                documentIterator = this.query.accept(this.visitor);
                long occurrency = 0L;
                while ((d = documentIterator.nextDocument()) != -1) {
                    Interval interval;
                    OutputBitStream out = this.indexWriter.newDocumentRecord();
                    this.indexWriter.writeDocumentPointer(out, d);
                    if (!this.hasCounts) continue;
                    positions.clear();
                    IntervalIterator intervalIterator = documentIterator.intervalIterator();
                    while ((interval = intervalIterator.nextInterval()) != null) {
                        if (interval.length() > 1) {
                            throw new IllegalStateException();
                        }
                        positions.add(interval.left);
                    }
                    this.indexWriter.writePositionCount(out, positions.size());
                    if (this.hasPositions) {
                        this.indexWriter.writeDocumentPositions(out, positions.elements(), 0, positions.size(), -1);
                    }
                    occurrency += (long)positions.size();
                }
                totOccurrencies += occurrency;
                if (occurrencies != null) {
                    occurrencies.writeLongGamma(occurrency);
                }
            }
            pl.update();
        }
        this.visitor.close();
        frequencies.close();
        this.indexWriter.close();
        termFile.close();
        this.terms.close();
        if (occurrencies != null) {
            occurrencies.close();
        }
        pl.done();
        Properties properties = this.indexWriter.properties();
        properties.addProperty((Enum)Index.PropertyKeys.TERMPROCESSOR, (Object)ObjectParser.toSpec((Object)this.mainIndex.termProcessor));
        if (this.hasPositions) {
            properties.addProperty((Enum)Index.PropertyKeys.OCCURRENCES, totOccurrencies);
        }
        if (this.fieldName != null || this.mainIndex.field != null) {
            properties.addProperty((Enum)Index.PropertyKeys.FIELD, (Object)(this.fieldName != null ? this.fieldName : this.mainIndex.field));
        }
        properties.save(this.outputBasename + ".properties");
    }

    public static void main(String[] arg) throws JSAPException, ConfigurationException, IOException, URISyntaxException, ClassNotFoundException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, QueryParserException, QueryBuilderVisitorException {
        SimpleJSAP jsap = new SimpleJSAP(PrecomputeIndex.class.getName(), "Precomputes an index using a query. The query will be run replacing a settable marker symbol with all terms of the first input index. All queries producing nonempty results will generate a posting list associated to the current term, and containing the results of the query.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x100000L), false, 'b', "buffer-size", "The size of an I/O buffer."), new FlaggedOption("comp", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'c', "comp", "A compression flag for the index (may be specified several times).").setAllowMultipleDeclarations(true), new Switch("noSkips", '\u0000', "no-skips", "Disables skips."), new Switch("interleaved", '\u0000', "interleaved", "Forces an interleaved index."), new FlaggedOption("quantum", (StringParser)JSAP.INTEGER_PARSER, Integer.toString(64), false, 'Q', "quantum", "Enable skips with given quantum, if positive; fix space occupancy of variable-quantum skip towers in percentage if negative."), new FlaggedOption("height", (StringParser)JSAP.INTSIZE_PARSER, Integer.toString(16), false, 'H', "height", "The skip height."), new FlaggedOption("skipBufferSize", (StringParser)JSAP.INTSIZE_PARSER, Util.formatBinarySize((long)0x2000000L), false, '\u0000', "skip-buffer-size", "The size of the internal temporary buffer used while creating an index with skips."), new FlaggedOption("logInterval", (StringParser)JSAP.LONG_PARSER, Long.toString(10000L), false, 'l', "log-interval", "The minimum time interval between activity logs in milliseconds."), new UnflaggedOption("outputBasename", (StringParser)JSAP.STRING_PARSER, true, "The basename of the resulting index."), new FlaggedOption("fieldName", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'f', "field-name", "An optional field name for the precomputed index (by default, the same of the first input index)."), new FlaggedOption("marker", (StringParser)JSAP.STRING_PARSER, "?", false, 'm', "marker", "The term marker: instances in the query will be replaced by the current term from the first input index."), new UnflaggedOption("query", (StringParser)JSAP.STRING_PARSER, false, "A query containing instances of the marker."), new UnflaggedOption("inputBasename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, true, "The basenames of the indices to be queried.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        boolean skips = !jsapResult.getBoolean("noSkips");
        boolean interleaved = jsapResult.getBoolean("interleaved");
        if (!skips && (jsapResult.userSpecified("quantum") || jsapResult.userSpecified("height"))) {
            throw new IllegalArgumentException("You specified quantum or height, but you also disabled skips.");
        }
        new PrecomputeIndex(jsapResult.getString("outputBasename"), jsapResult.getStringArray("inputBasename"), jsapResult.getString("query"), jsapResult.getString("fieldName"), jsapResult.getInt("bufferSize"), CompressionFlags.valueOf(jsapResult.getStringArray("comp"), CompressionFlags.DEFAULT_STANDARD_INDEX), interleaved, skips, jsapResult.getInt("quantum"), jsapResult.getInt("height"), jsapResult.getInt("skipBufferSize"), jsapResult.getLong("logInterval")).run();
    }

    protected static final class ReplacingDocumentIteratorBuilderVisitor
    extends DocumentIteratorBuilderVisitor
    implements Closeable {
        private final Object2ObjectMap<Term, IndexReader> term2IndexReader;
        private final int bufferSize;
        private final MutableString marker;
        protected int currentTerm;

        public ReplacingDocumentIteratorBuilderVisitor(MutableString marker, Object2ReferenceMap<String, Index> indexMap, Index defaultIndex, int limit, int bufferSize) {
            super(indexMap, defaultIndex, limit);
            this.marker = marker;
            this.bufferSize = bufferSize;
            this.term2IndexReader = new Object2ObjectOpenHashMap();
        }

        @Override
        public DocumentIterator visit(Term node) throws QueryBuilderVisitorException {
            try {
                IndexReader indexReader = (IndexReader)this.term2IndexReader.get((Object)node);
                if (indexReader == null) {
                    indexReader = ((Index)this.curr.top()).getReader(this.bufferSize);
                    this.term2IndexReader.put((Object)node, (Object)indexReader);
                }
                if (node.term != null && this.marker.equals(node.term)) {
                    return indexReader.documents(this.currentTerm).weight(this.weight());
                }
                if (node.termNumber != -1) {
                    return indexReader.documents(node.termNumber).weight(this.weight());
                }
                return indexReader.documents(node.term).weight(this.weight());
            }
            catch (IOException e) {
                throw new QueryBuilderVisitorException(e);
            }
        }

        @Override
        public void close() throws IOException {
            for (IndexReader indexReader : this.term2IndexReader.values()) {
                indexReader.close();
            }
            this.term2IndexReader.clear();
        }
    }
}

