/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.mg4j.util;

import it.unimi.dsi.fastutil.ints.Int2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.AbstractLongList;
import it.unimi.dsi.io.InputBitStream;
import java.io.IOException;

public class SemiExternalOffsetList
extends AbstractLongList {
    public static final int CACHE_MAX_SIZE = 1024;
    private final long[] position;
    private final long[] startValue;
    private final InputBitStream ibs;
    private final int offsetStep;
    private final int numOffsets;
    private Int2LongLinkedOpenHashMap cache;

    public SemiExternalOffsetList(InputBitStream offsetRawData, int offsetStep, int numOffsets) throws IOException {
        int slots = (numOffsets + offsetStep - 1) / offsetStep;
        this.position = new long[slots];
        this.startValue = new long[slots];
        this.offsetStep = offsetStep;
        this.numOffsets = numOffsets;
        this.ibs = offsetRawData;
        this.cache = new Int2LongLinkedOpenHashMap();
        this.cache.defaultReturnValue(-1L);
        this.prepareRandomAccess(numOffsets);
    }

    private void prepareRandomAccess(int numOffsets) throws IOException {
        long offset = 0L;
        this.ibs.position(0L);
        int k = 0;
        int slotIndex = 0;
        int i = numOffsets;
        while (i-- != 0) {
            offset += this.ibs.readLongGamma();
            if (k-- != 0) continue;
            k = this.offsetStep - 1;
            this.startValue[slotIndex] = offset;
            this.position[slotIndex] = this.ibs.readBits();
            ++slotIndex;
        }
    }

    public final long getLong(int index) {
        if (index < 0 || index >= this.numOffsets) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        long cached = this.cache.getAndMoveToLast(index);
        if (cached != -1L) {
            return cached;
        }
        int slotNumber = index / this.offsetStep;
        int k = index % this.offsetStep;
        long value = this.startValue[slotNumber];
        if (k != 0) {
            try {
                this.ibs.position(this.position[slotNumber]);
                int i = k;
                while (i-- != 0) {
                    long diff = this.ibs.readLongGamma();
                    value += diff;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.cache.size() >= 1024) {
            this.cache.removeFirstLong();
        }
        this.cache.put(index, value);
        return value;
    }

    public int size() {
        return this.numOffsets;
    }
}

