/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.bits.SelectZero;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SimpleSelectZero
implements SelectZero {
    private static final long serialVersionUID = 1L;
    private static final int MAX_ONES_PER_INVENTORY = 8192;
    private static final int MAX_LOG2_LONGWORDS_PER_SUBINVENTORY = 3;
    private static final int MAX_SPAN = 65536;
    private final BitVector bitVector;
    private final long numOnes;
    private final int numWords;
    private transient long[] bits;
    private final long[] inventory;
    private final int log2OnesPerInventory;
    private final int onesPerInventory;
    private final int onesPerInventoryMask;
    private final long[] subinventory;
    private transient LongBigList subinventory16;
    private final int log2LongwordsPerSubinventory;
    private final int log2OnesPerSub64;
    private final int onesPerSub64;
    private final int log2OnesPerSub16;
    private final int onesPerSub16;
    private final int onesPerSub16Mask;
    private final long[] exactSpill;

    public SimpleSelectZero(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public SimpleSelectZero(BitVector bitVector) {
        this.bitVector = bitVector;
        this.bits = bitVector.bits();
        long length = bitVector.length();
        this.numWords = LongArrayBitVector.words((long)length);
        long d = 0L;
        int i = this.numWords;
        while (i-- != 0) {
            d += (long)Long.bitCount(this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.log2OnesPerInventory = Fast.mostSignificantBit((int)(length == 0L ? 1 : (int)((d * 8192L + length - 1L) / length)));
        this.onesPerInventory = 1 << this.log2OnesPerInventory;
        this.onesPerInventoryMask = this.onesPerInventory - 1;
        int inventorySize = (int)((d + (long)this.onesPerInventory - 1L) / (long)this.onesPerInventory);
        this.inventory = new long[inventorySize + 1];
        int numWords = this.numWords;
        long[] bits = this.bits;
        long[] inventory = this.inventory;
        int log2OnesPerInventory = this.log2OnesPerInventory;
        int onesPerInventoryMask = this.onesPerInventoryMask;
        d = 0L;
        for (int i2 = 0; i2 < numWords; ++i2) {
            for (int j = 0; j < 64 && LongArrayBitVector.bits((int)i2) + (long)j < length; ++j) {
                if (((bits[i2] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << j) == 0L) continue;
                if ((d & (long)onesPerInventoryMask) == 0L) {
                    inventory[(int)(d >>> log2OnesPerInventory)] = LongArrayBitVector.bits((int)i2) + (long)j;
                }
                ++d;
            }
        }
        this.numOnes = d;
        inventory[inventorySize] = length;
        this.log2LongwordsPerSubinventory = Math.min(3, Math.max(0, log2OnesPerInventory - 2));
        this.log2OnesPerSub64 = Math.max(0, log2OnesPerInventory - this.log2LongwordsPerSubinventory);
        this.log2OnesPerSub16 = Math.max(0, this.log2OnesPerSub64 - 2);
        this.onesPerSub64 = 1 << this.log2OnesPerSub64;
        this.onesPerSub16 = 1 << this.log2OnesPerSub16;
        this.onesPerSub16Mask = this.onesPerSub16 - 1;
        long numOnes = this.numOnes;
        int onesPerInventory = this.onesPerInventory;
        int onesPerSub16 = this.onesPerSub16;
        int log2OnesPerSub16 = this.log2OnesPerSub16;
        int onesPerSub64 = this.onesPerSub64;
        if (onesPerInventory > 1) {
            d = 0L;
            long diff16 = 0L;
            long start = 0L;
            long span = 0L;
            int spilled = 0;
            int inventoryIndex = 0;
            for (int i3 = 0; i3 < numWords; ++i3) {
                for (int j = 0; j < 64 && LongArrayBitVector.bits((int)i3) + (long)j < length; ++j) {
                    if (((bits[i3] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << j) == 0L) continue;
                    if ((d & (long)onesPerInventoryMask) == 0L) {
                        inventoryIndex = (int)(d >>> log2OnesPerInventory);
                        start = inventory[inventoryIndex];
                        span = inventory[inventoryIndex + 1] - start;
                        int ones = (int)Math.min(numOnes - d, (long)onesPerInventory);
                        diff16 += (long)Math.max(4, ones + onesPerSub16 - 1 >>> log2OnesPerSub16);
                        if (span >= 65536L && onesPerSub64 > 1) {
                            spilled += ones;
                        }
                    }
                    ++d;
                }
            }
            int subinventorySize = (int)(diff16 + 3L >> 2);
            int exactSpillSize = spilled;
            this.subinventory = new long[subinventorySize];
            this.exactSpill = new long[exactSpillSize];
            this.subinventory16 = LongArrayBitVector.wrap((long[])this.subinventory).asLongBigList(16);
            int offset = 0;
            spilled = 0;
            d = 0L;
            int onesPerSub16Mask = this.onesPerSub16Mask;
            int log2LongwordsPerSubinventory = this.log2LongwordsPerSubinventory;
            long[] subinventory = this.subinventory;
            LongBigList subinventory16 = this.subinventory16;
            for (int i4 = 0; i4 < numWords; ++i4) {
                for (int j = 0; j < 64 && LongArrayBitVector.bits((int)i4) + (long)j < length; ++j) {
                    if (((bits[i4] ^ 0xFFFFFFFFFFFFFFFFL) & 1L << j) == 0L) continue;
                    if ((d & (long)onesPerInventoryMask) == 0L) {
                        inventoryIndex = (int)(d >>> log2OnesPerInventory);
                        start = inventory[inventoryIndex];
                        span = inventory[inventoryIndex + 1] - start;
                        offset = 0;
                    }
                    if (span < 65536L) {
                        assert (LongArrayBitVector.bits((int)i4) + (long)j - start <= 65536L);
                        if ((d & (long)onesPerSub16Mask) == 0L) {
                            subinventory16.set((long)((inventoryIndex << log2LongwordsPerSubinventory + 2) + offset++), LongArrayBitVector.bits((int)i4) + (long)j - start);
                        }
                    } else {
                        assert (onesPerSub64 > 1);
                        if ((d & (long)onesPerInventoryMask) == 0L) {
                            int n = inventoryIndex;
                            inventory[n] = inventory[n] | Long.MIN_VALUE;
                            subinventory[inventoryIndex << log2LongwordsPerSubinventory] = spilled;
                        }
                        this.exactSpill[spilled++] = LongArrayBitVector.bits((int)i4) + (long)j;
                    }
                    ++d;
                }
            }
        } else {
            this.exactSpill = LongArrays.EMPTY_ARRAY;
            this.subinventory = LongArrays.EMPTY_ARRAY;
            this.subinventory16 = null;
        }
    }

    @Override
    public long selectZero(long rank) {
        int bitCount;
        int residual;
        assert (rank >= 0L);
        assert (rank < this.numOnes);
        int inventoryIndex = (int)(rank >>> this.log2OnesPerInventory);
        long inventoryRank = this.inventory[inventoryIndex];
        int subrank = (int)(rank & (long)this.onesPerInventoryMask);
        if (subrank == 0) {
            return inventoryRank & Long.MAX_VALUE;
        }
        if (inventoryRank < 0L) {
            assert (this.onesPerSub64 > 1);
            return this.exactSpill[(int)(this.subinventory[inventoryIndex << this.log2LongwordsPerSubinventory] + (long)subrank)];
        }
        int index16 = (inventoryIndex << this.log2LongwordsPerSubinventory + 2) + (subrank >>> this.log2OnesPerSub16);
        long start = inventoryRank + (this.subinventory[index16 >>> 2] >>> ((index16 & 3) << 4) & 0xFFFFL);
        if (residual == 0) {
            return start;
        }
        long[] bits = this.bits;
        int wordIndex = LongArrayBitVector.word((long)start);
        long word = (bits[wordIndex] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << (int)start;
        for (residual = subrank & this.onesPerSub16Mask; residual >= (bitCount = Long.bitCount(word)); residual -= bitCount) {
            word = bits[++wordIndex] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return LongArrayBitVector.bits((int)wordIndex) + (long)Fast.select((long)word, (int)residual);
    }

    public long[] selectZero(long rank, long[] dest, int offset, int length) {
        long s;
        assert (rank >= 0L);
        assert (rank < this.numOnes);
        assert (offset >= 0);
        assert (dest != null);
        assert (offset < dest.length);
        assert (length >= 0);
        assert (offset + length <= dest.length);
        dest[offset] = s = this.selectZero(rank);
        int curr = LongArrayBitVector.word((long)s);
        long[] bits = this.bits;
        long window = (bits[curr] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << (int)s;
        window &= window - 1L;
        for (int i = 1; i < length; ++i) {
            while (window == 0L) {
                window = bits[++curr] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            dest[++offset] = LongArrayBitVector.bits((int)curr) + (long)Long.numberOfTrailingZeros(window);
            window &= window - 1L;
        }
        return dest;
    }

    public long[] selectZero(long rank, long[] dest) {
        assert (rank >= 0L);
        assert (rank < this.numOnes);
        assert (dest != null);
        assert (dest.length > 0);
        return this.selectZero(rank, dest, 0, dest.length);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.subinventory16 = LongArrayBitVector.wrap((long[])this.subinventory).asLongBigList(16);
        this.bits = this.bitVector.bits();
    }

    @Override
    public long numBits() {
        return LongArrayBitVector.bits((int)this.inventory.length) + LongArrayBitVector.bits((int)this.subinventory.length) + LongArrayBitVector.bits((int)this.exactSpill.length);
    }

    @Override
    public BitVector bitVector() {
        return this.bitVector;
    }
}

