/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.bits.TransformationStrategy;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import it.unimi.dsi.fastutil.longs.LongBigArrayBigList;
import it.unimi.dsi.fastutil.objects.AbstractObject2LongFunction;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.NullOutputStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VLPaCoTrieDistributor<T>
extends AbstractObject2LongFunction<T>
implements Size64 {
    private static final Logger LOGGER = LoggerFactory.getLogger(VLPaCoTrieDistributor.class);
    private static final long serialVersionUID = 2L;
    private static final boolean DEBUG = false;
    private static final boolean DDEBUG = false;
    private static final int MAX_PREFIX = 0x7FFFFFFE;
    private final byte[] trie;
    private final long numberOfLeaves;
    private final TransformationStrategy<? super T> transformationStrategy;
    public LongBigArrayBigList offset;

    public VLPaCoTrieDistributor(Iterable<? extends T> elements, long size, int bucketSize, TransformationStrategy<? super T> transformationStrategy) throws IOException {
        this.transformationStrategy = transformationStrategy;
        ProgressLogger pl = new ProgressLogger(LOGGER);
        pl.displayLocalSpeed = true;
        pl.displayFreeMemory = true;
        pl.itemsName = "keys";
        PartialTrie<T> immutableBinaryTrie = new PartialTrie<T>(elements, size, bucketSize, transformationStrategy, pl);
        FastByteArrayOutputStream fbStream = new FastByteArrayOutputStream();
        OutputBitStream trie = new OutputBitStream((OutputStream)fbStream, 0);
        pl.expectedUpdates = immutableBinaryTrie.size;
        pl.start((CharSequence)"Converting to bitstream...");
        this.numberOfLeaves = immutableBinaryTrie.toStream(trie, pl);
        pl.done();
        this.offset = immutableBinaryTrie.offset;
        LOGGER.debug("Trie bit size: " + trie.writtenBits());
        trie.flush();
        fbStream.trim();
        this.trie = fbStream.array;
    }

    public long getLong(Object o) {
        if (this.numberOfLeaves == 0L) {
            return 0L;
        }
        try {
            BitVector v = this.transformationStrategy.toBitVector(o).fast();
            long length = v.length();
            InputBitStream trie = new InputBitStream(this.trie);
            long pos = 0L;
            long leavesOnTheLeft = 0L;
            long leaves = this.numberOfLeaves;
            while (true) {
                long skip = trie.readLongDelta();
                int pathLength = trie.readDelta();
                long t = 0L;
                long xor = 0L;
                long readBits = trie.readBits();
                int numWords = LongArrayBitVector.words((long)pathLength);
                for (int i = 0; i < numWords; ++i) {
                    int size = Math.min(64, pathLength - i * 64);
                    t = trie.readLong(size);
                    if ((xor = v.getLong(pos, Math.min(length, pos += (long)size)) ^ t) != 0L || pos >= length) break;
                }
                if (xor != 0L || pos > length) {
                    if ((xor & -xor & t) != 0L) {
                        return leavesOnTheLeft;
                    }
                    if (skip == 0L) {
                        return leavesOnTheLeft + 1L;
                    }
                    trie.skip((long)pathLength - (trie.readBits() - readBits));
                    trie.readDelta();
                    return leavesOnTheLeft + leaves;
                }
                if (skip == 0L) {
                    return leavesOnTheLeft;
                }
                int missing = trie.readDelta();
                if ((pos += (long)missing) >= v.length()) {
                    return leavesOnTheLeft;
                }
                long leftSubtrieLeaves = trie.readLongDelta();
                if (v.getBoolean(pos++)) {
                    trie.skip(skip);
                    leavesOnTheLeft += leftSubtrieLeaves;
                    leaves -= leftSubtrieLeaves;
                    continue;
                }
                leaves = leftSubtrieLeaves;
            }
        }
        catch (IOException cantHappen) {
            throw new RuntimeException(cantHappen);
        }
    }

    private void recToString(InputBitStream trie, MutableString printPrefix, MutableString result, MutableString path, int level) throws IOException {
        long skip = trie.readLongDelta();
        result.append(printPrefix).append('(').append(level).append(')');
        int pathLength = trie.readDelta();
        LongArrayBitVector p = LongArrayBitVector.getInstance((long)pathLength);
        int numWords = LongArrayBitVector.words((long)pathLength);
        for (int i = 0; i < numWords; ++i) {
            int size = Math.min(64, pathLength - i * 64);
            p.append(trie.readLong(size), size);
        }
        if (skip == 0L) {
            return;
        }
        int missing = trie.readDelta();
        path.append((Object)p);
        result.append(" path:").append((Object)p);
        while (missing-- != 0) {
            result.append('*');
        }
        result.append('\n');
        trie.readDelta();
        path.append('0');
        this.recToString(trie, printPrefix.append('\t').append("0 => "), result, path, level + 1);
        path.charAt(path.length() - 1, '1');
        this.recToString(trie, printPrefix.replace(printPrefix.length() - 5, printPrefix.length(), "1 => "), result, path, level + 1);
        path.delete(path.length() - 1, path.length());
        printPrefix.delete(printPrefix.length() - 6, printPrefix.length());
        path.delete(path.length() - pathLength, path.length());
    }

    public long numBits() {
        return (long)this.trie.length * 8L + this.transformationStrategy.numBits();
    }

    public boolean containsKey(Object o) {
        return true;
    }

    public long size64() {
        return this.numberOfLeaves;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(this.numberOfLeaves, Integer.MAX_VALUE);
    }

    private static final class PartialTrie<T> {
        private static final boolean ASSERTS = false;
        protected final Node root;
        protected final long size;
        protected final LongBigArrayBigList offset;
        protected long gain;
        private final OutputBitStream bitCount = new OutputBitStream((OutputStream)NullOutputStream.getInstance(), 0);

        public PartialTrie(Iterable<? extends T> elements, long size, int bucketSize, TransformationStrategy<? super T> transformationStrategy, ProgressLogger pl) {
            Iterator<T> iterator = elements.iterator();
            LongArrayBitVector curr = LongArrayBitVector.getInstance();
            if (iterator.hasNext()) {
                Node node;
                int pos;
                int prefix;
                pl.start((CharSequence)"Building trie...");
                LongArrayBitVector prev = LongArrayBitVector.copy((BitVector)transformationStrategy.toBitVector(iterator.next()));
                pl.lightUpdate();
                LongArrayBitVector shortest = prev.copy();
                long shortestIndex = 0L;
                LongArrayBitVector prevDelimiter = LongArrayBitVector.getInstance();
                long count = 1L;
                Node root = null;
                long maxLength = prev.length();
                this.offset = new LongBigArrayBigList(size / (long)bucketSize + 1L);
                while (iterator.hasNext()) {
                    curr.replace(transformationStrategy.toBitVector(iterator.next()));
                    pl.lightUpdate();
                    prefix = (int)curr.longestCommonPrefixLength(prev);
                    if ((long)prefix == prev.length() && (long)prefix == curr.length()) {
                        throw new IllegalArgumentException("The input bit vectors are not distinct");
                    }
                    if ((long)prefix == prev.length() || (long)prefix == curr.length()) {
                        throw new IllegalArgumentException("The input bit vectors are not prefix-free");
                    }
                    if (prev.getBoolean(prefix)) {
                        throw new IllegalArgumentException("The input bit vectors are not lexicographically sorted");
                    }
                    if (count % (long)bucketSize == 0L) {
                        if (root == null) {
                            root = new Node(null, null, shortest.copy());
                            prevDelimiter.replace(shortest);
                        } else {
                            prefix = (int)shortest.longestCommonPrefixLength(prevDelimiter);
                            pos = 0;
                            node = root;
                            Node n = null;
                            while (node != null) {
                                long pathLength = node.path.length();
                                if ((long)prefix < pathLength) {
                                    n = new Node(node.left, node.right, node.path.copy((long)(prefix + 1), pathLength));
                                    node.path.length((long)prefix);
                                    node.path.trim();
                                    node.left = n;
                                    node.right = new Node(null, null, shortest.copy((long)(pos + prefix + 1), shortest.length()));
                                    break;
                                }
                                prefix = (int)((long)prefix - (pathLength + 1L));
                                pos = (int)((long)pos + (pathLength + 1L));
                                node = node.right;
                            }
                            prevDelimiter.replace(shortest);
                        }
                        this.offset.add(shortestIndex);
                        shortest.replace(curr);
                        shortestIndex = count;
                    }
                    if (curr.length() < shortest.length()) {
                        shortest.replace(curr);
                        shortestIndex = count;
                    }
                    prev.replace(curr);
                    maxLength = Math.max(maxLength, prev.length());
                    ++count;
                }
                pl.done();
                this.size = count;
                if (this.size <= (long)(bucketSize * 2)) {
                    root = null;
                }
                this.root = root;
                if (root != null) {
                    pl.start((CharSequence)"Reducing paths...");
                    iterator = elements.iterator();
                    Node[] stack = new Node[(int)maxLength];
                    int[] len = new int[(int)maxLength];
                    stack[0] = root;
                    int depth = 0;
                    boolean first = true;
                    while (iterator.hasNext()) {
                        curr.replace(transformationStrategy.toBitVector(iterator.next()));
                        pl.lightUpdate();
                        if (!first) {
                            prefix = (int)prev.longestCommonPrefixLength(curr);
                            while (depth > 0 && len[depth] > prefix) {
                                --depth;
                            }
                        } else {
                            first = false;
                        }
                        node = stack[depth];
                        pos = len[depth];
                        while (true) {
                            LongArrayBitVector path = node.path;
                            prefix = (int)curr.subVector((long)pos).longestCommonPrefixLength((BitVector)path);
                            if ((long)prefix < path.length()) {
                                if (path.getBoolean(prefix)) {
                                    node.prefixLeft = prefix;
                                    break;
                                }
                                if (node.prefixRight != 0x7FFFFFFE) break;
                                node.prefixRight = prefix;
                                break;
                            }
                            if ((long)(pos = (int)((long)pos + (path.length() + 1L))) > curr.length()) break;
                            node = curr.getBoolean(pos - 1) ? node.right : node.left;
                            len[++depth] = pos;
                            stack[depth] = node;
                        }
                        prev.replace(curr);
                    }
                    pl.done();
                }
            } else {
                this.root = null;
                this.size = 0L;
                this.offset = null;
            }
        }

        public long toStream(OutputBitStream obs, ProgressLogger pl) throws IOException {
            long result = this.toStream(this.root, obs, pl);
            LOGGER.debug("Gain: " + this.gain);
            return result;
        }

        private long toStream(Node n, OutputBitStream obs, ProgressLogger pl) throws IOException {
            if (n == null) {
                return 0L;
            }
            FastByteArrayOutputStream leftStream = new FastByteArrayOutputStream();
            OutputBitStream left = new OutputBitStream((OutputStream)leftStream, 0);
            long leavesLeft = this.toStream(n.left, left, pl);
            long leftBits = left.writtenBits();
            left.flush();
            FastByteArrayOutputStream rightStream = new FastByteArrayOutputStream();
            OutputBitStream right = new OutputBitStream((OutputStream)rightStream, 0);
            long leavesRight = this.toStream(n.right, right, pl);
            long rightBits = right.writtenBits();
            right.flush();
            pl.lightUpdate();
            obs.writeLongDelta(n.isLeaf() ? 0L : leftBits);
            int pathLength = (int)Math.min(n.path.length(), (long)(Math.max(n.prefixLeft, n.prefixRight) + 1));
            int missing = (int)(n.path.length() - (long)pathLength);
            this.gain += (long)missing;
            this.gain += (long)(this.bitCount.writeLongDelta(n.path.length()) - obs.writeDelta(pathLength));
            if (pathLength > 0) {
                for (int i = 0; i < pathLength; i += 64) {
                    obs.writeLong(n.path.getLong((long)i, (long)Math.min(i + 64, pathLength)), Math.min(64, pathLength - i));
                }
            }
            if (n.isLeaf()) {
                return 1L;
            }
            n.right = null;
            n.left = null;
            this.gain -= (long)obs.writeDelta(missing);
            obs.writeLongDelta(leavesLeft);
            obs.write(leftStream.array, leftBits);
            obs.write(rightStream.array, rightBits);
            return leavesLeft + leavesRight;
        }

        private void recToString(Node n, MutableString printPrefix, MutableString result, MutableString path, int level) {
            if (n == null) {
                return;
            }
            result.append(printPrefix).append('(').append(level).append(')');
            if (n.path != null) {
                path.append((Object)n.path);
                result.append(" path:").append((Object)n.path);
            }
            result.append('\n');
            path.append('0');
            this.recToString(n.left, printPrefix.append('\t').append("0 => "), result, path, level + 1);
            path.charAt(path.length() - 1, '1');
            this.recToString(n.right, printPrefix.replace(printPrefix.length() - 5, printPrefix.length(), "1 => "), result, path, level + 1);
            path.delete(path.length() - 1, path.length());
            printPrefix.delete(printPrefix.length() - 6, printPrefix.length());
            path.delete((int)((long)path.length() - n.path.length()), path.length());
        }

        public String toString() {
            MutableString s = new MutableString();
            this.recToString(this.root, new MutableString(), s, new MutableString(), 0);
            return s.toString();
        }

        protected static class Node {
            public Node left;
            public Node right;
            public final LongArrayBitVector path;
            public int prefixLeft;
            public int prefixRight;

            public Node(Node left, Node right, LongArrayBitVector path) {
                this.left = left;
                this.right = right;
                this.path = path;
                this.prefixRight = 0x7FFFFFFE;
                this.prefixLeft = 0x7FFFFFFE;
            }

            public boolean isLeaf() {
                return this.right == null && this.left == null;
            }

            public String toString() {
                return "[" + this.path + "]";
            }
        }
    }
}

