/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.solve;

import it.unimi.dsi.Util;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.sux4j.mph.Hashes;
import it.unimi.dsi.sux4j.mph.codec.Codec;
import it.unimi.dsi.sux4j.mph.solve.Modulo2System;
import it.unimi.dsi.sux4j.mph.solve.Modulo3System;
import it.unimi.dsi.sux4j.mph.solve.Orient3Hypergraph;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Linear3SystemSolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(Linear3SystemSolver.class);
    private static final boolean ASSERTS = false;
    private static final boolean DEBUG = false;
    private final int numVertices;
    private final int numEdges;
    private final int[] edge;
    private final int[] stack;
    private final int[] d;
    private boolean neverUsed;
    private int top;
    private final int[][] edge2Vertex;
    private final boolean[] peeled;
    public long[] solution;
    public int unsolvable;
    public int unorientable;
    public long numPeeled;

    public Linear3SystemSolver(int numVariables, int numEquations) {
        this.numVertices = numVariables;
        this.numEdges = numEquations;
        this.peeled = new boolean[numEquations];
        this.edge = new int[numVariables];
        this.edge2Vertex = new int[3][numEquations];
        this.stack = new int[numVariables];
        this.d = new int[numVariables];
        this.neverUsed = true;
    }

    private final void cleanUpIfNecessary() {
        if (!this.neverUsed) {
            Arrays.fill(this.d, 0);
            Arrays.fill(this.edge, 0);
            Arrays.fill(this.peeled, false);
            this.unsolvable = 0;
            this.unorientable = 0;
        }
        this.neverUsed = false;
    }

    private final void xorEdge(int e, int hinge) {
        if (hinge != this.edge2Vertex[0][e]) {
            int n = this.edge2Vertex[0][e];
            this.edge[n] = this.edge[n] ^ e;
        }
        if (hinge != this.edge2Vertex[1][e]) {
            int n = this.edge2Vertex[1][e];
            this.edge[n] = this.edge[n] ^ e;
        }
        if (hinge != this.edge2Vertex[2][e]) {
            int n = this.edge2Vertex[2][e];
            this.edge[n] = this.edge[n] ^ e;
        }
    }

    private final void xorEdge(int e) {
        int n = this.edge2Vertex[0][e];
        this.edge[n] = this.edge[n] ^ e;
        int n2 = this.edge2Vertex[1][e];
        this.edge[n2] = this.edge[n2] ^ e;
        int n3 = this.edge2Vertex[2][e];
        this.edge[n3] = this.edge[n3] ^ e;
    }

    public static void signatureToEquation(long[] signature, long seed, int numVariables, int[] e) {
        long[] hash = new long[3];
        Hashes.spooky4(signature[0], signature[1], seed, hash);
        int shift = Long.numberOfLeadingZeros(numVariables);
        long mask = (1L << shift) - 1L;
        e[0] = (int)((hash[0] & mask) * (long)numVariables >>> shift);
        e[1] = (int)((hash[1] & mask) * (long)numVariables >>> shift);
        e[2] = (int)((hash[2] & mask) * (long)numVariables >>> shift);
    }

    private String edge2String(int e) {
        return "<" + this.edge2Vertex[0][e] + "," + this.edge2Vertex[1][e] + "," + this.edge2Vertex[2][e] + ">";
    }

    public boolean generateAndSolve(Iterable<long[]> iterable, long seed, LongBigList valueList) {
        int[] d = this.d;
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        this.cleanUpIfNecessary();
        int[] e = new int[3];
        Iterator<long[]> iterator = iterable.iterator();
        for (int i = 0; i < this.numEdges; ++i) {
            Linear3SystemSolver.signatureToEquation(iterator.next(), seed, this.numVertices, e);
            edge2Vertex0[i] = e[0];
            d[edge2Vertex0[i]] = d[edge2Vertex0[i]] + 1;
            edge2Vertex1[i] = e[1];
            d[edge2Vertex1[i]] = d[edge2Vertex1[i]] + 1;
            edge2Vertex2[i] = e[2];
            d[edge2Vertex2[i]] = d[edge2Vertex2[i]] + 1;
            this.xorEdge(i);
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("This " + Linear3SystemSolver.class.getSimpleName() + " has " + this.numEdges + " edges, but the provided iterator returns more");
        }
        return this.solve(valueList);
    }

    private boolean sort() {
        int[] d = this.d;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Peeling hypergraph (" + this.numVertices + " vertices, " + this.numEdges + " edges)...");
        }
        this.top = 0;
        for (int x = 0; x < this.numVertices; ++x) {
            if (d[x] != 1) continue;
            this.peel(x);
        }
        if (this.top == this.numEdges) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Peeling completed.");
            }
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Peeled " + this.top + " edges out of " + this.numEdges + ".");
        }
        return false;
    }

    private void peel(int x) {
        int[] edge = this.edge;
        int[] stack = this.stack;
        int[] d = this.d;
        int pos = this.top;
        int curr = this.top;
        stack[this.top++] = x;
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        while (pos < this.top) {
            int v;
            if (d[v = stack[pos++]] != 1) continue;
            stack[curr++] = v;
            int e = edge[v];
            this.peeled[e] = true;
            this.xorEdge(e, v);
            int a = edge2Vertex0[e];
            int b = edge2Vertex1[e];
            int c = edge2Vertex2[e];
            assert (a == v || b == v || c == v);
            int n = a;
            d[n] = d[n] - 1;
            int n2 = b;
            d[n2] = d[n2] - 1;
            int n3 = c;
            d[n3] = d[n3] - 1;
            if (d[a] == 1) {
                stack[this.top++] = a;
            }
            if (d[b] == 1 && b != a) {
                stack[this.top++] = b;
            }
            if (d[c] != 1 || c == a || c == b) continue;
            stack[this.top++] = c;
        }
        this.top = curr;
    }

    private boolean solve(LongBigList valueList) {
        boolean peelingCompleted = this.sort();
        this.numPeeled = this.top;
        long[] solution = this.solution = new long[this.numVertices];
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        int[] edge = this.edge;
        int[] d = this.d;
        if (valueList != null) {
            if (!peelingCompleted) {
                int[][] vertex2Edge = new int[d.length][];
                int i = vertex2Edge.length;
                while (i-- != 0) {
                    vertex2Edge[i] = new int[d[i]];
                }
                int[] p = new int[d.length];
                long[] c = new long[d.length - this.top];
                Arrays.fill(d, 0);
                int j = 0;
                for (int i2 = 0; i2 < this.numEdges; ++i2) {
                    int v2;
                    int v1;
                    int v0;
                    if (this.peeled[i2]) continue;
                    int n = v0 = edge2Vertex0[i2];
                    int n2 = p[n];
                    p[n] = n2 + 1;
                    vertex2Edge[v0][n2] = j;
                    int n3 = v1 = edge2Vertex1[i2];
                    int n4 = p[n3];
                    p[n3] = n4 + 1;
                    vertex2Edge[v1][n4] = j;
                    int n5 = v2 = edge2Vertex2[i2];
                    int n6 = p[n5];
                    p[n5] = n6 + 1;
                    vertex2Edge[v2][n6] = j;
                    c[j++] = valueList.getLong((long)i2);
                }
                if (!Modulo2System.lazyGaussianElimination(vertex2Edge, c, Util.identity((int)this.numVertices), solution)) {
                    ++this.unsolvable;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("System is unsolvable");
                    }
                    return false;
                }
            }
            while (this.top > 0) {
                int x = this.stack[--this.top];
                int e = edge[x];
                solution[x] = valueList.getLong((long)e);
                if (x != edge2Vertex0[e]) {
                    int n = x;
                    solution[n] = solution[n] ^ solution[edge2Vertex0[e]];
                }
                if (x != edge2Vertex1[e]) {
                    int n = x;
                    solution[n] = solution[n] ^ solution[edge2Vertex1[e]];
                }
                if (x != edge2Vertex2[e]) {
                    int n = x;
                    solution[n] = solution[n] ^ solution[edge2Vertex2[e]];
                }
                assert (valueList.getLong((long)e) == (solution[edge2Vertex0[e]] ^ solution[edge2Vertex1[e]] ^ solution[edge2Vertex2[e]])) : this.edge2String(e) + ": " + valueList.getLong((long)e) + " != " + (solution[edge2Vertex0[e]] ^ solution[edge2Vertex1[e]] ^ solution[edge2Vertex2[e]]);
            }
            return true;
        }
        if (!peelingCompleted) {
            int i;
            int nonPeeled = this.numEdges - this.top;
            int[] remEdge2Vertex0 = new int[nonPeeled];
            int[] remEdge2Vertex1 = new int[nonPeeled];
            int[] remEdge2Vertex2 = new int[nonPeeled];
            int[][] edges = new int[d.length][];
            boolean[] peeled = this.peeled;
            int i3 = edges.length;
            while (i3-- != 0) {
                edges[i3] = new int[d[i3]];
            }
            Arrays.fill(d, 0);
            int j = 0;
            for (i3 = 0; i3 < this.numEdges; ++i3) {
                int v2;
                int v1;
                int v0;
                if (peeled[i3]) continue;
                remEdge2Vertex0[j] = v0 = edge2Vertex0[i3];
                int n = v0;
                int n7 = d[n];
                d[n] = n7 + 1;
                edges[v0][n7] = j;
                remEdge2Vertex1[j] = v1 = edge2Vertex1[i3];
                int n8 = v1;
                int n9 = d[n8];
                d[n8] = n9 + 1;
                edges[v1][n9] = j;
                remEdge2Vertex2[j] = v2 = edge2Vertex2[i3];
                int n10 = v2;
                int n11 = d[n10];
                d[n10] = n11 + 1;
                edges[v2][n11] = j++;
            }
            int[] hinge = new int[nonPeeled];
            if (!Orient3Hypergraph.orient(edges, d, remEdge2Vertex0, remEdge2Vertex1, remEdge2Vertex2, hinge)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Hypergraph cannot be oriented");
                }
                ++this.unorientable;
                return false;
            }
            long[] c = new long[nonPeeled];
            for (i = 0; i < nonPeeled; ++i) {
                int h = hinge[i];
                long l = h == remEdge2Vertex0[i] ? 0L : (c[i] = h == remEdge2Vertex1[i] ? 1L : 2L);
                assert (c[i] != 0L || remEdge2Vertex0[i] == hinge[i]);
                assert (c[i] != 1L || remEdge2Vertex1[i] == hinge[i]);
                assert (c[i] != 2L || remEdge2Vertex2[i] == hinge[i]);
            }
            if (!Modulo3System.lazyGaussianElimination(edges, c, hinge, solution)) {
                ++this.unsolvable;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("System is unsolvable");
                }
                return false;
            }
            for (i = 0; i < nonPeeled; ++i) {
                if (solution[hinge[i]] != 0L) continue;
                solution[hinge[i]] = 3L;
            }
        }
        while (this.top > 0) {
            int v;
            int e = edge[v];
            int k = (v = this.stack[--this.top]) == edge2Vertex0[e] ? 0 : (v == edge2Vertex1[e] ? 1 : 2);
            assert (v == edge2Vertex0[e] || v == edge2Vertex1[e] || v == edge2Vertex2[e]) : v + " not in " + this.edge2String(e);
            assert (solution[v] == 0L);
            long s = 0L;
            if (v != edge2Vertex0[e]) {
                s += solution[edge2Vertex0[e]];
            }
            if (v != edge2Vertex1[e]) {
                s += solution[edge2Vertex1[e]];
            }
            if (v != edge2Vertex2[e]) {
                s += solution[edge2Vertex2[e]];
            }
            long l = solution[v] = (s = ((long)k - s + 9L) % 3L) == 0L ? 3L : s;
            assert ((long)k == (solution[edge2Vertex0[e]] + solution[edge2Vertex1[e]] + solution[edge2Vertex2[e]]) % 3L) : this.edge2String(e) + ": " + k + " != " + (solution[edge2Vertex0[e]] + solution[edge2Vertex1[e]] + solution[edge2Vertex2[e]]) % 3L;
        }
        return true;
    }

    public boolean generateAndSolve(Iterable<long[]> signatures, long seed, LongBigList valueList, Codec.Coder coder, int m, int w) {
        return this.generateAndSolve(signatures, seed, valueList, coder, m, w);
    }

    public boolean generateAndSolve(Iterable<long[]> signatures, long seed, LongBigList valueList, Codec.Coder coder, int m, int w, boolean peelOnly) {
        int[] d = this.d;
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        this.cleanUpIfNecessary();
        int[] e = new int[3];
        LongArrayBitVector convertedValues = LongArrayBitVector.getInstance();
        int j = 0;
        int i = 0;
        Iterator<long[]> iterator = signatures.iterator();
        while (iterator.hasNext()) {
            long[] signature = iterator.next();
            Linear3SystemSolver.signatureToEquation(signature, seed, m, e);
            long v = valueList.getLong((long)i++);
            long convertedLong = coder.encode(v);
            int lenCodeword = coder.codewordLength(v);
            if (convertedLong == -1L) {
                convertedValues.append(coder.escape(), lenCodeword - coder.escapedSymbolLength());
                convertedValues.append(Long.reverse(v) >>> -coder.escapedSymbolLength(), coder.escapedSymbolLength());
            } else {
                convertedValues.append(convertedLong, lenCodeword);
            }
            for (int l = 0; l < lenCodeword; ++l) {
                edge2Vertex0[j] = e[0] + w - 1 - l;
                d[edge2Vertex0[j]] = d[edge2Vertex0[j]] + 1;
                edge2Vertex1[j] = e[1] + w - 1 - l;
                d[edge2Vertex1[j]] = d[edge2Vertex1[j]] + 1;
                edge2Vertex2[j] = e[2] + w - 1 - l;
                d[edge2Vertex2[j]] = d[edge2Vertex2[j]] + 1;
                this.xorEdge(j++);
            }
        }
        if (iterator.hasNext()) {
            throw new IllegalStateException("This " + Linear3SystemSolver.class.getSimpleName() + " has " + this.numEdges + " edges, but the provided iterator returns more");
        }
        return this.solve(convertedValues, peelOnly);
    }

    private boolean solve(LongArrayBitVector codedValues, boolean peelOnly) {
        boolean peelingCompleted = this.sort();
        if (peelOnly && !peelingCompleted) {
            return false;
        }
        this.numPeeled = this.top;
        this.solution = new long[this.numVertices];
        int maxNumVar = this.numVertices;
        int[] edge2Vertex0 = this.edge2Vertex[0];
        int[] edge2Vertex1 = this.edge2Vertex[1];
        int[] edge2Vertex2 = this.edge2Vertex[2];
        int[] edge = this.edge;
        int[] d = this.d;
        int j = 0;
        if (!peelingCompleted) {
            int[][] vertex2Edge = new int[maxNumVar][];
            Arrays.fill((Object[])vertex2Edge, new int[0]);
            for (int i = 0; i < maxNumVar; ++i) {
                vertex2Edge[i] = new int[d[i]];
            }
            int[] p = new int[maxNumVar];
            long[] c = new long[this.numEdges];
            for (int i = 0; i < this.numEdges; ++i) {
                if (this.peeled[i]) continue;
                int v0 = edge2Vertex0[i];
                int v1 = edge2Vertex1[i];
                int v2 = edge2Vertex2[i];
                int n = v0;
                int n2 = p[n];
                p[n] = n2 + 1;
                vertex2Edge[v0][n2] = j;
                int n3 = v1;
                int n4 = p[n3];
                p[n3] = n4 + 1;
                vertex2Edge[v1][n4] = j;
                int n5 = v2;
                int n6 = p[n5];
                p[n5] = n6 + 1;
                vertex2Edge[v2][n6] = j;
                c[j++] = codedValues.getBoolean(i) ? 1L : 0L;
            }
            if (!Modulo2System.lazyGaussianElimination(vertex2Edge, (long[])c.clone(), Util.identity((int)maxNumVar), this.solution)) {
                ++this.unsolvable;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("System is unsolvable");
                }
                return false;
            }
        }
        while (this.top > 0) {
            int sol;
            int x;
            int e;
            long l = this.solution[x] = codedValues.getBoolean(e = edge[x = this.stack[--this.top]]) ? 1L : 0L;
            if (x != edge2Vertex0[e]) {
                int n = x;
                this.solution[n] = this.solution[n] ^ this.solution[edge2Vertex0[e]];
            }
            if (x != edge2Vertex1[e]) {
                int n = x;
                this.solution[n] = this.solution[n] ^ this.solution[edge2Vertex1[e]];
            }
            if (x != edge2Vertex2[e]) {
                int n = x;
                this.solution[n] = this.solution[n] ^ this.solution[edge2Vertex2[e]];
            }
            int n = sol = codedValues.getBoolean(e) ? 1 : 0;
            assert ((long)sol == (this.solution[edge2Vertex0[e]] ^ this.solution[edge2Vertex1[e]] ^ this.solution[edge2Vertex2[e]])) : this.edge2String(e) + ": " + codedValues.getBoolean(e) + " != " + (this.solution[edge2Vertex0[e]] ^ this.solution[edge2Vertex1[e]] ^ this.solution[edge2Vertex2[e]]);
        }
        return true;
    }
}

