/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.mph.solve;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;

public class Orient3Hypergraph {
    private static final boolean ASSERTS = false;

    private Orient3Hypergraph() {
    }

    private static void remove(IntArrayList queue, int v, int[] posInQueue) {
        int position = posInQueue[v];
        assert (position < queue.size());
        int last = queue.popInt();
        if (position == queue.size()) {
            return;
        }
        posInQueue[last] = position;
        queue.set(posInQueue[last], last);
    }

    private static void move(IntArrayList[] queue, int[] posInQueue, int v, int queueBefore, int queueAfter) {
        if (queueBefore != queueAfter) {
            Orient3Hypergraph.remove(queue[queueBefore], v, posInQueue);
            posInQueue[v] = queue[queueAfter].size();
            queue[queueAfter].push(v);
        }
    }

    private static void decrease(IntArrayList[] queue, int[] posInQueue, int[] priority, int[] d, int v, int w) {
        assert (priority[v] > 0 || d[v] == 0);
        int queueBefore = Math.min(7, priority[v]);
        if (d[v] == 0) {
            Orient3Hypergraph.remove(queue[queueBefore], v, posInQueue);
        } else {
            if (d[v] == 1) {
                priority[v] = 0;
            } else {
                int n = v;
                priority[n] = priority[n] - 6 / w;
            }
            int queueAfter = Math.min(7, priority[v]);
            Orient3Hypergraph.move(queue, posInQueue, v, queueBefore, queueAfter);
        }
    }

    private static void increase(IntArrayList[] queue, int[] posInQueue, int[] priority, int v, int update) {
        assert (update > 0);
        int queueBefore = Math.min(7, priority[v]);
        int n = v;
        priority[n] = priority[n] + update;
        assert (priority[v] > 0);
        int queueAfter = Math.min(7, priority[v]);
        Orient3Hypergraph.move(queue, posInQueue, v, queueBefore, queueAfter);
    }

    public static boolean orient(int[][] edges, int[] d, int[] vertex0, int[] vertex1, int[] vertex2, int[] hinges) {
        int i;
        int numVertices = d.length;
        int numEdges = vertex0.length;
        int[] weight = new int[numEdges];
        boolean[] isHinge = new boolean[numVertices];
        boolean[] isDone = new boolean[numEdges];
        Arrays.fill(weight, 3);
        IntArrayList[] queue = new IntArrayList[8];
        int i2 = queue.length;
        while (i2-- != 0) {
            queue[i2] = new IntArrayList();
        }
        int[] posInQueue = new int[numVertices];
        int[] priority = new int[numVertices];
        for (i = 0; i < numVertices; ++i) {
            int n = i;
            priority[n] = priority[n] + 2 * d[i];
        }
        for (i = 0; i < d.length; ++i) {
            if (d[i] <= 0) continue;
            IntArrayList q = queue[Math.min(7, priority[i])];
            posInQueue[i] = q.size();
            q.add(i);
        }
        for (int t = 0; t < numEdges; ++t) {
            int e;
            int minPriority;
            for (minPriority = 0; minPriority < 8 && queue[minPriority].isEmpty(); ++minPriority) {
            }
            if (minPriority == 8) {
                return false;
            }
            int hinge = queue[minPriority].popInt();
            int edge = -1;
            int minWeight = Integer.MAX_VALUE;
            int i3 = edges[hinge].length;
            while (i3-- != 0) {
                e = edges[hinge][i3];
                if (isDone[e] || weight[e] >= minWeight) continue;
                edge = e;
                minWeight = weight[e];
            }
            assert (edge != -1);
            if (priority[hinge] > 6) {
                return false;
            }
            hinges[edge] = hinge;
            isHinge[hinge] = true;
            isDone[edge] = true;
            i3 = edges[hinge].length;
            while (i3-- != 0) {
                e = edges[hinge][i3];
                if (isDone[e]) continue;
                int v0 = vertex0[e];
                int v1 = vertex1[e];
                int v2 = vertex2[e];
                assert (hinge == v0 || hinge == v1 || hinge == v2) : hinge + " != " + v0 + ", " + v1 + ", " + v2;
                int n = e;
                int n2 = weight[n] - 1;
                weight[n] = n2;
                int update = -6 / weight[e] + 6 / n2;
                if (!isHinge[v0]) {
                    Orient3Hypergraph.increase(queue, posInQueue, priority, v0, update);
                }
                if (!isHinge[v1]) {
                    Orient3Hypergraph.increase(queue, posInQueue, priority, v1, update);
                }
                if (isHinge[v2]) continue;
                Orient3Hypergraph.increase(queue, posInQueue, priority, v2, update);
            }
            int v0 = vertex0[edge];
            int v1 = vertex1[edge];
            int v2 = vertex2[edge];
            assert (hinge == v0 || hinge == v1 || hinge == v2) : hinge + " != " + v0 + ", " + v1 + ", " + v2;
            int n = v0;
            d[n] = d[n] - 1;
            if (!isHinge[v0]) {
                Orient3Hypergraph.decrease(queue, posInQueue, priority, d, v0, weight[edge]);
            }
            int n3 = v1;
            d[n3] = d[n3] - 1;
            if (!isHinge[v1]) {
                Orient3Hypergraph.decrease(queue, posInQueue, priority, d, v1, weight[edge]);
            }
            int n4 = v2;
            d[n4] = d[n4] - 1;
            if (isHinge[v2]) continue;
            Orient3Hypergraph.decrease(queue, posInQueue, priority, d, v2, weight[edge]);
        }
        return true;
    }
}

