/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.AbstractLongBigList;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongBigListIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class EliasFanoMonotoneLongBigList
extends AbstractLongBigList
implements Serializable {
    private static final long serialVersionUID = 4L;
    protected final long length;
    protected final int l;
    protected transient long[] upperBits;
    protected long[] lowerBits;
    protected final SimpleSelect selectUpper;
    protected final long lowerBitsMask;

    public static boolean fits(long length, long upperBound) {
        int l = length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / length)));
        return length * (long)l < LongArrayBitVector.bits((int)0x7FFFFFF7);
    }

    protected EliasFanoMonotoneLongBigList(long length, int l, long[] upperBits, long[] lowerBits, SimpleSelect selectUpper) {
        this.length = length;
        this.l = l;
        this.upperBits = upperBits;
        this.lowerBits = lowerBits;
        this.selectUpper = selectUpper;
        this.lowerBitsMask = (1L << l) - 1L;
    }

    public EliasFanoMonotoneLongBigList(IntIterable list) {
        this(() -> LongIterators.wrap((IntIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigList(ShortIterable list) {
        this(() -> LongIterators.wrap((ShortIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigList(ByteIterable list) {
        this(() -> LongIterators.wrap((ByteIterator)list.iterator()));
    }

    public EliasFanoMonotoneLongBigList(LongIterable list) {
        this(EliasFanoMonotoneLongBigList.computeParameters(list.iterator()), list.iterator());
    }

    private static long[] computeParameters(LongIterator iterator) {
        long v = -1L;
        long prev = -1L;
        long c = 0L;
        while (iterator.hasNext()) {
            v = iterator.nextLong();
            if (prev > v) {
                throw new IllegalArgumentException("The list of values is not monotone: " + prev + " > " + v);
            }
            prev = v;
            ++c;
        }
        return new long[]{c, v};
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, ByteIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ByteIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, ShortIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((ShortIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, IntIterator iterator) {
        this(new long[]{n, upperBound}, LongIterators.wrap((IntIterator)iterator));
    }

    public EliasFanoMonotoneLongBigList(long n, long upperBound, LongIterator iterator) {
        this(new long[]{n, upperBound}, iterator);
    }

    protected EliasFanoMonotoneLongBigList(long[] a, LongIterator iterator) {
        this.length = a[0];
        long v = -1L;
        long upperBound = a[1];
        this.l = this.length == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(upperBound / this.length)));
        this.lowerBitsMask = (1L << this.l) - 1L;
        long lowerBitsMask = (1L << this.l) - 1L;
        LongArrayBitVector lowerBitsVector = LongArrayBitVector.getInstance();
        LongBigList lowerBitsList = lowerBitsVector.asLongBigList(this.l);
        lowerBitsList.size(this.length + 1L);
        LongArrayBitVector upperBits = LongArrayBitVector.getInstance().length(this.length + (upperBound >>> this.l) + 2L);
        long last = -1L;
        long finalUpperBound = upperBound;
        for (long i = 0L; i < this.length; ++i) {
            v = iterator.nextLong();
            if (v > upperBound) {
                throw new IllegalArgumentException("Too large value: " + v + " > " + upperBound);
            }
            if (v == finalUpperBound) {
                upperBits.length(this.length + (++finalUpperBound >>> this.l) + 2L);
            }
            if (v < last) {
                throw new IllegalArgumentException("Values are not nondecreasing: " + v + " < " + last);
            }
            if (this.l != 0) {
                lowerBitsList.set(i, v & lowerBitsMask);
            }
            upperBits.set((v >>> this.l) + i);
            last = v;
        }
        if (this.l != 0) {
            lowerBitsList.set(this.length, finalUpperBound & lowerBitsMask);
        }
        upperBits.set((finalUpperBound >>> this.l) + this.length);
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("There are more than " + this.length + " values in the provided iterator");
        }
        this.lowerBits = this.l == 0 ? new long[1] : lowerBitsVector.bits();
        this.upperBits = upperBits.bits();
        this.selectUpper = new SimpleSelect((BitVector)upperBits);
    }

    public long numBits() {
        return this.selectUpper.numBits() + this.selectUpper.bitVector().length() + LongArrayBitVector.bits((int)this.lowerBits.length);
    }

    public long getLong(long index) {
        assert (index >= 0L);
        assert (index < this.length);
        int l = this.l;
        long upperBits = this.selectUpper.select(index) - index;
        long position = index * (long)l;
        int startWord = LongArrayBitVector.word((long)position);
        int startBit = LongArrayBitVector.bit((long)position);
        long result = this.lowerBits[startWord] >>> startBit;
        return upperBits << l | (startBit + l <= 64 ? result : result | this.lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
    }

    public long getDelta(long index) {
        assert (index >= 0L);
        assert (index < this.length - 1L);
        long[] dest = new long[2];
        this.selectUpper.select(index, dest, 0, 2);
        int l = this.l;
        long[] lowerBits = this.lowerBits;
        long position = index * (long)l;
        int startWord = LongArrayBitVector.word((long)position);
        int startBit = LongArrayBitVector.bit((long)position);
        long first = lowerBits[startWord] >>> startBit;
        first = dest[0] - index++ << l | (startBit + l <= 64 ? first : first | lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
        startWord = LongArrayBitVector.word((long)(position += (long)l));
        startBit = LongArrayBitVector.bit((long)position);
        long second = lowerBits[startWord] >>> startBit;
        second = dest[1] - index << l | (startBit + l <= 64 ? second : second | lowerBits[startWord + 1] << -startBit) & this.lowerBitsMask;
        return second - first;
    }

    public long[] get(long index, long[] dest, int offset, int length) {
        assert (index >= 0L);
        assert (index < this.length);
        assert (offset >= 0);
        assert (offset < dest.length);
        assert (length >= 0);
        assert (offset + length <= dest.length);
        this.selectUpper.select(index, dest, offset, length);
        int l = this.l;
        long lowerBitsMask = this.lowerBitsMask;
        long[] lowerBits = this.lowerBits;
        long position = index * (long)l;
        for (int i = 0; i < length; ++i) {
            int startWord = LongArrayBitVector.word((long)position);
            int startBit = LongArrayBitVector.bit((long)position);
            long result = lowerBits[startWord] >>> startBit;
            dest[offset + i] = dest[offset + i] - index++ << l | (startBit + l <= 64 ? result : result | lowerBits[startWord + 1] << -startBit) & lowerBitsMask;
            position += (long)l;
        }
        return dest;
    }

    public long[] get(long index, long[] dest) {
        return this.get(index, dest, 0, dest.length);
    }

    public EliasFanoMonotoneLongBigListIterator listIterator(long from) {
        return new EliasFanoMonotoneLongBigListIterator(from);
    }

    public EliasFanoMonotoneLongBigListIterator listIterator() {
        return new EliasFanoMonotoneLongBigListIterator(0L);
    }

    public EliasFanoMonotoneLongBigListIterator iterator() {
        return this.listIterator();
    }

    public long size64() {
        return this.length;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.upperBits = this.selectUpper.bitVector().bits();
        if (this.lowerBits.length == 0) {
            this.lowerBits = new long[1];
        }
    }

    public class EliasFanoMonotoneLongBigListIterator
    implements LongBigListIterator {
        protected long index;
        protected int word;
        protected long window;
        protected long lowerBitsPosition;

        protected EliasFanoMonotoneLongBigListIterator(long from) {
            this.index = from;
            long position = EliasFanoMonotoneLongBigList.this.selectUpper.select(from);
            this.word = LongArrayBitVector.word((long)position);
            this.window = EliasFanoMonotoneLongBigList.this.upperBits[this.word] & -1L << (int)position;
            this.lowerBitsPosition = this.index * (long)EliasFanoMonotoneLongBigList.this.l;
        }

        private long getNextUpperBits() {
            while (this.window == 0L) {
                this.window = EliasFanoMonotoneLongBigList.this.upperBits[++this.word];
            }
            long upperBits = LongArrayBitVector.bits((int)this.word) + (long)Long.numberOfTrailingZeros(this.window) - this.index++;
            this.window &= this.window - 1L;
            return upperBits;
        }

        public long previousIndex() {
            return this.index - 1L;
        }

        public long nextIndex() {
            return this.index;
        }

        public boolean hasPrevious() {
            return this.index > 0L;
        }

        public boolean hasNext() {
            return this.index < EliasFanoMonotoneLongBigList.this.length;
        }

        public long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.nextLongUnsafe();
        }

        public long nextLongUnsafe() {
            int l = EliasFanoMonotoneLongBigList.this.l;
            int startWord = LongArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = EliasFanoMonotoneLongBigList.this.lowerBits[startWord] >>> startBit;
            if (startBit + l > 64) {
                lower |= EliasFanoMonotoneLongBigList.this.lowerBits[startWord + 1] << -startBit;
            }
            this.lowerBitsPosition += (long)l;
            return this.getNextUpperBits() << l | lower & EliasFanoMonotoneLongBigList.this.lowerBitsMask;
        }

        public long previousLong() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.previousLongUnsafe();
        }

        public long previousLongUnsafe() {
            int l = EliasFanoMonotoneLongBigList.this.l;
            --this.index;
            long position = EliasFanoMonotoneLongBigList.this.selectUpper.select(this.index);
            this.word = LongArrayBitVector.word((long)position);
            this.window = EliasFanoMonotoneLongBigList.this.upperBits[this.word] & -1L << (int)position;
            this.lowerBitsPosition = this.index * (long)l;
            int startWord = LongArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = EliasFanoMonotoneLongBigList.this.lowerBits[startWord] >>> startBit;
            if (startBit + l > 64) {
                lower |= EliasFanoMonotoneLongBigList.this.lowerBits[startWord + 1] << -startBit;
            }
            return position - this.index << l | lower & EliasFanoMonotoneLongBigList.this.lowerBitsMask;
        }
    }
}

