/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.util;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.bytes.ByteIterable;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongIterable;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongIterators;
import it.unimi.dsi.fastutil.shorts.ShortIterable;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.sux4j.util.EliasFanoMonotoneLongBigList;
import java.util.NoSuchElementException;

public class EliasFanoPrefixSumLongBigList
extends EliasFanoMonotoneLongBigList {
    private static final long serialVersionUID = 2L;
    private final BitVector upperBits;

    public EliasFanoPrefixSumLongBigList(LongIterable elements) {
        super(new CumulativeLongIterable(elements));
        this.upperBits = this.selectUpper.bitVector();
    }

    public EliasFanoPrefixSumLongBigList(IntIterable elements) {
        this(() -> LongIterators.wrap((IntIterator)elements.iterator()));
    }

    public EliasFanoPrefixSumLongBigList(ShortIterable elements) {
        this(() -> LongIterators.wrap((ShortIterator)elements.iterator()));
    }

    public EliasFanoPrefixSumLongBigList(ByteIterable elements) {
        this(() -> LongIterators.wrap((ByteIterator)elements.iterator()));
    }

    @Override
    public long getLong(long index) {
        return this.getDelta(index);
    }

    public long prefixSum(long index) {
        return super.getLong(index);
    }

    @Override
    public long size64() {
        return this.length - 1L;
    }

    @Override
    public EliasFanoPrefixSumLongBigListIterator listIterator(long from) {
        return new EliasFanoPrefixSumLongBigListIterator(from);
    }

    @Override
    public EliasFanoPrefixSumLongBigListIterator listIterator() {
        return this.listIterator(0L);
    }

    @Override
    public EliasFanoPrefixSumLongBigListIterator iterator() {
        return this.listIterator();
    }

    private static final class CumulativeLongIterable
    implements LongIterable {
        private final LongIterable iterable;

        public CumulativeLongIterable(LongIterable iterable) {
            this.iterable = iterable;
        }

        public LongIterator iterator() {
            return new LongIterator(){
                private final LongIterator iterator;
                private long prefixSum;
                private boolean lastToDo;
                {
                    this.iterator = iterable.iterator();
                    this.prefixSum = 0L;
                    this.lastToDo = true;
                }

                public boolean hasNext() {
                    return this.iterator.hasNext() || this.lastToDo;
                }

                public long nextLong() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    if (!this.iterator.hasNext() && this.lastToDo) {
                        this.lastToDo = false;
                        return this.prefixSum;
                    }
                    long result = this.prefixSum;
                    this.prefixSum += this.iterator.nextLong();
                    return result;
                }
            };
        }
    }

    public class EliasFanoPrefixSumLongBigListIterator
    extends EliasFanoMonotoneLongBigList.EliasFanoMonotoneLongBigListIterator {
        protected long last;
        protected long[] upperBits;

        protected EliasFanoPrefixSumLongBigListIterator(long from) {
            super(from);
            this.upperBits = EliasFanoPrefixSumLongBigList.this.upperBits.bits();
            int startWord = LongArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = EliasFanoPrefixSumLongBigList.this.lowerBits[startWord] >>> startBit;
            if (startBit + EliasFanoPrefixSumLongBigList.this.l > 64) {
                lower |= EliasFanoPrefixSumLongBigList.this.lowerBits[startWord + 1] << -startBit;
            }
            this.lowerBitsPosition += (long)EliasFanoPrefixSumLongBigList.this.l;
            this.last = LongArrayBitVector.bits((int)this.word) + (long)Long.numberOfTrailingZeros(this.window) - this.index++ << EliasFanoPrefixSumLongBigList.this.l | lower & EliasFanoPrefixSumLongBigList.this.lowerBitsMask;
            this.window &= this.window - 1L;
        }

        private long getNextUpperBits() {
            while (this.window == 0L) {
                this.window = this.upperBits[++this.word];
            }
            long upperBits = LongArrayBitVector.bits((int)this.word) + (long)Long.numberOfTrailingZeros(this.window) - this.index++;
            this.window &= this.window - 1L;
            return upperBits;
        }

        @Override
        public long previousIndex() {
            return this.index - 2L;
        }

        @Override
        public long nextIndex() {
            return this.index - 1L;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 1L;
        }

        @Override
        public boolean hasNext() {
            return this.index < EliasFanoPrefixSumLongBigList.this.length;
        }

        @Override
        public long nextLongUnsafe() {
            int startWord = LongArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = EliasFanoPrefixSumLongBigList.this.lowerBits[startWord] >>> startBit;
            if (startBit + EliasFanoPrefixSumLongBigList.this.l > 64) {
                lower |= EliasFanoPrefixSumLongBigList.this.lowerBits[startWord + 1] << -startBit;
            }
            this.lowerBitsPosition += (long)EliasFanoPrefixSumLongBigList.this.l;
            long curr = this.getNextUpperBits() << EliasFanoPrefixSumLongBigList.this.l | lower & EliasFanoPrefixSumLongBigList.this.lowerBitsMask;
            long result = curr - this.last;
            this.last = curr;
            return result;
        }

        @Override
        public long previousLongUnsafe() {
            this.index -= 2L;
            long position = EliasFanoPrefixSumLongBigList.this.selectUpper.select(this.index);
            this.word = LongArrayBitVector.word((long)position);
            this.window = this.upperBits[this.word] & -1L << (int)position;
            this.lowerBitsPosition = this.index * (long)EliasFanoPrefixSumLongBigList.this.l;
            int startWord = LongArrayBitVector.word((long)this.lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            long lower = EliasFanoPrefixSumLongBigList.this.lowerBits[startWord] >>> startBit;
            if (startBit + EliasFanoPrefixSumLongBigList.this.l > 64) {
                lower |= EliasFanoPrefixSumLongBigList.this.lowerBits[startWord + 1] << -startBit;
            }
            this.lowerBitsPosition += (long)EliasFanoPrefixSumLongBigList.this.l;
            this.last = position - this.index++ << EliasFanoPrefixSumLongBigList.this.l | lower & EliasFanoPrefixSumLongBigList.this.lowerBitsMask;
            this.window &= this.window - 1L;
            startWord = LongArrayBitVector.word((long)this.lowerBitsPosition);
            startBit = LongArrayBitVector.bit((long)this.lowerBitsPosition);
            lower = EliasFanoPrefixSumLongBigList.this.lowerBits[startWord] >>> startBit;
            if (startBit + EliasFanoPrefixSumLongBigList.this.l > 64) {
                lower |= EliasFanoPrefixSumLongBigList.this.lowerBits[startWord + 1] << -startBit;
            }
            while (this.window == 0L) {
                this.window = this.upperBits[++this.word];
            }
            long curr = LongArrayBitVector.bits((int)this.word) + (long)Long.numberOfTrailingZeros(this.window) - this.index << EliasFanoPrefixSumLongBigList.this.l | lower & EliasFanoPrefixSumLongBigList.this.lowerBitsMask;
            long result = curr - this.last;
            return result;
        }
    }
}

