/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.sux4j.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.bits.LongArrayBitVector;
import it.unimi.dsi.fastutil.longs.LongBigList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.sux4j.bits.AbstractRank;
import it.unimi.dsi.sux4j.bits.SimpleSelect;
import it.unimi.dsi.sux4j.bits.SimpleSelectZero;
import it.unimi.dsi.sux4j.bits.SparseSelect;
import java.io.IOException;
import java.io.ObjectInputStream;

public class SparseRank
extends AbstractRank {
    private static final long serialVersionUID = 2L;
    protected final long n;
    protected final long m;
    protected final int l;
    protected final long lowerLBitsMask;
    protected long[] lowerBits;
    protected final BitVector upperBits;
    protected final SimpleSelectZero selectZeroUpper;
    protected final boolean fromSelect;

    public SparseRank(long[] bits, long length) {
        this((BitVector)LongArrayBitVector.wrap((long[])bits, (long)length));
    }

    public SparseRank(BitVector bitVector) {
        this(bitVector.length(), bitVector.count(), (LongIterator)bitVector.asLongSet().iterator());
    }

    public SparseRank(long n, long m, LongIterator iterator) {
        long pos = -1L;
        this.n = n;
        this.m = m;
        this.l = m == 0L ? 0 : Math.max(0, Fast.mostSignificantBit((long)(n / m)));
        this.lowerLBitsMask = (1L << this.l) - 1L;
        LongArrayBitVector lowerBitsVector = LongArrayBitVector.getInstance();
        LongBigList lowerBitsList = lowerBitsVector.asLongBigList(this.l);
        lowerBitsList.size(m + 1L);
        this.upperBits = LongArrayBitVector.getInstance().length(m + 1L + (n >>> this.l) + 2L);
        int l = this.l;
        BitVector upperBits = this.upperBits;
        long lowerLBitsMask = this.lowerLBitsMask;
        long last = 0L;
        for (long i = 0L; i < m; ++i) {
            pos = iterator.nextLong();
            if (pos >= n) {
                throw new IllegalArgumentException("Too large bit position: " + pos + " >= " + n);
            }
            if (pos < last) {
                throw new IllegalArgumentException("Positions are not nondecreasing: " + pos + " < " + last);
            }
            if (l != 0) {
                lowerBitsList.set(i, pos & lowerLBitsMask);
            }
            upperBits.set((pos >>> l) + i);
            last = pos;
        }
        upperBits.set((n >>> l) + m);
        lowerBitsList.set(m, n & lowerLBitsMask);
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("There are more than " + m + " positions in the provided iterator");
        }
        this.lowerBits = l == 0 ? new long[1] : lowerBitsVector.bits();
        this.selectZeroUpper = new SimpleSelectZero(upperBits);
        this.fromSelect = false;
    }

    protected SparseRank(long n, long m, int l, long[] lowerBits, BitVector upperBits) {
        this.n = n;
        this.m = m;
        this.l = l;
        this.lowerLBitsMask = (1L << l) - 1L;
        this.lowerBits = lowerBits.length == 0 ? new long[1] : lowerBits;
        this.upperBits = upperBits;
        this.selectZeroUpper = new SimpleSelectZero(upperBits);
        this.fromSelect = true;
    }

    @Override
    public long rank(long pos) {
        assert (pos >= 0L);
        assert (pos <= this.n);
        BitVector upperBits = this.upperBits;
        long[] lowerBits = this.lowerBits;
        int l = this.l;
        long lowerLBitsMask = this.lowerLBitsMask;
        long posLowerBits = pos & lowerLBitsMask;
        long zerosToSkip = pos >>> l;
        long upperPos = this.selectZeroUpper.selectZero(zerosToSkip) - 1L;
        long rank = upperPos - zerosToSkip;
        long lowerBitsPosition = rank++ * (long)l;
        while (upperPos >= 0L && upperBits.getBoolean(upperPos)) {
            int startWord = LongArrayBitVector.word((long)lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)lowerBitsPosition);
            long lower = lowerBits[startWord] >>> startBit;
            if (startBit + l > 64) {
                lower |= lowerBits[startWord + 1] << -startBit;
            }
            if ((lower & lowerLBitsMask) < posLowerBits) {
                return rank;
            }
            --rank;
            --upperPos;
            lowerBitsPosition -= (long)l;
        }
        return rank;
    }

    @Override
    public long numBits() {
        return this.selectZeroUpper.numBits() + (this.fromSelect ? 0L : this.upperBits.length() + LongArrayBitVector.bits((int)this.lowerBits.length));
    }

    public SparseSelect getSelect() {
        return new SparseSelect(this.n, this.m, this.l, this.lowerBits, new SimpleSelect(this.upperBits));
    }

    @Override
    public BitVector bitVector() {
        LongArrayBitVector result = LongArrayBitVector.getInstance().length(this.n);
        long[] upperBits = this.upperBits.bits();
        long[] lowerBits = this.lowerBits;
        int l = this.l;
        long lowerLBitsMask = this.lowerLBitsMask;
        long m = this.m;
        int curr = 0;
        long window = upperBits[curr];
        long lowerBitsPosition = 0L;
        for (long i = 0L; i < m; ++i) {
            while (window == 0L) {
                window = upperBits[++curr];
            }
            long upper = LongArrayBitVector.bits((int)curr) + (long)Long.numberOfTrailingZeros(window) - i;
            int startWord = LongArrayBitVector.word((long)lowerBitsPosition);
            int startBit = LongArrayBitVector.bit((long)lowerBitsPosition);
            result.set(upper << l | (startBit <= 64 - l ? lowerBits[startWord] >>> startBit : lowerBits[startWord] >>> startBit | lowerBits[startWord + 1] << -startBit) & lowerLBitsMask);
            window &= window - 1L;
            lowerBitsPosition += (long)l;
        }
        return result;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.lowerBits.length == 0) {
            this.lowerBits = new long[1];
        }
    }
}

